/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.hi.logicobject.OSObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_CheckOS;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import org.xml.sax.SAXException;

public class HiParam_IsOSObject {
    private HiParm_CheckOS _param;

    public HiParam_IsOSObject(UnknownContent param) throws ConsoleException {
        this._param = new HiParm_CheckOS();
        try {
            this._param = (HiParm_CheckOS)AbstractSchema.readXML((byte[])param.getContent());
        }
        catch (SAXException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }

    public HiParam_IsOSObject() {
        this._param = this.createParam();
    }

    private HiParm_CheckOS createParam() {
        HiParm_CheckOS isos = new HiParm_CheckOS();
        isos.setOsMask("");
        return isos;
    }

    public HiParam_IsOSObject(HiParm_CheckOS param) {
        this._param = param;
    }

    public HiParm_CheckOS getHiParamIsOS() {
        return this._param;
    }

    public String getOSMask() {
        return this._param.getOsMask();
    }

    public boolean setOSMask(String newValue) {
        String oldValue = this.getOSMask();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) == 0) {
            return false;
        }
        this._param.setOsMask(newValue);
        return true;
    }

    public void addOS(String newOS) {
        try {
            String mask = this._param.getOsMask();
            IntegerSet osSet = new IntegerSet(mask, 16);
            IntegerSet newSet = new IntegerSet(newOS, 16);
            osSet.add(newSet);
            this._param.setOsMask(osSet.toString(16));
        }
        catch (BadFormatException e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public void addOS(IntegerSet newSet) {
        try {
            String mask = this._param.getOsMask();
            IntegerSet osSet = new IntegerSet(mask, 16);
            osSet.add(newSet);
            this._param.setOsMask(osSet.toString(16));
        }
        catch (BadFormatException e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public void deleteOS(String newOS) {
        try {
            IntegerSet newSet = new IntegerSet(newOS, 16);
            IntegerSet osSet = new IntegerSet(this._param.getOsMask(), 16);
            osSet.delete(newSet);
            this._param.setOsMask(osSet.toString(16));
        }
        catch (BadFormatException e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public void deleteOS(IntegerSet newSet) {
        try {
            IntegerSet osSet = new IntegerSet(this._param.getOsMask(), 16);
            osSet.delete(newSet);
            this._param.setOsMask(osSet.toString(16));
        }
        catch (BadFormatException e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public OSObject getOSObject() {
        String osMask = this._param.getOsMask();
        return new OSObject(osMask);
    }

    public boolean setOSObject(OSObject newValue) {
        OSObject oldValue = this.getOSObject();
        if (oldValue.equals(newValue)) {
            return false;
        }
        this._param.setOsMask(newValue.getOSString());
        return true;
    }
}

