/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.hi.logicobject.RestoreConditionObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.RestoreObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.ServicePackInfoObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.EnforceServicePackInstallation;
import com.sygate.scm.hi.library.HiParm_EnforceServicePack;
import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import java.util.HashMap;
import org.xml.sax.SAXException;

public class HiParam_EnforceServicePackObject {
    private HiParm_EnforceServicePack _param;

    public HiParam_EnforceServicePackObject(UnknownContent param) throws ConsoleException {
        this._param = new HiParm_EnforceServicePack();
        try {
            this._param = (HiParm_EnforceServicePack)AbstractSchema.readXML((byte[])param.getContent());
        }
        catch (SAXException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }

    public HiParam_EnforceServicePackObject() {
        HashMap<String, TopLevelObject> newObj = new HashMap<String, TopLevelObject>();
        try {
            this._param = PolicyHandler.getDefaultEnforceServicePack(newObj);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            this._param = this.createParam();
        }
    }

    private HiParm_EnforceServicePack createParam() {
        HiParm_EnforceServicePack param = new HiParm_EnforceServicePack();
        param.setOsMask("");
        param.setServicePackLevel("");
        EnforceServicePackInstallation install = new EnforceServicePackInstallation();
        param.setEnforceServicePackInstallation(install);
        return param;
    }

    public ConfigObject getSchemaObject() {
        return this._param;
    }

    public RestoreConditionObject getRestoreConditionObject() {
        Boolean noWait;
        Long waitTime = this._param.getOptDoNotReattemptRestorationFor();
        if (waitTime == null) {
            waitTime = 0L;
        }
        if ((noWait = this._param.getOptNoWaitForRestoration()) == null) {
            noWait = this._param.getDefNoWaitForRestoration();
        }
        return new RestoreConditionObject(noWait, waitTime);
    }

    public boolean setRestoreConditionObject(RestoreConditionObject newValue) {
        RestoreConditionObject oldValue = this.getRestoreConditionObject();
        if (oldValue.equals(newValue)) {
            return false;
        }
        this._param.setOptDoNotReattemptRestorationFor(Long.valueOf(newValue.getWaitTime()));
        this._param.setOptNoWaitForRestoration(Boolean.valueOf(newValue.getEnableDontWait()));
        return true;
    }

    public RestoreObject getExeRestoreObject() {
        Boolean enableDownload;
        EnforceServicePackInstallation avInstall = this._param.getEnforceServicePackInstallation();
        Boolean enable = avInstall.getOptInstallServicePackOnDemand();
        if (enable == null) {
            enable = avInstall.getDefInstallServicePackOnDemand();
        }
        if ((enableDownload = avInstall.getOptEnableDownloadUrl()) == null) {
            enableDownload = avInstall.getDefEnableDownloadUrl();
        }
        String dwURL = avInstall.getOptDownloadUrl();
        Boolean enableCmd = avInstall.getOptEnableInstallServicePackCmd();
        if (enableCmd == null) {
            enableCmd = avInstall.getDefEnableInstallServicePackCmd();
        }
        String exeLine = avInstall.getOptInstallServicePackCmd();
        return new RestoreObject(enable, enableDownload, dwURL, enableCmd, exeLine);
    }

    public boolean setExeRestoreObject(RestoreObject newValue) {
        RestoreObject oldValue = this.getExeRestoreObject();
        if (oldValue.equals(newValue)) {
            return false;
        }
        EnforceServicePackInstallation avInstall = this._param.getEnforceServicePackInstallation();
        avInstall.setOptInstallServicePackOnDemand(Boolean.valueOf(newValue.getEnable()));
        avInstall.setOptEnableDownloadUrl(Boolean.valueOf(newValue.getEnableDownload()));
        avInstall.setOptEnableInstallServicePackCmd(Boolean.valueOf(newValue.getEnableExe()));
        avInstall.setOptDownloadUrl(newValue.getDownloadURL());
        avInstall.setOptInstallServicePackCmd(newValue.getCmd());
        return true;
    }

    public ServicePackInfoObject getServicePackInfo() {
        String serviceLevel = this._param.getServicePackLevel();
        String osMask = this._param.getOsMask();
        return new ServicePackInfoObject(serviceLevel, osMask);
    }

    public boolean setServicePackInfo(ServicePackInfoObject newValue) {
        ServicePackInfoObject oldValue = this.getServicePackInfo();
        if (oldValue.equals(newValue)) {
            return false;
        }
        this._param.setServicePackLevel(newValue.getServiceNumber());
        this._param.setOsMask(newValue.getOSObject().getOSString());
        return true;
    }

    public void setParameter(UnknownContent parameter) throws ConsoleException {
        try {
            this._param = (HiParm_EnforceServicePack)AbstractSchema.readXML((byte[])parameter.getContent());
        }
        catch (SAXException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }
}

