/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.hi.customized.CheckServicePackPanel;
import com.sygate.scm.console.ui.policy.hi.customized.CheckTimestampPanel;
import com.sygate.scm.console.ui.policy.hi.customized.FileDownloadPanel;
import com.sygate.scm.console.ui.policy.hi.customized.LogPanel;
import com.sygate.scm.console.ui.policy.hi.customized.OSExistPanel;
import com.sygate.scm.console.ui.policy.hi.customized.OSLanguagePanel;
import com.sygate.scm.console.ui.policy.hi.customized.PopupPanel;
import com.sygate.scm.console.ui.policy.hi.customized.RunPanel;
import com.sygate.scm.console.ui.policy.hi.customized.RunScriptPanel;
import com.sygate.scm.console.ui.policy.hi.customized.SetTimerPanel;
import com.sygate.scm.console.ui.policy.hi.customized.SleepPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FileAgePanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FileChecksumPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FileDatePanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FileExistPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FileSizePanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FileVersionPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning.CheckAswInstallationPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning.CheckAswRunningPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning.CheckAvInfectedPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning.CheckAvInstallationPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning.CheckAvRunningPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning.CheckFwInstallationPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning.CheckFwRunningPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkpatchprocessservice.CheckPatchInstallationPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkpatchprocessservice.CheckProcessPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkpatchprocessservice.CheckServerRunningPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkregistry.CheckRegistryValuePanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkregistry.IncrementRegistryValuePanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkregistry.RegistryKeyExistsPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkregistry.RegistryValueExistsPanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkregistry.SetRegistryValuePanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkuptodate.CheckAswUpToDatePanel;
import com.sygate.scm.console.ui.policy.hi.customized.checkuptodate.CheckAvUpToDatePanel;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAswInstallationObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAswRunningObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAswUpToDateObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAvInfectedObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAvInstallationObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAvRunningObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAvUpToDateObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckFwInstallationObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckFwRunningObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckOSLanguage;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckPatchObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckProcessObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckServiceObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckServicePackObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileAgeObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileChecksumEqualToObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileDateCompareObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileDownloadObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileExistObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileSizeCompareObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileVersionObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_IsOSObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_LogObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_PopupObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RegistryIncrementValueObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RegistryKeyExistObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RegistrySetValueObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RegistryValueExistObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RegistryValueObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RunObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RunScriptObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_SaveTimeObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_SavedTimePeriodObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_SleepObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.StringUtilities;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FunctionType
implements Comparable<FunctionType> {
    public static final int COND_CHECK_OS = 0;
    public static final int COND_CHECK_PROCESS = 1;
    public static final int COND_CHECK_SERVICE = 2;
    public static final int COND_POPUP = 3;
    public static final int COND_CHECK_OS_LANGUAGE = 4;
    public static final int COND_CHECK_SERVICE_PACK = 5;
    public static final int COND_FILE_EXIST = 6;
    public static final int COND_FILE_CHECKSUM_EQUAL_TO = 7;
    public static final int COND_FILE_SIZE_COMPARE = 8;
    public static final int COND_FILE_DATE_COMPARE = 9;
    public static final int COND_FILE_AGE = 10;
    public static final int COND_FILE_VERSION = 11;
    public static final int COND_FILE_DOWNLOAD = 12;
    public static final int COND_REGISTRY_KEY_EXIST = 13;
    public static final int COND_REGISTRY_VALUE_EXIST = 14;
    public static final int COND_REGISTRY_VALUE = 15;
    public static final int COND_REGISTRY_SET_VALUE = 16;
    public static final int COND_REGISTRY_INCREMENT_VALUE = 17;
    public static final int COND_CHECK_AV_INSTALLATION = 18;
    public static final int COND_CHECK_AV_RUNNING = 19;
    public static final int COND_CHECK_AV_UPTODATE = 20;
    public static final int COND_CHECK_PATCH = 21;
    public static final int COND_SAVED_TIME_PERIOD_COMPARE = 22;
    public static final int COND_CHECK_ASW_INSTALLATION = 23;
    public static final int COND_CHECK_ASW_RUNNING = 24;
    public static final int COND_CHECK_ASW_UPTODATE = 25;
    public static final int COND_CHECK_FW_INSTALLATION = 26;
    public static final int COND_CHECK_FW_RUNNING = 27;
    public static final int FUNC_LOG = 28;
    public static final int FUNC_SLEEP = 29;
    public static final int FUNC_POPUP = 30;
    public static final int FUNC_RUN = 31;
    public static final int FUNC_RUN_SCRIPT = 32;
    public static final int FUNC_FILE_DOWNLOAD = 33;
    public static final int FUNC_REGISTRY_SET_VALUE = 34;
    public static final int FUNC_REGISTRY_INCREMENT_VALUE = 35;
    public static final int FUNC_SAVE_TIME = 36;
    public static final int COND_CHECK_AV_INFECTED = 37;
    public static final int ANTIVIRUS_PRIORITY = 1;
    public static final int ANTISPYWARE_PRIORITY = 2;
    public static final int FIREWALL_PRIORITY = 3;
    public static final int PATCH_PRIORITY = 4;
    public static final int FILE_PRIORITY = 5;
    public static final int REGISTRY_PRIORITY = 6;
    public static final int UTILITY_PRIORITY = 7;
    private static FunctionType CHECK_FILE_EXIST = new FunctionType(6, 5);
    private static FunctionType CHECK_FILE_CHECKSUM = new FunctionType(7, 5);
    private static FunctionType CHECK_FILE_SIZE = new FunctionType(8, 5);
    private static FunctionType CHECK_FILE_DATE = new FunctionType(9, 5);
    private static FunctionType CHECK_FILE_AGE = new FunctionType(10, 5);
    private static FunctionType CHECK_FILE_VERSION = new FunctionType(11, 5);
    private static final FunctionType[] CONDITION_FUNC_TYPE = new FunctionType[]{new FunctionType(0, 7), new FunctionType(1, 7), new FunctionType(2, 7), new FunctionType(3, 7), new FunctionType(4, 7), new FunctionType(5, 4), CHECK_FILE_EXIST, CHECK_FILE_CHECKSUM, CHECK_FILE_SIZE, CHECK_FILE_DATE, CHECK_FILE_AGE, CHECK_FILE_VERSION, new FunctionType(12, 5), new FunctionType(13, 6, 1), new FunctionType(14, 6, 2), new FunctionType(15, 6, 3), new FunctionType(16, 6, 4), new FunctionType(17, 6, 5), new FunctionType(18, 1), new FunctionType(19, 1), new FunctionType(37, 1), new FunctionType(20, 1), new FunctionType(21, 4), new FunctionType(22, 7), new FunctionType(23, 2), new FunctionType(24, 2), new FunctionType(25, 2), new FunctionType(26, 3), new FunctionType(27, 3)};
    private static final FunctionType[] CONDITION_FUNC_TYPE_MAC = new FunctionType[]{new FunctionType(0, 7), new FunctionType(1, 7), new FunctionType(2, 7), CHECK_FILE_EXIST, CHECK_FILE_CHECKSUM, CHECK_FILE_SIZE, CHECK_FILE_DATE, CHECK_FILE_AGE, new FunctionType(12, 5), new FunctionType(18, 1), new FunctionType(19, 1), new FunctionType(20, 1), new FunctionType(22, 7), new FunctionType(26, 3), new FunctionType(27, 3)};
    private static final FunctionType[] EXE_FUNC_TYPE = new FunctionType[]{new FunctionType(33), new FunctionType(34), new FunctionType(35), new FunctionType(28), new FunctionType(31), new FunctionType(32), new FunctionType(36), new FunctionType(30), new FunctionType(29)};
    private static final FunctionType[] MAC_EXE_FUNC_TYPE = new FunctionType[]{new FunctionType(33), new FunctionType(31), new FunctionType(32), new FunctionType(36), new FunctionType(30), new FunctionType(29)};
    private int type;
    private HiParamPanelInt showPanel;
    private ConfigObject parameter;
    private static Map<String, String> exeFuncMap = new HashMap<String, String>();
    private int sortPriority;
    private int functionItemPriority;
    private static final Map<String, Integer> ConditionTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> FunctionTypeMap = new HashMap<String, Integer>();
    public static final int INVALIDE_TYPE = -11;

    public static FunctionType[] getConditionFuncType() {
        return (FunctionType[])CONDITION_FUNC_TYPE.clone();
    }

    public static FunctionType[] getConditionFuncTypeMac() {
        return (FunctionType[])CONDITION_FUNC_TYPE_MAC.clone();
    }

    public static FunctionType[] getExeFuncType() {
        return (FunctionType[])EXE_FUNC_TYPE.clone();
    }

    public static FunctionType getExeFuncTypeByIndex(int index) {
        int exe_func_type_count = EXE_FUNC_TYPE.length;
        if (index < 0 || index > exe_func_type_count - 1) {
            return null;
        }
        return EXE_FUNC_TYPE[index];
    }

    public static FunctionType[] getMacExeFuncType() {
        return (FunctionType[])MAC_EXE_FUNC_TYPE.clone();
    }

    public static FunctionType getMacExeFuncTypeByIndex(int index) {
        int mac_exe_func_type_count = MAC_EXE_FUNC_TYPE.length;
        if (index < 0 || index > mac_exe_func_type_count - 1) {
            return null;
        }
        return MAC_EXE_FUNC_TYPE[index];
    }

    public FunctionType(int type) {
        this.type = type;
    }

    public FunctionType(int type, int sortPriority) {
        this.type = type;
        this.sortPriority = sortPriority;
    }

    public FunctionType(int type, int sortPriority, int functionItemPriority) {
        this.type = type;
        this.sortPriority = sortPriority;
        this.functionItemPriority = functionItemPriority;
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    public String getFuncName() {
        switch (this.type) {
            case 0: {
                return "CheckOS";
            }
            case 1: {
                return "CheckProcess";
            }
            case 2: {
                return "CheckService";
            }
            case 3: {
                return "Popup";
            }
            case 4: {
                return "CheckOSLanguage";
            }
            case 5: {
                return "CheckServicePack";
            }
            case 6: {
                return "FileExist";
            }
            case 7: {
                return "FileChecksumEqualTo";
            }
            case 8: {
                return "FileSizeCompare";
            }
            case 9: {
                return "FileDateCompare";
            }
            case 10: {
                return "FileAge";
            }
            case 11: {
                return "FileVersion";
            }
            case 12: {
                return "FileDownload";
            }
            case 13: {
                return "RegistryKeyExist";
            }
            case 14: {
                return "RegistryValueExist";
            }
            case 15: {
                return "RegistryValue";
            }
            case 16: {
                return "RegistrySetValue";
            }
            case 17: {
                return "RegistryIncrementValue";
            }
            case 18: {
                return "CheckAvInstallation";
            }
            case 19: {
                return "CheckAvRunning";
            }
            case 20: {
                return "CheckAvUpToDate";
            }
            case 21: {
                return "CheckPatch";
            }
            case 22: {
                return "SavedTimePeriodCompare";
            }
            case 23: {
                return "CheckAswInstallation";
            }
            case 24: {
                return "CheckAswRunning";
            }
            case 25: {
                return "CheckAswUpToDate";
            }
            case 26: {
                return "CheckFwInstallation";
            }
            case 27: {
                return "CheckFwRunning";
            }
            case 28: {
                return "Log";
            }
            case 29: {
                return "Sleep";
            }
            case 30: {
                return "Popup";
            }
            case 31: {
                return "Run";
            }
            case 32: {
                return "RunScript";
            }
            case 33: {
                return "FileDownload";
            }
            case 34: {
                return "RegistrySetValue";
            }
            case 35: {
                return "RegistryIncrementValue";
            }
            case 36: {
                return "SaveTime";
            }
            case 37: {
                return "CheckAvInfected";
            }
        }
        return null;
    }

    public String getTypeDesc() {
        switch (this.type) {
            case 0: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescCheckOS");
            }
            case 1: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescCheckProcess");
            }
            case 2: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescCheckService");
            }
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescPopup");
            }
            case 4: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescCheckOSLang");
            }
            case 5: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescCheckPatch");
            }
            case 6: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFileExists");
            }
            case 7: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFingerprint");
            }
            case 8: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFileSize");
            }
            case 9: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFileDate");
            }
            case 10: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFileAge");
            }
            case 11: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFileVersion");
            }
            case 12: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFileDownloadComplete");
            }
            case 13: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescRegKeyExists");
            }
            case 14: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescRegValExists");
            }
            case 15: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescRegValEquals");
            }
            case 16: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescSetRegValue");
            }
            case 17: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescRegIncDWORD");
            }
            case 18: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescAVInstalled");
            }
            case 19: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescAVRunning");
            }
            case 20: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescAVUpToDate");
            }
            case 21: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescPatchInstalled");
            }
            case 22: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescUtilCheckTimestamp");
            }
            case 23: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescASInstalled");
            }
            case 24: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescASRunning");
            }
            case 25: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescASUpToDate");
            }
            case 26: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFWInstalled");
            }
            case 27: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFWRunning");
            }
            case 28: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescUtilLogMsg");
            }
            case 29: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescUtilWait");
            }
            case 30: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescUtilShowMsgDlg");
            }
            case 31: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescUtilRunProg");
            }
            case 32: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescUtilRunScript");
            }
            case 33: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescFileDownload");
            }
            case 34: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescRegSetVal");
            }
            case 35: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescIncRegDWORD");
            }
            case 36: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescUtilSetTimestamp");
            }
            case 37: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "FunctionType.DescAVInfected");
            }
        }
        return null;
    }

    public byte[] getParameter() throws ConsoleException, IOException, ValidationException {
        if (this.parameter == null) {
            switch (this.type) {
                case 0: {
                    this.parameter = new HiParam_IsOSObject().getHiParamIsOS();
                    break;
                }
                case 1: {
                    this.parameter = new HiParam_CheckProcessObject().getSchemaObject();
                    break;
                }
                case 2: {
                    this.parameter = new HiParam_CheckServiceObject().getSchemaObject();
                    break;
                }
                case 3: {
                    this.parameter = new HiParam_PopupObject().getSchemaObject();
                    break;
                }
                case 4: {
                    this.parameter = new HiParam_CheckOSLanguage().getSchemaObject();
                    break;
                }
                case 5: {
                    this.parameter = new HiParam_CheckServicePackObject().getSchemaObject();
                    break;
                }
                case 6: {
                    this.parameter = new HiParam_FileExistObject().getSchemaObject();
                    break;
                }
                case 7: {
                    this.parameter = new HiParam_FileChecksumEqualToObject().getSchemaObject();
                    break;
                }
                case 8: {
                    this.parameter = new HiParam_FileSizeCompareObject().getSchemaObject();
                    break;
                }
                case 9: {
                    this.parameter = new HiParam_FileDateCompareObject().getSchemaObject();
                    break;
                }
                case 10: {
                    this.parameter = new HiParam_FileAgeObject().getSchemaObject();
                    break;
                }
                case 11: {
                    this.parameter = new HiParam_FileVersionObject().getSchemaObject();
                    break;
                }
                case 12: {
                    this.parameter = new HiParam_FileDownloadObject().getSchemaObject();
                    break;
                }
                case 13: {
                    this.parameter = new HiParam_RegistryKeyExistObject().getSchemaObject();
                    break;
                }
                case 14: {
                    this.parameter = new HiParam_RegistryValueExistObject().getSchemaObject();
                    break;
                }
                case 15: {
                    this.parameter = new HiParam_RegistryValueObject().getSchemaObject();
                    break;
                }
                case 16: {
                    this.parameter = new HiParam_RegistrySetValueObject().getSchemaObject();
                    break;
                }
                case 17: {
                    this.parameter = new HiParam_RegistryIncrementValueObject().getSchemaObject();
                    break;
                }
                case 18: {
                    this.parameter = new HiParam_CheckAvInstallationObject().getSchemaObject();
                    break;
                }
                case 19: {
                    this.parameter = new HiParam_CheckAvRunningObject().getSchemaObject();
                    break;
                }
                case 20: {
                    this.parameter = new HiParam_CheckAvUpToDateObject().getSchemaObject();
                    break;
                }
                case 21: {
                    this.parameter = new HiParam_CheckPatchObject().getSchemaObject();
                    break;
                }
                case 22: {
                    this.parameter = new HiParam_SavedTimePeriodObject().getSchemaObject();
                    break;
                }
                case 23: {
                    this.parameter = new HiParam_CheckAswInstallationObject().getSchemaObject();
                    break;
                }
                case 24: {
                    this.parameter = new HiParam_CheckAswRunningObject().getSchemaObject();
                    break;
                }
                case 25: {
                    this.parameter = new HiParam_CheckAswUpToDateObject().getSchemaObject();
                    break;
                }
                case 26: {
                    this.parameter = new HiParam_CheckFwInstallationObject().getSchemaObject();
                    break;
                }
                case 27: {
                    this.parameter = new HiParam_CheckFwRunningObject().getSchemaObject();
                    break;
                }
                case 28: {
                    this.parameter = new HiParam_LogObject().getSchemaObject();
                    break;
                }
                case 29: {
                    this.parameter = new HiParam_SleepObject().getSchemaObject();
                    break;
                }
                case 30: {
                    this.parameter = new HiParam_PopupObject().getSchemaObject();
                    break;
                }
                case 31: {
                    this.parameter = new HiParam_RunObject().getSchemaObject();
                    break;
                }
                case 32: {
                    this.parameter = new HiParam_RunScriptObject().getSchemaObject();
                    break;
                }
                case 33: {
                    this.parameter = new HiParam_FileDownloadObject().getSchemaObject();
                    break;
                }
                case 34: {
                    this.parameter = new HiParam_RegistrySetValueObject().getSchemaObject();
                    break;
                }
                case 35: {
                    this.parameter = new HiParam_RegistryIncrementValueObject().getSchemaObject();
                    break;
                }
                case 36: {
                    this.parameter = new HiParam_SaveTimeObject().getSchemaObject();
                    break;
                }
                case 37: {
                    this.parameter = new HiParam_CheckAvInfectedObject().getSchemaObject();
                    break;
                }
            }
        }
        ConfigObject copy = PolicyHandler.getCopyOfObj(this.parameter);
        copy.init();
        return copy.getBytes();
    }

    public HiParamPanelInt getPanel(String clientType) {
        switch (this.type) {
            case 0: {
                this.showPanel = new OSExistPanel(clientType);
                break;
            }
            case 1: {
                this.showPanel = new CheckProcessPanel(clientType);
                break;
            }
            case 2: {
                this.showPanel = new CheckServerRunningPanel();
                break;
            }
            case 3: {
                this.showPanel = new PopupPanel();
                break;
            }
            case 4: {
                this.showPanel = new OSLanguagePanel();
                break;
            }
            case 5: {
                this.showPanel = new CheckServicePackPanel();
                break;
            }
            case 6: {
                this.showPanel = new FileExistPanel(clientType);
                break;
            }
            case 7: {
                this.showPanel = new FileChecksumPanel(clientType);
                break;
            }
            case 8: {
                this.showPanel = new FileSizePanel(clientType);
                break;
            }
            case 9: {
                this.showPanel = new FileDatePanel(clientType);
                break;
            }
            case 10: {
                this.showPanel = new FileAgePanel(clientType);
                break;
            }
            case 11: {
                this.showPanel = new FileVersionPanel(clientType);
                break;
            }
            case 12: {
                this.showPanel = new FileDownloadPanel(clientType);
                break;
            }
            case 13: {
                this.showPanel = new RegistryKeyExistsPanel();
                break;
            }
            case 14: {
                this.showPanel = new RegistryValueExistsPanel();
                break;
            }
            case 15: {
                this.showPanel = new CheckRegistryValuePanel();
                break;
            }
            case 16: {
                this.showPanel = new SetRegistryValuePanel();
                break;
            }
            case 17: {
                this.showPanel = new IncrementRegistryValuePanel();
                break;
            }
            case 18: {
                this.showPanel = new CheckAvInstallationPanel();
                break;
            }
            case 19: {
                this.showPanel = new CheckAvRunningPanel();
                break;
            }
            case 20: {
                this.showPanel = new CheckAvUpToDatePanel(clientType);
                break;
            }
            case 21: {
                this.showPanel = new CheckPatchInstallationPanel();
                break;
            }
            case 22: {
                this.showPanel = new CheckTimestampPanel();
                break;
            }
            case 23: {
                this.showPanel = new CheckAswInstallationPanel(clientType);
                break;
            }
            case 24: {
                this.showPanel = new CheckAswRunningPanel(clientType);
                break;
            }
            case 25: {
                this.showPanel = new CheckAswUpToDatePanel(clientType);
                break;
            }
            case 26: {
                this.showPanel = new CheckFwInstallationPanel();
                break;
            }
            case 27: {
                this.showPanel = new CheckFwRunningPanel();
                break;
            }
            case 28: {
                this.showPanel = new LogPanel();
                break;
            }
            case 29: {
                this.showPanel = new SleepPanel();
                break;
            }
            case 30: {
                this.showPanel = new PopupPanel();
                break;
            }
            case 31: {
                this.showPanel = new RunPanel(clientType);
                break;
            }
            case 32: {
                this.showPanel = new RunScriptPanel(clientType);
                break;
            }
            case 33: {
                this.showPanel = new FileDownloadPanel(clientType);
                break;
            }
            case 34: {
                this.showPanel = new SetRegistryValuePanel();
                break;
            }
            case 35: {
                this.showPanel = new IncrementRegistryValuePanel();
                break;
            }
            case 36: {
                this.showPanel = new SetTimerPanel();
                break;
            }
            case 37: {
                this.showPanel = new CheckAvInfectedPanel();
                break;
            }
        }
        return this.showPanel;
    }

    public void resetPanel() {
        this.showPanel = null;
    }

    @Override
    public int compareTo(FunctionType obj) {
        if (this.sortPriority < obj.sortPriority) {
            return -1;
        }
        if (this.sortPriority > obj.sortPriority) {
            return 1;
        }
        if (this.functionItemPriority < obj.functionItemPriority) {
            return -1;
        }
        if (this.functionItemPriority > obj.functionItemPriority) {
            return 1;
        }
        String typeDesc = obj.getTypeDesc();
        return this.getTypeDesc().compareToIgnoreCase(typeDesc);
    }

    public boolean equals(FunctionType type) {
        return this.getFuncName().equals(type.getFuncName());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getTypeDesc();
    }

    public static boolean isCondition(String funcName) {
        return !FunctionType.isStatement(funcName);
    }

    public static boolean isStatement(String funcName) {
        return exeFuncMap.get(funcName) != null;
    }

    public static void resetConditionFuncPanel() {
        CHECK_FILE_EXIST.resetPanel();
        CHECK_FILE_CHECKSUM.resetPanel();
        CHECK_FILE_SIZE.resetPanel();
        CHECK_FILE_DATE.resetPanel();
        CHECK_FILE_AGE.resetPanel();
        CHECK_FILE_VERSION.resetPanel();
    }

    public int getType() {
        return this.type;
    }

    public static int getFunctionTypeByName(String name) {
        Integer type;
        if (!StringUtilities.isEmpty((String)name) && (type = FunctionTypeMap.get(name)) != null) {
            return type;
        }
        return -11;
    }

    public static int getConditionTypeByName(String name) {
        Integer type;
        if (!StringUtilities.isEmpty((String)name) && (type = ConditionTypeMap.get(name)) != null) {
            return type;
        }
        return -11;
    }

    private static void init() {
        for (int i = 0; i < EXE_FUNC_TYPE.length; ++i) {
            exeFuncMap.put(EXE_FUNC_TYPE[i].getFuncName(), "");
        }
    }

    static {
        Arrays.sort(CONDITION_FUNC_TYPE);
        Arrays.sort(CONDITION_FUNC_TYPE_MAC);
        FunctionType.init();
        ConditionTypeMap.put("CheckOS", 0);
        ConditionTypeMap.put("CheckProcess", 1);
        ConditionTypeMap.put("CheckService", 2);
        ConditionTypeMap.put("Popup", 3);
        ConditionTypeMap.put("CheckOSLanguage", 4);
        ConditionTypeMap.put("CheckServicePack", 5);
        ConditionTypeMap.put("FileExist", 6);
        ConditionTypeMap.put("FileChecksumEqualTo", 7);
        ConditionTypeMap.put("FileSizeCompare", 8);
        ConditionTypeMap.put("FileDateCompare", 9);
        ConditionTypeMap.put("FileAge", 10);
        ConditionTypeMap.put("FileVersion", 11);
        ConditionTypeMap.put("FileDownload", 12);
        ConditionTypeMap.put("RegistryKeyExist", 13);
        ConditionTypeMap.put("RegistryValueExist", 14);
        ConditionTypeMap.put("RegistryValue", 15);
        ConditionTypeMap.put("RegistrySetValue", 16);
        ConditionTypeMap.put("RegistryIncrementValue", 17);
        ConditionTypeMap.put("CheckAvInstallation", 18);
        ConditionTypeMap.put("CheckAvRunning", 19);
        ConditionTypeMap.put("CheckAvInfected", 37);
        ConditionTypeMap.put("CheckAvUpToDate", 20);
        ConditionTypeMap.put("CheckPatch", 21);
        ConditionTypeMap.put("SavedTimePeriodCompare", 22);
        ConditionTypeMap.put("CheckAswInstallation", 23);
        ConditionTypeMap.put("CheckAswRunning", 24);
        ConditionTypeMap.put("CheckAswUpToDate", 25);
        ConditionTypeMap.put("CheckFwInstallation", 26);
        ConditionTypeMap.put("CheckFwRunning", 27);
        FunctionTypeMap.put("Log", 28);
        FunctionTypeMap.put("Sleep", 29);
        FunctionTypeMap.put("Popup", 30);
        FunctionTypeMap.put("Run", 31);
        FunctionTypeMap.put("RunScript", 32);
        FunctionTypeMap.put("FileDownload", 33);
        FunctionTypeMap.put("RegistrySetValue", 34);
        FunctionTypeMap.put("RegistryIncrementValue", 35);
        FunctionTypeMap.put("SaveTime", 36);
    }
}

