/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkuptodate;

import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.ui.util.CalendarButton;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.AvSignatureAgeCriteria;
import com.sygate.scm.hi.library.AvSignatureDateCriteria;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public abstract class CheckUptoDatePanelBase
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 4254873320506078244L;
    static final Integer[] AGE_VALUES = new Integer[]{AvSignatureAgeCriteria.NOT_EQUAL, AvSignatureAgeCriteria.EQUAL, AvSignatureAgeCriteria.LESS_THAN, AvSignatureAgeCriteria.GREATER_THAN};
    static final Integer[] DATE_VALUES = new Integer[]{AvSignatureDateCriteria.NOT_EQUAL, AvSignatureDateCriteria.EQUAL, AvSignatureDateCriteria.LESS_THAN, AvSignatureDateCriteria.GREATER_THAN};
    protected JLabel jLTitle = new JLabel();
    protected JLabel jLName = new JLabel();
    protected JComboBox<HiPredefinedType> jCmbName = new JComboBox();
    protected JCheckBox jCbxAge = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.checkbox.SigFileLessThan"));
    protected JComboBox<String> jCmbAge = new JComboBox<String>(new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.combo.NotEqualTo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.combo.EqualTo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.combo.Before"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.combo.After")});
    protected JTextField jTFAge = new JTextField(5);
    protected JCheckBox jCbxDate = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.checkbox.SigFileDate"));
    protected JRadioButton jrbNotEqualTo = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.checkbox.SigFileDateNoEqual"));
    protected JRadioButton jrbEqualTo = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.checkbox.SigFileDateEqual"));
    protected JRadioButton jrbBefore = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.checkbox.SigFileDateBefore"));
    protected JRadioButton jrbAfter = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.checkbox.SigFileDateAfter"));
    protected ButtonGroup buttonGroup = new ButtonGroup();
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    protected CalendarButton[] calendarButton = new CalendarButton[]{new CalendarButton(this.timePattern), new CalendarButton(this.timePattern), new CalendarButton(this.timePattern), new CalendarButton(this.timePattern)};
    private ActionListener ageListener;
    private ActionListener dateListener;
    private String clientType;
    protected HiCALLObject callObj;

    protected CheckUptoDatePanelBase(String clientType) {
        this.clientType = clientType;
        this.initialize();
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.clientType = call.getClientType();
            this.setUptoDateObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        if (!this.jCbxAge.isSelected() && !this.jCbxDate.isSelected()) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.error.NoAgeOrDate"), this.jTFAge);
        }
        if (this.jCbxAge.isSelected()) {
            String strAge = this.jTFAge.getText().trim();
            if (strAge.length() == 0) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.error.NoAge"), this.jTFAge);
            }
            long age = Long.parseLong(strAge);
            if (age == 0L) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.error.SigFileAgeGTZero"), this.jTFAge);
            }
        }
        try {
            this.updateCallObject();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckUptoDatePanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    protected abstract void setUptoDateObject(UnknownContent var1) throws ConsoleException;

    protected abstract void updateCallObject() throws ConsoleException;

    protected abstract String getTypeString();

    protected abstract long getAgeValue();

    protected abstract int getAgeOperator();

    protected abstract boolean getAgeEnable();

    protected abstract long getDateValue();

    protected abstract long getTimeValue();

    protected abstract int getDateOperator();

    protected abstract boolean getDateEnable();

    protected abstract boolean getHasTimeZone();

    protected abstract HiPredefinedType[] getAvailableTypes();

    private void initialize() {
        this.initListeners();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jLTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(this.jCmbName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getAgePanel(), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getDatePanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getAgePanel() {
        this.jCbxAge.addActionListener(this.ageListener);
        this.jCmbAge.addActionListener(this.ageListener);
        NumberPlainDocument ageDoc = new NumberPlainDocument(18200L);
        this.jTFAge.setDocument(ageDoc);
        this.jTFAge.setMaximumSize(this.jTFAge.getPreferredSize());
        this.jTFAge.setHorizontalAlignment(4);
        JPanel agePanel = new JPanel();
        agePanel.setLayout(new BoxLayout(agePanel, 0));
        agePanel.add(this.jCbxAge);
        agePanel.add(this.jTFAge);
        agePanel.add(Box.createHorizontalStrut(3));
        return agePanel;
    }

    private JPanel getDatePanel() {
        this.jCbxDate.addActionListener(this.dateListener);
        this.jrbNotEqualTo.addActionListener(this.dateListener);
        this.jrbEqualTo.addActionListener(this.dateListener);
        this.jrbBefore.addActionListener(this.dateListener);
        this.jrbAfter.addActionListener(this.dateListener);
        this.buttonGroup.add(this.jrbNotEqualTo);
        this.buttonGroup.add(this.jrbEqualTo);
        this.buttonGroup.add(this.jrbBefore);
        this.buttonGroup.add(this.jrbAfter);
        JPanel datePanel = new JPanel(new GridBagLayout());
        datePanel.add((Component)this.jCbxDate, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 1), 0, 0));
        datePanel.add((Component)this.jrbNotEqualTo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 1, 1), 0, 0));
        datePanel.add((Component)this.jrbEqualTo, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 1, 1), 0, 0));
        datePanel.add((Component)this.jrbBefore, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 1, 1), 0, 0));
        datePanel.add((Component)this.jrbAfter, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 1, 1), 0, 0));
        datePanel.add((Component)this.calendarButton[0], new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        datePanel.add((Component)this.calendarButton[1], new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        datePanel.add((Component)this.calendarButton[2], new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        datePanel.add((Component)this.calendarButton[3], new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        return datePanel;
    }

    private void initListeners() {
        this.ageListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckUptoDatePanelBase.this.ageChanged();
            }
        };
        this.dateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckUptoDatePanelBase.this.dateChanged();
            }
        };
    }

    private void updatePanel() {
        this.reInitName();
        this.reInitAge();
        this.reInitDate();
    }

    private void reInitName() {
        this.jCmbName.setModel(new DefaultComboBoxModel<HiPredefinedType>(this.getAvailableTypes()));
        String type = this.getTypeString();
        if (type != null && type.length() != 0) {
            int index = 0;
            for (int i = 0; i < this.jCmbName.getItemCount(); ++i) {
                HiPredefinedType item = this.jCmbName.getItemAt(i);
                if (PolicyHandler.compareTwoObject(item.getValue(), type) != 0) continue;
                index = i;
                break;
            }
            this.jCmbName.setSelectedIndex(index);
        }
    }

    private void reInitAge() {
        this.jCbxAge.removeActionListener(this.ageListener);
        this.jCmbAge.removeActionListener(this.ageListener);
        int val = this.getAgeOperator();
        this.jCmbAge.setSelectedIndex(AGE_VALUES[val]);
        this.jTFAge.setText(String.valueOf(this.getAgeValue()));
        boolean enable = this.getAgeEnable();
        this.jCbxAge.setSelected(enable);
        this.jTFAge.setEnabled(enable);
        this.jCmbAge.setEnabled(enable);
        this.jCbxAge.addActionListener(this.ageListener);
        this.jCmbAge.addActionListener(this.ageListener);
    }

    private void reInitDate() {
        boolean hasTime;
        this.jCbxDate.removeActionListener(this.dateListener);
        this.jrbNotEqualTo.removeActionListener(this.dateListener);
        this.jrbEqualTo.removeActionListener(this.dateListener);
        this.jrbBefore.removeActionListener(this.dateListener);
        this.jrbAfter.removeActionListener(this.dateListener);
        int val = this.getDateOperator();
        switch (DATE_VALUES[val]) {
            case 0: {
                this.jrbNotEqualTo.setSelected(true);
                break;
            }
            case 1: {
                this.jrbEqualTo.setSelected(true);
                break;
            }
            case 2: {
                this.jrbBefore.setSelected(true);
                break;
            }
            case 3: {
                this.jrbAfter.setSelected(true);
                break;
            }
            default: {
                this.jrbNotEqualTo.setSelected(true);
            }
        }
        boolean hasTimeZone = this.getHasTimeZone();
        boolean bl = hasTime = this.getTimeValue() != -1L;
        if (hasTime) {
            hasTimeZone = true;
            this.calendarButton[0].setDateTime(this.getDateValue() + this.getTimeValue(), true, hasTime, hasTimeZone);
            this.calendarButton[1].setDateTime(this.getDateValue() + this.getTimeValue(), true, hasTime, hasTimeZone);
            this.calendarButton[2].setDateTime(this.getDateValue() + this.getTimeValue(), true, hasTime, hasTimeZone);
            this.calendarButton[3].setDateTime(this.getDateValue() + this.getTimeValue(), true, hasTime, hasTimeZone);
        } else {
            this.calendarButton[0].setDateTime(this.getDateValue(), true, hasTime, hasTimeZone);
            this.calendarButton[1].setDateTime(this.getDateValue(), true, hasTime, hasTimeZone);
            this.calendarButton[2].setDateTime(this.getDateValue(), true, hasTime, hasTimeZone);
            this.calendarButton[3].setDateTime(this.getDateValue(), true, hasTime, hasTimeZone);
        }
        boolean enable = this.getDateEnable();
        this.jCbxDate.setSelected(enable);
        for (int i = 0; i < 4; ++i) {
            this.calendarButton[i].setEnabled(enable && i == this.getSelectedIndex());
        }
        this.jrbNotEqualTo.setEnabled(enable);
        this.jrbEqualTo.setEnabled(enable);
        this.jrbBefore.setEnabled(enable);
        this.jrbAfter.setEnabled(enable);
        this.jCbxDate.addActionListener(this.dateListener);
        this.jrbNotEqualTo.addActionListener(this.dateListener);
        this.jrbEqualTo.addActionListener(this.dateListener);
        this.jrbBefore.addActionListener(this.dateListener);
        this.jrbAfter.addActionListener(this.dateListener);
    }

    private void dateChanged() {
        boolean selected = this.jCbxDate.isSelected();
        this.jrbNotEqualTo.setEnabled(selected);
        this.jrbEqualTo.setEnabled(selected);
        this.jrbBefore.setEnabled(selected);
        this.jrbAfter.setEnabled(selected);
        for (int i = 0; i < 4; ++i) {
            this.calendarButton[i].setEnabled(selected && this.getSelectedIndex() == i);
        }
    }

    private void ageChanged() {
        boolean selected = this.jCbxAge.isSelected();
        this.jCmbAge.setEnabled(selected);
        this.jTFAge.setEnabled(selected);
    }

    protected int getSelectedIndex() {
        if (this.jrbNotEqualTo.isSelected()) {
            return 0;
        }
        if (this.jrbEqualTo.isSelected()) {
            return 1;
        }
        if (this.jrbBefore.isSelected()) {
            return 2;
        }
        if (this.jrbAfter.isSelected()) {
            return 3;
        }
        return 0;
    }

    protected String getClientType() {
        if (StringUtilities.isEmpty((String)this.clientType)) {
            return "Windows";
        }
        return this.clientType;
    }
}

