/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkuptodate;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.hi.HIUtility;
import com.sygate.scm.console.ui.policy.hi.customized.checkuptodate.CheckUptoDatePanelBase;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAvUpToDateObject;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.AvSignatureAgeCriteria;
import com.sygate.scm.hi.library.AvSignatureDateCriteria;
import com.sygate.scm.util.Utility;
import java.util.Date;

public class CheckAvUpToDatePanel
extends CheckUptoDatePanelBase {
    private static final long serialVersionUID = 3662902503601224809L;
    private HiParam_CheckAvUpToDateObject avObj;

    public CheckAvUpToDatePanel(String clientType) {
        super(clientType);
    }

    @Override
    protected void setUptoDateObject(UnknownContent content) throws ConsoleException {
        this.avObj = new HiParam_CheckAvUpToDateObject(content);
    }

    @Override
    protected void updateCallObject() throws ConsoleException {
        AvSignatureAgeCriteria age = this.avObj.getOptAvSignatureAgeCriteria();
        if (age == null) {
            age = new AvSignatureAgeCriteria();
        }
        long days = Long.parseLong(this.jTFAge.getText().trim().length() > 0 ? this.jTFAge.getText().trim() : "0");
        age.setAgeValue(Long.valueOf(days * 86400L));
        age.setAgeOperator(CheckUptoDatePanelBase.AGE_VALUES[this.jCmbAge.getSelectedIndex()]);
        age.setOptEnable(Boolean.valueOf(this.jCbxAge.isSelected()));
        this.avObj.setOptAvSignatureAgeCriteria(age);
        AvSignatureDateCriteria date = this.avObj.getOptAvSignatureDateCriteria();
        if (date == null) {
            date = new AvSignatureDateCriteria();
        }
        long dateTime = this.calendarButton[this.getSelectedIndex()].getDateTime();
        date.setDateValue(Long.valueOf(Utility.getDatePortion((long)dateTime)));
        if (this.calendarButton[this.getSelectedIndex()].hasTime) {
            date.setOptTimeValue(Long.valueOf(Utility.getTimePortion((long)dateTime)));
        } else {
            date.setOptTimeValue(Long.valueOf(-1L));
        }
        date.setOptHasTimeZone(Boolean.valueOf(this.calendarButton[this.getSelectedIndex()].hasTimeZone));
        date.setDateOperator(CheckUptoDatePanelBase.DATE_VALUES[this.getSelectedIndex()]);
        date.setOptEnable(Boolean.valueOf(this.jCbxDate.isSelected()));
        this.avObj.setOptAvSignatureDateCriteria(date);
        this.avObj.setOptAvTypeString(((HiPredefinedType)this.jCmbName.getSelectedItem()).getValue());
        this.callObj.setParameter((ConfigObject)this.avObj.getSchemaObject());
    }

    @Override
    protected String getTypeString() {
        return this.avObj.getOptAvTypeString();
    }

    @Override
    protected long getAgeValue() {
        AvSignatureAgeCriteria age = this.avObj.getOptAvSignatureAgeCriteria();
        return age != null ? age.getAgeValue() / 86400L : 0L;
    }

    @Override
    protected int getAgeOperator() {
        AvSignatureAgeCriteria age = this.avObj.getOptAvSignatureAgeCriteria();
        return age != null ? age.getAgeOperator().intValue() : AvSignatureAgeCriteria.NOT_EQUAL.intValue();
    }

    @Override
    protected boolean getAgeEnable() {
        AvSignatureAgeCriteria age = this.avObj.getOptAvSignatureAgeCriteria();
        return age != null ? age.getOptEnable() : false;
    }

    @Override
    protected long getDateValue() {
        AvSignatureDateCriteria date = this.avObj.getOptAvSignatureDateCriteria();
        return date != null ? date.getDateValue().longValue() : new Date().getTime();
    }

    @Override
    protected long getTimeValue() {
        AvSignatureDateCriteria date = this.avObj.getOptAvSignatureDateCriteria();
        if (date == null) {
            return -1L;
        }
        Long time = date.getOptTimeValue();
        return time != null ? time : -1L;
    }

    @Override
    protected int getDateOperator() {
        AvSignatureDateCriteria date = this.avObj.getOptAvSignatureDateCriteria();
        return date != null ? date.getDateOperator().intValue() : AvSignatureDateCriteria.NOT_EQUAL.intValue();
    }

    @Override
    protected boolean getDateEnable() {
        AvSignatureDateCriteria date = this.avObj.getOptAvSignatureDateCriteria();
        return date != null ? date.getOptEnable() : false;
    }

    @Override
    protected boolean getHasTimeZone() {
        AvSignatureDateCriteria date = this.avObj.getOptAvSignatureDateCriteria();
        if (date == null) {
            return false;
        }
        Boolean hasTimeZone = date.getOptHasTimeZone();
        if (hasTimeZone == null) {
            Long dateTime = date.getOptTimeValue();
            return dateTime != null && dateTime != -1L;
        }
        return hasTimeZone;
    }

    @Override
    protected HiPredefinedType[] getAvailableTypes() {
        return HIUtility.getAvailableAVTypes(this.getClientType());
    }

    @Override
    public void setObject(HiCALLObject call) {
        this.jLTitle.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckAvUpToDatePanel.title.CheckAVUpToDate"));
        this.jLName.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckAvUpToDatePanel.label.AVName"));
        super.setObject(call);
    }
}

