/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkuptodate;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.hi.HIUtility;
import com.sygate.scm.console.ui.policy.hi.customized.checkuptodate.CheckUptoDatePanelBase;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckAswUpToDateObject;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.AswSignatureAgeCriteria;
import com.sygate.scm.hi.library.AswSignatureDateCriteria;
import com.sygate.scm.util.Utility;
import java.util.Date;

public class CheckAswUpToDatePanel
extends CheckUptoDatePanelBase {
    private static final long serialVersionUID = -8951797248208761245L;
    private HiParam_CheckAswUpToDateObject aswObj;

    public CheckAswUpToDatePanel(String clientType) {
        super(clientType);
    }

    @Override
    protected void setUptoDateObject(UnknownContent content) throws ConsoleException {
        this.aswObj = new HiParam_CheckAswUpToDateObject(content);
    }

    @Override
    protected void updateCallObject() throws ConsoleException {
        AswSignatureAgeCriteria age = this.aswObj.getOptAvSignatureAgeCriteria();
        if (age == null) {
            age = new AswSignatureAgeCriteria();
        }
        if (this.jTFAge.getText().trim().length() != 0) {
            long days = Long.parseLong(this.jTFAge.getText().trim().length() > 0 ? this.jTFAge.getText().trim() : "0");
            age.setAgeValue(Long.valueOf(days * 86400L));
        } else {
            age.setAgeValue(Long.valueOf(0L));
        }
        age.setAgeOperator(CheckUptoDatePanelBase.AGE_VALUES[this.jCmbAge.getSelectedIndex()]);
        age.setOptEnable(Boolean.valueOf(this.jCbxAge.isSelected()));
        this.aswObj.setOptAswSignatureAgeCriteria(age);
        AswSignatureDateCriteria date = this.aswObj.getOptAvSignatureDateCriteria();
        if (date == null) {
            date = new AswSignatureDateCriteria();
        }
        long dateTime = this.calendarButton[this.getSelectedIndex()].getDateTime();
        date.setDateValue(Long.valueOf(Utility.getDatePortion((long)dateTime)));
        if (this.calendarButton[this.getSelectedIndex()].hasTime) {
            date.setOptTimeValue(Long.valueOf(Utility.getTimePortion((long)dateTime)));
        } else {
            date.setOptTimeValue(Long.valueOf(-1L));
        }
        date.setOptHasTimeZone(Boolean.valueOf(this.calendarButton[this.getSelectedIndex()].hasTimeZone));
        date.setDateOperator(CheckUptoDatePanelBase.DATE_VALUES[this.getSelectedIndex()]);
        date.setOptEnable(Boolean.valueOf(this.jCbxDate.isSelected()));
        this.aswObj.setOptAswSignatureDateCriteria(date);
        this.aswObj.setOptAswTypeString(((HiPredefinedType)this.jCmbName.getSelectedItem()).getValue());
        this.callObj.setParameter((ConfigObject)this.aswObj.getSchemaObject());
    }

    @Override
    protected String getTypeString() {
        return this.aswObj.getOptAswTypeString();
    }

    @Override
    protected long getAgeValue() {
        AswSignatureAgeCriteria age = this.aswObj.getOptAvSignatureAgeCriteria();
        return age != null ? age.getAgeValue() / 86400L : 0L;
    }

    @Override
    protected int getAgeOperator() {
        AswSignatureAgeCriteria age = this.aswObj.getOptAvSignatureAgeCriteria();
        return age != null ? age.getAgeOperator().intValue() : AswSignatureAgeCriteria.NOT_EQUAL.intValue();
    }

    @Override
    protected boolean getAgeEnable() {
        AswSignatureAgeCriteria age = this.aswObj.getOptAvSignatureAgeCriteria();
        return age != null ? age.getOptEnable() : false;
    }

    @Override
    protected long getDateValue() {
        AswSignatureDateCriteria date = this.aswObj.getOptAvSignatureDateCriteria();
        return date != null ? date.getDateValue().longValue() : new Date().getTime();
    }

    @Override
    protected long getTimeValue() {
        AswSignatureDateCriteria date = this.aswObj.getOptAvSignatureDateCriteria();
        if (date == null) {
            return -1L;
        }
        Long time = date.getOptTimeValue();
        return time != null ? time : -1L;
    }

    @Override
    protected int getDateOperator() {
        AswSignatureDateCriteria date = this.aswObj.getOptAvSignatureDateCriteria();
        return date != null ? date.getDateOperator().intValue() : AswSignatureDateCriteria.NOT_EQUAL.intValue();
    }

    @Override
    protected boolean getDateEnable() {
        AswSignatureDateCriteria date = this.aswObj.getOptAvSignatureDateCriteria();
        return date != null ? date.getOptEnable() : false;
    }

    @Override
    protected boolean getHasTimeZone() {
        AswSignatureDateCriteria date = this.aswObj.getOptAvSignatureDateCriteria();
        if (date == null) {
            return false;
        }
        Boolean hasTimeZone = date.getOptHasTimeZone();
        if (hasTimeZone == null) {
            Long dateTime = date.getOptTimeValue();
            return dateTime != null && dateTime != -1L;
        }
        return hasTimeZone;
    }

    @Override
    protected HiPredefinedType[] getAvailableTypes() {
        return HIUtility.getAvailableASWTypes(this.getClientType());
    }

    @Override
    public void setObject(HiCALLObject call) {
        this.jLTitle.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckAswUpToDatePanel.title.CheckASUpToDate"));
        this.jLName.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckAswUpToDatePanel.label.ASName"));
        super.setObject(call);
    }
}

