/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkregistry;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class RegistryPanelBase
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 5446533237769720636L;
    private JTextField jTFKey = new JTextField(10);
    private JTextField jTFValue = new JTextField(10);
    private HiCALLObject callObj;

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.createRegistryObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        String key = this.jTFKey.getText().trim();
        String value = this.jTFValue.getText().trim();
        if (key.length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.error.EmptyKey"), this.jTFKey);
        }
        if (key.charAt(key.length() - 1) == '\\') {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.error.TrailingSlash"), this.jTFKey);
        }
        if (!this.isValidKey(key)) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.error.InvalidKey"), this.jTFKey);
        }
        if (this.hasValuePanel() && value.length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.error.EmptyValue"), this.jTFValue);
        }
        this.validateRegistrySetPanel();
        try {
            this.setRegistryObject(key, value);
            this.callObj.setParameter(this.getRegistrySchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    protected abstract String getRegistryPanelDesc();

    protected abstract void createRegistryObject(UnknownContent var1) throws ConsoleException;

    protected abstract void setRegistryObject(String var1, String var2);

    protected abstract ConfigObject getRegistrySchemaObject();

    protected abstract void updatePanel();

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel regPanel;
        this.jTFKey.setDocument(new RestrictedPlainDocument(255));
        this.jTFValue.setDocument(new RestrictedPlainDocument(255));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getRegistryPanelDesc()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.label.DescRegKey")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFKey, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.hasValuePanel()) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryPanelBase.label.ValueName")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTFValue, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if ((regPanel = this.getRegistrySetPanel()) != null) {
            panel.add((Component)regPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    protected void updateKeyValue(String fullPath) {
        if (fullPath != null && fullPath.trim().length() > 0) {
            String valueStr = "";
            String keyStr = "";
            int pos = fullPath.indexOf("@@##``$$&&!!~~**%%##");
            if (pos != -1) {
                keyStr = fullPath.substring(0, pos);
                valueStr = fullPath.substring(pos + "@@##``$$&&!!~~**%%##".length());
            } else {
                keyStr = fullPath;
                pos = fullPath.lastIndexOf("\\");
                if (pos != -1) {
                    keyStr = fullPath.substring(0, pos);
                    valueStr = fullPath.substring(pos + 1);
                }
            }
            StringTokenizer tokenizer = new StringTokenizer(keyStr, "\\");
            StringBuilder keyBuf = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                keyBuf.append(tokenizer.nextToken());
                keyBuf.append("\\");
            }
            String sTmpKey = keyBuf.toString();
            if (sTmpKey.endsWith("\\")) {
                sTmpKey = sTmpKey.substring(0, sTmpKey.length() - 1);
            }
            keyStr = sTmpKey;
            this.jTFKey.setText(keyStr);
            if (this.hasValuePanel()) {
                this.jTFValue.setText(valueStr);
            }
        } else {
            this.jTFKey.setText("");
            if (this.hasValuePanel()) {
                this.jTFValue.setText("");
            }
        }
    }

    protected boolean hasValuePanel() {
        return true;
    }

    protected JPanel getRegistrySetPanel() {
        return null;
    }

    protected void validateRegistrySetPanel() throws GUICheckException {
    }

    private boolean isValidKey(String key) {
        return key.equals("*") || Utility.isValidRegistryKey((String)key);
    }
}

