/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkregistry;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RegistrySetValueObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.hi.library.HiParm_RegistrySetValue;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class RegistryDataSetPanel
extends JPanel {
    private static final long serialVersionUID = 6812540604364293134L;
    private JRadioButton jRBDword = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.radio.DWORDValue"));
    private JRadioButton jRBString = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.radio.StringValue"));
    private JRadioButton jRBBin = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.radio.BinaryValue"));
    private JTextField jTFDword = new JTextField();
    private JTextField jTFString = new JTextField();
    private JTextField jTFBin = new JTextField();
    private JLabel jLDword = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.label.FormatDecimal"));
    private HiParam_RegistrySetValueObject regObj;

    public RegistryDataSetPanel() {
        this.initialize();
    }

    public boolean validateData() throws GUICheckException {
        if (this.jRBDword.isSelected() && this.jTFDword.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.error.DWORDValue"), this.jTFDword);
        }
        if (this.jRBString.isSelected() && this.jTFString.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.error.StringValue"), this.jTFString);
        }
        if (this.jRBBin.isSelected() && this.jTFBin.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.error.BinaryValue"), this.jTFBin);
        }
        if (this.jRBString.isSelected()) {
            this.regObj.setData(this.jTFString.getText().trim());
            this.regObj.setValueType(HiParm_RegistrySetValue.STRING);
        } else if (this.jRBDword.isSelected()) {
            this.regObj.setData(this.jTFDword.getText().trim());
            this.regObj.setValueType(HiParm_RegistrySetValue.DWORD);
        } else if (this.jRBBin.isSelected()) {
            this.regObj.setData(this.jTFBin.getText().trim());
            this.regObj.setValueType(HiParm_RegistrySetValue.BINARY);
        }
        return true;
    }

    public void updatePanel(HiParam_RegistrySetValueObject regObj) {
        this.regObj = regObj;
        this.jTFDword.setText("");
        this.jTFString.setText("");
        this.jTFBin.setText("");
        if (regObj.getValueType().intValue() == HiParm_RegistrySetValue.DWORD.intValue()) {
            this.jRBDword.setSelected(true);
            this.jTFDword.setText(regObj.getData());
        }
        if (regObj.getValueType().intValue() == HiParm_RegistrySetValue.STRING.intValue()) {
            this.jRBString.setSelected(true);
            this.jTFString.setText(regObj.getData());
        }
        if (regObj.getValueType().intValue() == HiParm_RegistrySetValue.BINARY.intValue()) {
            this.jRBBin.setSelected(true);
            this.jTFBin.setText(regObj.getData());
        }
        this.typeChanged();
    }

    private void initialize() {
        this.jRBDword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryDataSetPanel.this.typeChanged();
            }
        });
        this.jRBString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryDataSetPanel.this.typeChanged();
            }
        });
        this.jRBBin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryDataSetPanel.this.typeChanged();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBDword);
        group.add(this.jRBString);
        group.add(this.jRBBin);
        this.jTFDword.setDocument(new NumberPlainDocument(0xFFFFFFFFL, true));
        this.jTFDword.setHorizontalAlignment(4);
        this.jTFString.setDocument(new RestrictedPlainDocument(256));
        RestrictedPlainDocument doc = new RestrictedPlainDocument(256);
        doc.setValidator("1234567890ABCDEFabcdef", true);
        this.jTFBin.setDocument(doc);
        this.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataSetPanel.title.SpecifyTypeData"));
        Font plainFont = null;
        plainFont = titledBorder.getTitleFont() != null ? titledBorder.getTitleFont().deriveFont(0) : this.getFont();
        titledBorder.setTitleFont(plainFont);
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.jRBDword, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFDword, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLDword, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.jRBString, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFString, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jRBBin, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFBin, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void typeChanged() {
        boolean isDword = this.jRBDword.isSelected();
        this.jTFDword.setEnabled(isDword);
        this.jLDword.setEnabled(isDword);
        this.jTFString.setEnabled(this.jRBString.isSelected());
        this.jTFBin.setEnabled(this.jRBBin.isSelected());
    }
}

