/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkregistry;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RegistryValueObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.hi.library.HiParm_RegistryValue;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class RegistryDataComparePanel
extends JPanel {
    private static final long serialVersionUID = 7219851605012436029L;
    private static final String[] COMPARE = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.combo.EqualTo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.combo.NotEqualTo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.combo.LessThan"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.combo.GreaterThan")};
    private static final Integer[] I_COMPARE = new Integer[]{HiParm_RegistryValue.EQUAL, HiParm_RegistryValue.NOT_EQUAL, HiParm_RegistryValue.LESS_THAN, HiParm_RegistryValue.GREATER_THAN};
    private static final String[] VALUE_COMPARE = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.combo.ValueContains"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.combo.ValueEqualTo")};
    private static final Integer[] IVALUE_COMPARE = new Integer[]{HiParm_RegistryValue.NOT_EQUAL, HiParm_RegistryValue.EQUAL};
    private JRadioButton jRBDword = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.radio.DWORDValue"));
    private JComboBox<String> jCmbDword = new JComboBox<String>(COMPARE);
    private JTextField jTFDword = new JTextField();
    private JLabel jLDword = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.label.FormatDecimal"));
    private JRadioButton jRBString = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.radio.StringValue"));
    private JComboBox<String> jCmbString = new JComboBox<String>(VALUE_COMPARE);
    private JTextField jTFString = new JTextField();
    private JCheckBox jChkMatch = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.checkbox.MatchCases"));
    private JRadioButton jRBBin = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.radio.BinaryValue"));
    private JComboBox<String> jCmbBin = new JComboBox<String>(VALUE_COMPARE);
    private JTextField jTFBin = new JTextField();
    private JLabel jLOffset = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.label.AtOffset"));
    private JTextField jTFOffset = new JTextField();
    private HiParam_RegistryValueObject regObj;

    public RegistryDataComparePanel() {
        this.initialize();
    }

    public boolean validateData() throws GUICheckException {
        if (this.jRBDword.isSelected() && this.jTFDword.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.error.DWORDValue"), this.jTFDword);
        }
        if (this.jRBString.isSelected() && this.jTFString.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.error.StringValue"), this.jTFString);
        }
        if (this.jRBBin.isSelected() && this.jTFBin.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.error.BinaryValue"), this.jTFBin);
        }
        if (this.jRBBin.isSelected() && this.jTFOffset.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.error.OffsetValue"), this.jTFOffset);
        }
        this.regObj.setOptMatchCase(this.jChkMatch.isSelected());
        if (this.jRBString.isSelected()) {
            this.regObj.setData(this.jTFString.getText().trim());
            this.regObj.setValueType(HiParm_RegistryValue.STRING);
            this.regObj.setOperator(IVALUE_COMPARE[this.jCmbString.getSelectedIndex()]);
        } else if (this.jRBDword.isSelected()) {
            this.regObj.setData(this.jTFDword.getText().trim());
            this.regObj.setValueType(HiParm_RegistryValue.DWORD);
            this.regObj.setOperator(I_COMPARE[this.jCmbDword.getSelectedIndex()]);
        } else if (this.jRBBin.isSelected()) {
            this.regObj.setData(this.jTFBin.getText().trim());
            this.regObj.setValueType(HiParm_RegistryValue.BINARY);
            this.regObj.setOperator(IVALUE_COMPARE[this.jCmbBin.getSelectedIndex()]);
            this.regObj.setOptBinaryOffset(Integer.parseInt(this.jTFOffset.getText().trim()));
        }
        return true;
    }

    public void updatePanel(HiParam_RegistryValueObject regObj) {
        this.regObj = regObj;
        this.jTFDword.setText("");
        this.jTFString.setText("");
        this.jTFBin.setText("");
        if (regObj.getValueType().intValue() == HiParm_RegistryValue.DWORD.intValue()) {
            this.jRBDword.setSelected(true);
            this.jCmbDword.setSelectedIndex(this.getIndexOfDwordCompare(regObj.getOperator()));
            this.jTFDword.setText(regObj.getData());
        } else if (regObj.getValueType().intValue() == HiParm_RegistryValue.STRING.intValue()) {
            this.jRBString.setSelected(true);
            this.jCmbString.setSelectedIndex(this.getIndexOfStringCompare(regObj.getOperator()));
            this.jTFString.setText(regObj.getData());
        } else {
            this.jRBBin.setSelected(true);
            this.jCmbBin.setSelectedIndex(this.getIndexOfStringCompare(regObj.getOperator()));
            this.jTFBin.setText(regObj.getData());
        }
        this.typeChanged();
        this.jChkMatch.setSelected(regObj.getOptMatchCase());
        this.jTFOffset.setText("" + regObj.getOptBinaryOffset());
    }

    private void initialize() {
        this.jTFDword.setDocument(new NumberPlainDocument(0xFFFFFFFFL, true));
        this.jTFDword.setHorizontalAlignment(4);
        this.jTFString.setDocument(new RestrictedPlainDocument(256));
        RestrictedPlainDocument doc = new RestrictedPlainDocument(256);
        doc.setValidator("1234567890ABCDEFabcdef ", true);
        this.jTFBin.setDocument(doc);
        this.jTFOffset.setDocument(new NumberPlainDocument());
        this.jTFOffset.setHorizontalAlignment(2);
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBDword);
        group.add(this.jRBString);
        group.add(this.jRBBin);
        this.jRBBin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryDataComparePanel.this.typeChanged();
            }
        });
        this.jRBString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryDataComparePanel.this.typeChanged();
            }
        });
        this.jRBDword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryDataComparePanel.this.typeChanged();
            }
        });
        this.jCmbBin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryDataComparePanel.this.binaryOpChanged();
            }
        });
        this.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RegistryDataComparePanel.title.DataCompare"));
        if (titledBorder.getTitleFont() != null) {
            Font plainFont = titledBorder.getTitleFont().deriveFont(0);
            titledBorder.setTitleFont(plainFont);
        } else {
            titledBorder.setTitleFont(this.getFont());
        }
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.jRBDword, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jCmbDword, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFDword, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jLDword, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.jRBString, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jCmbString.setPreferredSize(this.jCmbDword.getPreferredSize());
        this.add(this.jCmbString, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFString, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jChkMatch, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.add((Component)this.jRBBin, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jCmbBin.setPreferredSize(this.jCmbDword.getPreferredSize());
        this.add(this.jCmbBin, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFBin, new GridBagConstraints(2, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jLOffset, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFOffset, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void typeChanged() {
        boolean isDword = this.jRBDword.isSelected();
        this.jCmbDword.setEnabled(isDword);
        this.jTFDword.setEnabled(isDword);
        this.jLDword.setEnabled(isDword);
        boolean isString = this.jRBString.isSelected();
        this.jCmbString.setEnabled(isString);
        this.jTFString.setEnabled(isString);
        this.jChkMatch.setEnabled(isString);
        boolean isBinary = this.jRBBin.isSelected();
        this.jCmbBin.setEnabled(isBinary);
        this.jTFBin.setEnabled(isBinary);
        this.binaryOpChanged();
    }

    private void binaryOpChanged() {
        boolean enable = this.jRBBin.isSelected() && this.jCmbBin.getSelectedIndex() != 1;
        this.jLOffset.setEnabled(enable);
        this.jTFOffset.setEnabled(enable);
    }

    private int getIndexOfStringCompare(Integer type) {
        for (int i = 0; i < I_COMPARE.length; ++i) {
            if (!IVALUE_COMPARE[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfDwordCompare(Integer type) {
        for (int i = 0; i < I_COMPARE.length; ++i) {
            if (!I_COMPARE[i].equals(type)) continue;
            return i;
        }
        return -1;
    }
}

