/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkpatchprocessservice;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public abstract class CheckPanelBase
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 2838364909318527761L;
    private JTextField jTFName = new JTextField(10);
    private HiCALLObject callObj;

    @Override
    public boolean validateInput() throws GUICheckException {
        String name = this.jTFName.getText().trim();
        if (name.length() <= 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckPanelBase.error.NameEmpty"), this.jTFName);
        }
        try {
            File f = new File(name);
            f.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckPanelBase.error.NameInvalid"), this.jTFName);
        }
        try {
            this.setCheckObject(this.jTFName.getText().trim());
            this.callObj.setParameter(this.getCheckSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckPanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    protected abstract void createCheckObject(UnknownContent var1) throws ConsoleException;

    protected abstract String getCheckName();

    protected abstract ConfigObject getCheckSchemaObject();

    protected abstract void setCheckObject(String var1);

    protected abstract Document getDocument();

    protected abstract String getTitle();

    protected abstract String getDescription();

    protected void initialize() {
        RestrictedPlainDocument nameDoc = (RestrictedPlainDocument)this.getDocument();
        this.jTFName.setDocument(nameDoc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getTitle()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(this.getDescription()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.createCheckObject(call.getParameter());
            this.jTFName.setText(this.getCheckName());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckPanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }
}

