/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkinstallationrunning;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class CheckInstallationPanelBase
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = -4332485029674438047L;
    private JComboBox<HiPredefinedType> jCmbType = new JComboBox();
    private HiCALLObject callObj;
    private String clientType;

    protected CheckInstallationPanelBase() {
        this.clientType = "Windows";
    }

    protected CheckInstallationPanelBase(String clientType) {
        this.clientType = clientType;
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.clientType = call.getClientType();
            this.createInstallationObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckInstallationPanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() {
        try {
            HiPredefinedType type = (HiPredefinedType)this.jCmbType.getSelectedItem();
            this.setInstallationType(type.getValue());
            this.callObj.setParameter(this.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckInstallationPanelBase.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    protected abstract ComboBoxModel<HiPredefinedType> getInstallationModel();

    protected abstract void createInstallationObject(UnknownContent var1) throws ConsoleException;

    protected abstract void setInstallationType(String var1);

    protected abstract ConfigObject getSchemaObject();

    protected abstract String getInstallationType();

    protected void initialize(String typeLC, String typeUC, String text) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(typeLC, typeUC, text), "North");
    }

    protected void initialize(String typeLC, String typeUC, String text, boolean isAvInfectedPanel) {
        if (isAvInfectedPanel) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.getInnerPanelForAVInfected(typeLC, typeUC, text), "North");
        } else {
            this.initialize(typeLC, typeUC, text);
        }
    }

    private JPanel getInnerPanel(String typeLC, String typeUC, String text) {
        String title = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckInstallationPanelBase.title.CheckNamedTypeSoftwareStatus"), typeLC, text);
        String name = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckInstallationPanelBase.title.SoftwareTypeName"), typeUC);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(name), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add(this.jCmbType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getInnerPanelForAVInfected(String typeLC, String typeUC, String text) {
        String title = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckInstallationPanelBase.title.CheckNamedTypeSoftwareAVInfectedStatus"), typeLC, text);
        String name = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckInstallationPanelBase.title.SoftwareTypeName"), typeUC);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(name), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add(this.jCmbType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void updatePanel() {
        ComboBoxModel<HiPredefinedType> model = this.getInstallationModel();
        this.jCmbType.setModel(model);
        this.jCmbType.setSelectedIndex(this.getInstallationTypeIndex(model));
    }

    private int getInstallationTypeIndex(ComboBoxModel<HiPredefinedType> model) {
        String type = this.getInstallationType();
        if (type != null && type.length() != 0) {
            for (int i = 0; i < model.getSize(); ++i) {
                HiPredefinedType item = (HiPredefinedType)model.getElementAt(i);
                if (PolicyHandler.compareTwoObject(item.getValue(), type) != 0) continue;
                return i;
            }
        }
        return 0;
    }

    protected String getClientType() {
        if (StringUtilities.isEmpty((String)this.clientType)) {
            return "Windows";
        }
        return this.clientType;
    }
}

