/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkfile;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FilePanelBase;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileVersionObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_FileVersion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileVersionPanel
extends FilePanelBase {
    private static final long serialVersionUID = -7765205225684079731L;
    private JRadioButton[] jrbVersion = new JRadioButton[]{new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.radiobutton.FileVersionIsEqualTo")), new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.radiobutton.FileVersionIsNotEqualTo")), new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.radiobutton.FileVersionIsLessThan")), new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.radiobutton.FileVersionIsGreaterThan"))};
    private static final Integer[] OP_VALUES = new Integer[]{HiParm_FileVersion.EQUAL, HiParm_FileVersion.NOT_EQUAL, HiParm_FileVersion.LESS_THAN, HiParm_FileVersion.GREATER_THAN};
    private JTextField[] jTFVersion = new JTextField[]{new JTextField(20), new JTextField(20), new JTextField(20), new JTextField(20)};
    private ButtonGroup buttongroup = new ButtonGroup();
    private HiParam_FileVersionObject fileObj;
    private String fileVersion;

    public FileVersionPanel(String clientType) {
        this.initialize(clientType);
        this.OperatorChanged();
    }

    @Override
    protected String getFilePanelDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.CheckFileVersion");
    }

    @Override
    protected JComponent getFeaturePanel() {
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                FileVersionPanel.this.OperatorChanged();
            }
        };
        DescriptionTextArea textArea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.VersionDecimalFormat"));
        JPanel p = new JPanel(new GridBagLayout());
        for (int i = 0; i < 4; ++i) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(23);
            doc.setValidator("1234567890.", true);
            this.jTFVersion[i].setDocument(doc);
            this.buttongroup.add(this.jrbVersion[i]);
            this.jrbVersion[i].addChangeListener(cl);
            p.add((Component)this.jrbVersion[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            p.add((Component)this.jTFVersion[i], new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        p.add((Component)textArea, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return p;
    }

    @Override
    protected void updatePanel() {
        this.updateFileName(this.fileObj.getFileName());
        this.jrbVersion[this.fileObj.getOperator()].setSelected(true);
        this.jTFVersion[this.getSelectedIndex()].setText(this.fileObj.getValue());
    }

    @Override
    protected void validateFeaturePanel() throws GUICheckException {
        if (this.jTFVersion[this.getSelectedIndex()].getText() == null || this.jTFVersion[this.getSelectedIndex()].getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.error.EmptyVersion"), this.jTFVersion[this.getSelectedIndex()]);
        }
        if (!this.validateVersion()) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileVersionPanel.error.InvalidVersion"), this.jTFVersion[this.getSelectedIndex()]);
        }
    }

    @Override
    protected void createFileObject(UnknownContent content) throws ConsoleException {
        this.fileObj = new HiParam_FileVersionObject(content);
    }

    @Override
    protected void setFileObject(String fileName) {
        this.fileObj.setFileName(fileName);
        this.fileObj.setValue(this.jTFVersion[this.getSelectedIndex()].getText().trim());
        this.fileObj.setOperator(OP_VALUES[this.getSelectedIndex()]);
    }

    @Override
    protected ConfigObject getFileSchemaObject() {
        return this.fileObj.getSchemaObject();
    }

    @Override
    protected void setFileFeature(LearnedApplicationObject learnAppObj) {
        this.fileVersion = (String)learnAppObj.getValueAt(3);
    }

    @Override
    protected void learnApplication() {
        super.learnApplication();
        this.jTFVersion[this.getSelectedIndex()].setText(this.fileVersion != null ? this.fileVersion : "");
    }

    private boolean validateVersion() {
        String version = this.jTFVersion[this.getSelectedIndex()].getText().trim();
        if (version.length() == 0 || version.endsWith(".") || version.startsWith(".")) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        if (st.countTokens() != 4) {
            return false;
        }
        while (st.hasMoreTokens()) {
            int versionPart = Integer.parseInt(st.nextToken());
            if (versionPart >= 0 && versionPart <= 65535) continue;
            return false;
        }
        return true;
    }

    private int getSelectedIndex() {
        for (int i = 0; i < 4; ++i) {
            if (!this.jrbVersion[i].isSelected()) continue;
            return i;
        }
        return 0;
    }

    private void OperatorChanged() {
        for (int i = 0; i < 4; ++i) {
            this.jTFVersion[i].setEditable(this.jrbVersion[i].isSelected());
        }
    }
}

