/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkfile;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FilePanelBase;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileSizeCompareObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_FileSizeCompare;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileSizePanel
extends FilePanelBase
implements ChangeListener {
    private static final long serialVersionUID = -3758456228522743262L;
    private static final Integer[] OP_VALUES = new Integer[]{HiParm_FileSizeCompare.EQUAL, HiParm_FileSizeCompare.NOT_EQUAL, HiParm_FileSizeCompare.LESS_THAN, HiParm_FileSizeCompare.GREATER_THAN};
    private JTextField[] jTFSize = new JTextField[]{new JTextField(15), new JTextField(15), new JTextField(15), new JTextField(15)};
    private JRadioButton jrbET = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileSizePanel.label.FileSizeIsEqualTo"));
    private JRadioButton jrbNET = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileSizePanel.label.FileSizeIsNotEqualTo"));
    private JRadioButton jrbLT = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileSizePanel.label.FileSizeIsLessThan"));
    private JRadioButton jrbGT = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileSizePanel.label.FileSizeIsGreaterThan"));
    private ButtonGroup buttonGroup = new ButtonGroup();
    private HiParam_FileSizeCompareObject fileObj;
    private Long fileSize;

    public FileSizePanel(String clientType) {
        this.initialize(clientType);
    }

    @Override
    protected String getFilePanelDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileSizePanel.CheckFile");
    }

    @Override
    protected JComponent getFeaturePanel() {
        for (int i = 0; i < 4; ++i) {
            this.jTFSize[i].setDocument(new NumberPlainDocument(Long.MAX_VALUE));
            this.jTFSize[i].setHorizontalAlignment(4);
        }
        this.jrbET.addChangeListener(this);
        this.jrbNET.addChangeListener(this);
        this.jrbLT.addChangeListener(this);
        this.jrbGT.addChangeListener(this);
        this.buttonGroup.add(this.jrbET);
        this.buttonGroup.add(this.jrbNET);
        this.buttonGroup.add(this.jrbLT);
        this.buttonGroup.add(this.jrbGT);
        JPanel panel1 = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new FlowLayout(7));
        panel1.add((Component)this.jrbET, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jrbNET, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jrbLT, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jrbGT, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jTFSize[0], new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)this.jTFSize[1], new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)this.jTFSize[2], new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel1.add((Component)this.jTFSize[3], new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(panel1);
        return panel;
    }

    @Override
    protected void updatePanel() {
        this.updateFileName(this.fileObj.getFileName());
        switch (this.fileObj.getOperator()) {
            case 0: {
                this.jrbET.setSelected(true);
                break;
            }
            case 1: {
                this.jrbNET.setSelected(true);
                break;
            }
            case 2: {
                this.jrbLT.setSelected(true);
                break;
            }
            case 3: {
                this.jrbGT.setSelected(true);
                break;
            }
        }
        long size = this.fileObj.getValue();
        String fileName = this.fileObj.getFileName();
        if (fileName.isEmpty()) {
            this.jTFSize[this.getSelectedIndex()].setText((String)(size != 0L ? "" + size : ""));
        } else if (!fileName.isEmpty()) {
            this.jTFSize[this.getSelectedIndex()].setText("" + size);
        }
    }

    @Override
    protected void validateFeaturePanel() throws GUICheckException {
        if (this.jTFSize[this.getSelectedIndex()].getText() == null || this.jTFSize[this.getSelectedIndex()].getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileSizePanel.error.EmptyFileSize"), this.jTFSize[this.getSelectedIndex()]);
        }
    }

    @Override
    protected void createFileObject(UnknownContent content) throws ConsoleException {
        this.fileObj = new HiParam_FileSizeCompareObject(content);
    }

    @Override
    protected void setFileObject(String fileName) {
        this.fileObj.setFileName(fileName);
        this.fileObj.setOperator(OP_VALUES[this.getSelectedIndex()]);
        this.fileObj.setValue(Long.parseLong(this.jTFSize[this.getSelectedIndex()].getText().trim()));
    }

    @Override
    protected ConfigObject getFileSchemaObject() {
        return this.fileObj.getSchemaObject();
    }

    @Override
    protected void setFileFeature(LearnedApplicationObject learnAppObj) {
        this.fileSize = (Long)learnAppObj.getValueAt(4);
    }

    @Override
    protected void learnApplication() {
        super.learnApplication();
        if (this.fileSize != null) {
            this.jTFSize[this.getSelectedIndex()].setText(this.fileSize.toString());
        }
    }

    protected int getSelectedIndex() {
        if (this.jrbET.isSelected()) {
            return 0;
        }
        if (this.jrbNET.isSelected()) {
            return 1;
        }
        if (this.jrbLT.isSelected()) {
            return 2;
        }
        if (this.jrbGT.isSelected()) {
            return 3;
        }
        return 0;
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        for (int i = 0; i < 4; ++i) {
            this.jTFSize[i].setEnabled(i == this.getSelectedIndex());
        }
    }
}

