/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkfile;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FilePanelBase;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileDateCompareObject;
import com.sygate.scm.console.ui.util.CalendarButton;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_FileDateCompare;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileDatePanel
extends FilePanelBase {
    private static final long serialVersionUID = -3591395536187061862L;
    private static final Integer[] OP_VALUES = new Integer[]{HiParm_FileDateCompare.NOT_EQUAL, HiParm_FileDateCompare.EQUAL, HiParm_FileDateCompare.LESS_THAN, HiParm_FileDateCompare.GREATER_THAN};
    private JRadioButton jrbNET = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDatePanel.label.FileDateIsNotEqualTo"));
    private JRadioButton jrbET = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDatePanel.label.FileDateIsEqualTo"));
    private JRadioButton jrbBefore = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDatePanel.label.FileDateIsBefore"));
    private JRadioButton jrbAfter = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDatePanel.label.FileDateIsAfter"));
    private ButtonGroup buttongroup = new ButtonGroup();
    private rbChangeListener rbcl = new rbChangeListener();
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private CalendarButton[] calendarButton = new CalendarButton[]{new CalendarButton(this.timePattern), new CalendarButton(this.timePattern), new CalendarButton(this.timePattern), new CalendarButton(this.timePattern)};
    private HiParam_FileDateCompareObject fileObj;
    private String fileLastModified;

    public FileDatePanel(String clientType) {
        this.initialize(clientType);
    }

    @Override
    protected String getFilePanelDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDatePanel.CheckFile");
    }

    @Override
    protected JComponent getFeaturePanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel jPan1 = new JPanel(gbl);
        jPan1.setLayout(new FlowLayout(7));
        JPanel jPan = new JPanel(gbl);
        this.buttongroup.add(this.jrbNET);
        this.buttongroup.add(this.jrbET);
        this.buttongroup.add(this.jrbBefore);
        this.buttongroup.add(this.jrbAfter);
        jPan.add((Component)this.jrbNET, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPan.add((Component)this.jrbET, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPan.add((Component)this.jrbBefore, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPan.add((Component)this.jrbAfter, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jrbNET.addChangeListener(this.rbcl);
        this.jrbET.addChangeListener(this.rbcl);
        this.jrbBefore.addChangeListener(this.rbcl);
        this.jrbAfter.addChangeListener(this.rbcl);
        jPan.add((Component)this.calendarButton[0], new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPan.add((Component)this.calendarButton[1], new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPan.add((Component)this.calendarButton[2], new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPan.add((Component)this.calendarButton[3], new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPan1.add(jPan);
        return jPan1;
    }

    @Override
    protected void updatePanel() {
        this.updateFileName(this.fileObj.getFileName());
        int val = this.fileObj.getOperator();
        switch (OP_VALUES[val]) {
            case 0: {
                this.jrbNET.setSelected(true);
                break;
            }
            case 1: {
                this.jrbET.setSelected(true);
                break;
            }
            case 2: {
                this.jrbBefore.setSelected(true);
                break;
            }
            case 3: {
                this.jrbAfter.setSelected(true);
                break;
            }
        }
        String dateTimeStamp = this.fileObj.getValue().trim();
        long dateTime = 0L;
        boolean hasTime = false;
        boolean hasTimeZone = false;
        try {
            SimpleDateFormat dateOnlyFormat = new SimpleDateFormat("MM/dd/yyyy");
            SimpleDateFormat dateTimeWithoutZoneFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            SimpleDateFormat dateTimeWithZoneFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm Z");
            String[] token = dateTimeStamp.split(" ");
            if (token.length == 1) {
                dateOnlyFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                dateTime = dateOnlyFormat.parse(dateTimeStamp).getTime();
            } else if (token.length == 2) {
                hasTime = true;
                hasTimeZone = true;
                dateTimeWithoutZoneFormat.setTimeZone(Utility.getLocalTimeZone());
                dateTime = dateTimeWithoutZoneFormat.parse(dateTimeStamp).getTime();
            } else {
                hasTime = true;
                hasTimeZone = true;
                dateTimeWithZoneFormat.setTimeZone(Utility.getLocalTimeZone());
                dateTime = dateTimeWithZoneFormat.parse(dateTimeStamp).getTime();
            }
            for (int i = 0; i < 4; ++i) {
                this.calendarButton[i].setDateTime(dateTime, true, hasTime, hasTimeZone);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    protected void validateFeaturePanel() throws GUICheckException {
    }

    @Override
    protected void createFileObject(UnknownContent content) throws ConsoleException {
        this.fileObj = new HiParam_FileDateCompareObject(content);
    }

    @Override
    protected void setFileObject(String fileName) {
        this.fileObj.setFileName(fileName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        SimpleDateFormat dateTimeWithoutZoneFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateTimeWithoutZoneFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        long dateTime = this.calendarButton[this.getSelectedIndex()].getDateTime();
        if (!this.calendarButton[this.getSelectedIndex()].hasTime) {
            String dateStamp = dateFormat.format(new Date(dateTime));
            this.fileObj.setValue(dateStamp);
        } else if (!this.calendarButton[this.getSelectedIndex()].hasTimeZone) {
            String dateTimeWithZoneStamp = dateTimeWithoutZoneFormat.format(new Date(dateTime));
            this.fileObj.setValue(dateTimeWithZoneStamp);
        } else {
            String dateTimeWithZoneStamp = dateTimeWithoutZoneFormat.format(new Date(dateTime)) + " +0000";
            this.fileObj.setValue(dateTimeWithZoneStamp);
        }
        this.fileObj.setOperator(OP_VALUES[this.getSelectedIndex()]);
    }

    @Override
    protected ConfigObject getFileSchemaObject() {
        return this.fileObj.getSchemaObject();
    }

    @Override
    protected void setFileFeature(LearnedApplicationObject learnAppObj) {
        this.fileLastModified = (String)learnAppObj.getValueAt(5);
    }

    @Override
    protected void learnApplication() {
        super.learnApplication();
        if (this.fileLastModified != null && this.fileLastModified.length() != 0) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
                Date minimumDate = sdf.parse("01/01/1990 00:00");
                DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
                dateTimeFormat.setTimeZone(Utility.getLocalTimeZone());
                Date fileLastModifiedDate = dateTimeFormat.parse(this.fileLastModified);
                if (fileLastModifiedDate.before(minimumDate)) {
                    fileLastModifiedDate = minimumDate;
                }
                for (int i = 0; i < 4; ++i) {
                    this.calendarButton[i].setDateTime(fileLastModifiedDate.getTime(), true, true, true);
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            this.jrbNET.setSelected(true);
        }
    }

    protected int getSelectedIndex() {
        if (this.jrbNET.isSelected()) {
            return 0;
        }
        if (this.jrbET.isSelected()) {
            return 1;
        }
        if (this.jrbBefore.isSelected()) {
            return 2;
        }
        if (this.jrbAfter.isSelected()) {
            return 3;
        }
        return 0;
    }

    private class rbChangeListener
    implements ChangeListener {
        private rbChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (int i = 0; i < 4; ++i) {
                FileDatePanel.this.calendarButton[i].setEnabled(i == FileDatePanel.this.getSelectedIndex());
            }
        }
    }
}

