/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkfile;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FilePanelBase;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileChecksumEqualToObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileChecksumPanel
extends FilePanelBase {
    private static final long serialVersionUID = 3081175085398456707L;
    private JTextField jTFChecksum = new JTextField(40);
    private HiParam_FileChecksumEqualToObject fileObj;
    private String fileChecksum;

    public FileChecksumPanel(String clientType) {
        this.initialize(clientType);
    }

    @Override
    protected String getFilePanelDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileChecksumPanel.CheckFingerprint");
    }

    @Override
    protected JComponent getFeaturePanel() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(32);
        doc.setValidator("0123456789ABCDEFabcdef", true);
        this.jTFChecksum.setDocument(doc);
        Box box = new Box(0);
        box.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileChecksumPanel.label.FingerprintEquals")));
        box.add(Box.createHorizontalStrut(10));
        box.add(this.jTFChecksum);
        box.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "West");
        return panel;
    }

    @Override
    protected void updatePanel() {
        this.updateFileName(this.fileObj.getFileName());
        this.jTFChecksum.setText(this.fileObj.getFileChecksum());
        this.fileChecksum = null;
    }

    @Override
    protected void validateFeaturePanel() throws GUICheckException {
        if (this.jTFChecksum.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileChecksumPanel.error.EmptyFingerprint"), this.jTFChecksum);
        }
    }

    @Override
    protected void createFileObject(UnknownContent content) throws ConsoleException {
        this.fileObj = new HiParam_FileChecksumEqualToObject(content);
    }

    @Override
    protected void setFileObject(String fileName) {
        this.fileObj.setFileName(fileName);
        this.fileObj.setFileChecksum(this.jTFChecksum.getText().trim());
    }

    @Override
    protected ConfigObject getFileSchemaObject() {
        return this.fileObj.getSchemaObject();
    }

    @Override
    protected void setFileFeature(LearnedApplicationObject learnAppObj) {
        this.fileChecksum = (String)learnAppObj.getValueAt(6);
    }

    @Override
    protected void learnApplication() {
        super.learnApplication();
        this.jTFChecksum.setText(this.fileChecksum != null ? this.fileChecksum.toString() : "");
    }
}

