/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized.checkfile;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.checkfile.FilePanelBase;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileAgeObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_FileAge;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FileAgePanel
extends FilePanelBase
implements ItemListener {
    private static final long serialVersionUID = -4287304773017308683L;
    MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.policy.hi.customized.hicustomized");
    private static final Integer[] OP_VALUES = new Integer[]{HiParm_FileAge.GREATER_THAN, HiParm_FileAge.LESS_THAN};
    private static final long AGE_LIMIT_DAY = Utility.getMaxDay((boolean)true);
    private static final long AGE_LIMIT_WEEK = Utility.getMaxWeek((boolean)true);
    private static final long[] AGE_VALUE = new long[]{86400L, 604800L};
    private static final long AGE_MAX_DAY = 36000L;
    private static final long AGE_MAX_WEEK = 5153L;
    private static final int DAY = 1;
    private static final int WEEK = 2;
    private JRadioButton jRBAgeGtDays = new JRadioButton(this.res.getString("FileAgePanel.checkbox.GtDays"));
    private JTextField jTFAgeGtDays = new JTextField(10);
    private JRadioButton jRBAgeGtWeeks = new JRadioButton(this.res.getString("FileAgePanel.checkbox.GtWeeks"));
    private JTextField jTFAgeGtWeeks = new JTextField(10);
    private JRadioButton jRBAgeLtDays = new JRadioButton(this.res.getString("FileAgePanel.checkbox.LtDays"));
    private JTextField jTFAgeLtDays = new JTextField(10);
    private JRadioButton jRBAgeLtWeeks = new JRadioButton(this.res.getString("FileAgePanel.checkbox.LtWeeks"));
    private JTextField jTFAgeLtWeeks = new JTextField(10);
    private JRadioButton[] buttons = new JRadioButton[]{this.jRBAgeGtDays, this.jRBAgeGtWeeks, this.jRBAgeLtDays, this.jRBAgeLtWeeks};
    private JTextField[] fields = new JTextField[]{this.jTFAgeGtDays, this.jTFAgeGtWeeks, this.jTFAgeLtDays, this.jTFAgeLtWeeks};
    private HiParam_FileAgeObject fileObj;
    private long fileLastModified;

    public FileAgePanel(String clientType) {
        this.initialize(clientType);
        this.ageChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.ageChanged();
    }

    @Override
    protected String getFilePanelDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileAgePanel.CheckFileAge");
    }

    @Override
    protected JComponent getFeaturePanel() {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].addItemListener(this);
            this.fields[i].setHorizontalAlignment(4);
        }
        this.jTFAgeGtDays.setDocument(new NumberPlainDocument(1L, AGE_LIMIT_DAY, true));
        this.jTFAgeGtWeeks.setDocument(new NumberPlainDocument(1L, AGE_LIMIT_WEEK, true));
        this.jTFAgeLtDays.setDocument(new NumberPlainDocument(1L, AGE_LIMIT_DAY, true));
        this.jTFAgeLtWeeks.setDocument(new NumberPlainDocument(1L, AGE_LIMIT_WEEK, true));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jRBAgeGtDays);
        bg.add(this.jRBAgeGtWeeks);
        bg.add(this.jRBAgeLtDays);
        bg.add(this.jRBAgeLtWeeks);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jRBAgeGtDays, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFAgeGtDays, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jRBAgeGtWeeks, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFAgeGtWeeks, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jRBAgeLtDays, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFAgeLtDays, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jRBAgeLtWeeks, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFAgeLtWeeks, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void updatePanel() {
        this.updateFileName(this.fileObj.getFileName());
        int operatorIndex = this.getOperatorIndex(this.fileObj.getOperator());
        long age = this.fileObj.getValue();
        if (age == 0L) {
            this.jRBAgeGtDays.setSelected(true);
            this.jTFAgeGtDays.setText("");
            return;
        }
        int index = PolicyHandler.getIndexOfValueFromList(age, AGE_VALUE);
        long value = age / AGE_VALUE[index];
        if (index == 0) {
            if (operatorIndex == 1) {
                this.jRBAgeLtDays.setSelected(true);
                this.jTFAgeLtDays.setText("" + value);
            } else {
                this.jRBAgeGtDays.setSelected(true);
                this.jTFAgeGtDays.setText("" + value);
            }
        } else if (operatorIndex == 1) {
            this.jRBAgeLtWeeks.setSelected(true);
            this.jTFAgeLtWeeks.setText("" + value);
        } else {
            this.jRBAgeGtWeeks.setSelected(true);
            this.jTFAgeGtWeeks.setText("" + value);
        }
        this.ageChanged();
    }

    @Override
    protected void validateFeaturePanel() throws GUICheckException {
        if (this.jRBAgeGtDays.isSelected()) {
            this.checkValue(this.jTFAgeGtDays, 1);
        } else if (this.jRBAgeGtWeeks.isSelected()) {
            this.checkValue(this.jTFAgeGtWeeks, 2);
        } else if (this.jRBAgeLtDays.isSelected()) {
            this.checkValue(this.jTFAgeLtDays, 1);
        } else {
            this.checkValue(this.jTFAgeLtWeeks, 2);
        }
    }

    @Override
    protected void createFileObject(UnknownContent content) throws ConsoleException {
        this.fileObj = new HiParam_FileAgeObject(content);
    }

    @Override
    protected void setFileObject(String fileName) {
        this.fileObj.setFileName(fileName);
        this.fileObj.setOperator(OP_VALUES[this.getAgeOperatorIndex()]);
        long seconds = Long.parseLong(this.getAgeValue().trim()) * AGE_VALUE[this.getAgeUnitIndex()];
        this.fileObj.setValue(seconds);
    }

    @Override
    protected ConfigObject getFileSchemaObject() {
        return this.fileObj.getSchemaObject();
    }

    @Override
    protected void setFileFeature(LearnedApplicationObject learnAppObj) {
        this.fileLastModified = learnAppObj.getSemApplication().getOptLastModifyTime();
    }

    @Override
    protected void learnApplication() {
        super.learnApplication();
        this.updateAgePanelValue(this.fileLastModified);
    }

    private void ageChanged() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].isSelected()) {
                this.fields[i].setEnabled(true);
                this.fields[i].requestFocus();
                continue;
            }
            this.fields[i].setEnabled(false);
            this.fields[i].setText("");
        }
    }

    private int getAgeUnitIndex() {
        if (this.jRBAgeGtDays.isSelected() || this.jRBAgeLtDays.isSelected()) {
            return 0;
        }
        return 1;
    }

    private int getAgeOperatorIndex() {
        if (this.jRBAgeGtDays.isSelected() || this.jRBAgeGtWeeks.isSelected()) {
            return 0;
        }
        return 1;
    }

    private String getAgeValue() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return this.fields[i].getText();
        }
        return "";
    }

    private void updateAgePanelValue(long fileLastModified) {
        if (fileLastModified != 0L) {
            Date date = new Date(fileLastModified);
            long diff = (System.currentTimeMillis() - date.getTime()) / 1000L;
            if (diff == 0L) {
                this.jRBAgeGtDays.setSelected(true);
                this.jTFAgeGtDays.setText("0");
            } else {
                int index = PolicyHandler.getIndexOfValueFromList(Math.abs(diff), AGE_VALUE);
                long value = Math.abs(diff) / AGE_VALUE[index];
                if (index == 0) {
                    if (diff > 0L) {
                        this.jRBAgeLtDays.setSelected(true);
                        this.jTFAgeLtDays.setText("" + value);
                    } else {
                        this.jRBAgeGtDays.setSelected(true);
                        this.jTFAgeGtDays.setText("" + value);
                    }
                } else if (diff > 0L) {
                    this.jRBAgeLtWeeks.setSelected(true);
                    this.jTFAgeLtWeeks.setText("" + value);
                } else {
                    this.jRBAgeGtWeeks.setSelected(true);
                    this.jTFAgeGtWeeks.setText("" + value);
                }
                this.ageChanged();
            }
        }
    }

    private void checkValue(JTextField field, int type) throws GUICheckException {
        if (field.getText() == null || field.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileAgePanel.error.EmptyDate"), field);
        }
        if (type == 1 && Long.parseLong(field.getText()) > 36000L) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileAgePanel.error.MaxDays"), field);
        }
        if (type == 2 && Long.parseLong(field.getText()) > 5153L) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileAgePanel.error.MaxWeeks"), field);
        }
    }

    private int getOperatorIndex(Integer value) {
        for (int i = 0; i < OP_VALUES.length; ++i) {
            if (!OP_VALUES[i].equals(value)) continue;
            return i;
        }
        return -1;
    }
}

