/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_SleepObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SleepPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = -2039345688643584686L;
    private JTextField jTFTime = new JTextField(new NumberPlainDocument(2147483L, true), "", 10);
    private HiParam_SleepObject sleepObj;
    private HiCALLObject callObj;

    public SleepPanel() {
        this.initialize();
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.sleepObj = new HiParam_SleepObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "SleepPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        String time = this.jTFTime.getText().trim();
        if (time.length() == 0 || Integer.parseInt(time) < 1) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "SleepPanel.error.WaitPeriodPositive"), this.jTFTime);
        }
        try {
            this.sleepObj.setTime(Integer.parseInt(time) * 1000);
            this.callObj.setParameter((ConfigObject)this.sleepObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "SleepPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "SleepPanel.label.WaitPeriod")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getTimePanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private Box getTimePanel() {
        this.jTFTime.setHorizontalAlignment(11);
        Box box = new Box(0);
        box.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "SleepPanel.label.WaitFor")));
        box.add(this.jTFTime);
        box.add(Box.createHorizontalStrut(2));
        box.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "SleepPanel.label.Seconds")));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void updatePanel() {
        this.jTFTime.setText((String)(this.sleepObj.getTime() != -1 ? "" + this.sleepObj.getTime() / 1000 : ""));
    }
}

