/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_SaveTimeObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetTimerPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 5172640716118983249L;
    private JTextField jTFTime = new JTextField();
    private HiCALLObject callObj;
    private HiParam_SaveTimeObject proObj;

    public SetTimerPanel() {
        this.initialize();
    }

    @Override
    public void setObject(HiCALLObject callObj) {
        try {
            this.callObj = callObj;
            this.proObj = new HiParam_SaveTimeObject(callObj.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "setTimePanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        String time = this.jTFTime.getText().trim();
        if (time.length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "setTimePanel.error.EmptyName"), this.jTFTime);
        }
        try {
            this.proObj.setName(time);
            this.callObj.setParameter((ConfigObject)this.proObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "setTimePanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "setTimePanel.label.SetTimestampName"));
        DescriptionTextArea explainArea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "setTimePanel.FunctionDescCheckTimestamp"));
        this.jTFTime.setDocument(new RestrictedPlainDocument(255, "^=\t", false));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)explainArea, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "setTimePanel.label.Name")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFTime, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        return panel;
    }

    private void updatePanel() {
        this.jTFTime.setText(this.proObj.getName());
    }
}

