/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.ProgramWaitPanel;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RunScriptObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.EmbeddedTempScriptFile;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RunScriptPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = -5162730306629403997L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.hi.customized.hicustomized");
    private JTextField jTFFile = new JTextField();
    private JTextArea jTAFileText = new JTextArea();
    private JTextField jTFCmd = new JTextField();
    private JCheckBox jCbxDelete = new JCheckBox(MSG_RES.getString("RunScriptPanel.checkbox.DeleteTempFile"));
    private JCheckBox jCbxShow = new JCheckBox(MSG_RES.getString("RunScriptPanel.checkbox.ShowNewProcWnd"));
    private ProgramWaitPanel waitPanel = new ProgramWaitPanel(this.jCbxDelete);
    private HiCALLObject callObj;
    private HiParam_RunScriptObject scriptObj;
    private String clientType;

    public RunScriptPanel(String clientType) {
        this.clientType = clientType;
        this.initialize(clientType);
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        if (!this.validFileName()) {
            throw new GUICheckException(MSG_RES.getString("RunScriptPanel.error.ScriptFileName"), this.jTFFile);
        }
        if (this.jTFFile.getText() == null || this.jTFFile.getText().trim().length() == 0) {
            throw new GUICheckException(MSG_RES.getString("RunScriptPanel.error.EnterScriptFileName"), this.jTFFile);
        }
        if (this.jTAFileText.getText() == null || this.jTAFileText.getText().trim().length() == 0) {
            throw new GUICheckException(MSG_RES.getString("RunScriptPanel.error.ScriptContent"), this.jTAFileText);
        }
        EmbeddedTempScriptFile scriptFile = this.scriptObj.getOptEmbeddedTempScriptFile();
        if (scriptFile == null) {
            scriptFile = new EmbeddedTempScriptFile();
            this.scriptObj.setOptEmbeddedTempScriptFile(scriptFile);
        }
        scriptFile.setName(this.jTFFile.getText().trim());
        scriptFile.setContent(this.jTAFileText.getText().trim());
        if (this.jTFCmd.getText().trim().length() == 0) {
            throw new GUICheckException(MSG_RES.getString("RunScriptPanel.error.EnterCndLine"), this.jTFCmd);
        }
        this.scriptObj.setCmdLine(this.jTFCmd.getText().trim());
        this.waitPanel.validateInput();
        this.scriptObj.setOptMaxTimeToWaitForComplete(this.waitPanel.getMaxWaitTime());
        this.scriptObj.setOptDeleteTmpFileAfterExec(this.jCbxDelete.isSelected());
        this.scriptObj.setOptWindowStyle(this.jCbxShow.isSelected() ? 1 : 0);
        try {
            this.callObj.setParameter((ConfigObject)this.scriptObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MSG_RES.getString("RunScriptPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private void initialize(String clientType) {
        this.jTAFileText.setWrapStyleWord(true);
        this.jTAFileText.setLineWrap(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(MSG_RES.getString("RunScriptPanel.label.FileName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(MSG_RES.getString("RunScriptPanel.label.ScriptContent")), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane scrollPanel = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPanel, (JTextArea)this.jTAFileText);
        this.add((Component)scrollPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MSG_RES.getString("RunScriptPanel.label.ExecuteCmd")), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
        this.add((Component)this.jTFCmd, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.waitPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jCbxDelete, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (!clientType.equalsIgnoreCase("Mac")) {
            this.add((Component)this.jCbxShow, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        }
    }

    private boolean validFileName() {
        if (this.clientType.equalsIgnoreCase("Mac")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(this.jTFFile.getText().trim(), ".");
        return st.countTokens() == 2;
    }

    private void updatePanel() {
        EmbeddedTempScriptFile scriptFile = this.scriptObj.getOptEmbeddedTempScriptFile();
        this.jTFFile.setText(scriptFile == null ? "" : scriptFile.getName());
        this.jTAFileText.setText(scriptFile == null ? "" : scriptFile.getContent());
        this.jTAFileText.setCaretPosition(0);
        this.jTFCmd.setText(this.scriptObj.getCmdLine());
        this.jCbxDelete.setSelected(this.scriptObj.getOptDeleteTmpFileAfterExec());
        this.jCbxShow.setSelected(this.scriptObj.getOptWindowStyle() == 1);
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.scriptObj = new HiParam_RunScriptObject(call.getParameter());
            this.waitPanel.updatePanel(this.scriptObj.getOptMaxTimeToWaitForComplete());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MSG_RES.getString("RunScriptPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }
}

