/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.ProgramWaitPanel;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_RunObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_Run;
import com.sygate.scm.hi.library.HiParm_RunScript;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class RunPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 7575351734455349409L;
    private JTextField jTFCommand = new JTextField(10);
    private JRadioButton jRBSystem = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.radio.InSystemContext"), true);
    private JRadioButton jRBUser = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.radio.InUserContext"));
    private ProgramWaitPanel waitPanel = new ProgramWaitPanel(null);
    private JCheckBox jCbxShow = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.checkbox.ShowNewProcWnd"));
    private HiCALLObject callObj;
    private HiParam_RunObject runObj;

    public RunPanel(String clientType) {
        this.initialize(clientType);
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        if (this.jTFCommand.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.error.EmptyCmdLine"), this.jTFCommand);
        }
        if (!Utility.isValidEnvVariableOrRegValueInput((String)this.jTFCommand.getText().trim(), (boolean)true)) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.error.InvalidEnvVars"), this.jTFCommand);
        }
        this.runObj.setCmdLine(this.jTFCommand.getText().trim());
        this.runObj.setOptUserContext(this.jRBSystem.isSelected() ? HiParm_RunScript.SYSTEM : HiParm_RunScript.CURRENT_USER);
        this.runObj.setOptWindowStyle(this.jCbxShow.isSelected() ? 1 : 0);
        this.waitPanel.validateInput();
        this.runObj.setOptMaxTimeToWaitForComplete(this.waitPanel.getMaxWaitTime());
        this.runObj.setOptDeleteTmpFileAfterExec(this.waitPanel.isDeleteTmpFileAfterExec());
        try {
            this.callObj.setParameter((ConfigObject)this.runObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private void initialize(String clientType) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(clientType), "North");
    }

    private JPanel getInnerPanel(String clientType) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.jTFCommand, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getRunPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.waitPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (!clientType.equalsIgnoreCase("Mac")) {
            panel.add((Component)this.jCbxShow, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.label.ExecuteCmd")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        } else {
            panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.label.Mac.ExecuteCmd")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        }
        return panel;
    }

    private JPanel getRunPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRBSystem);
        group.add(this.jRBUser);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        TitledBorder border = BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.title.RunProgram"));
        if (border.getTitleFont() != null) {
            border.setTitleFont(border.getTitleFont().deriveFont(0));
        } else {
            border.setTitleFont(this.getFont());
        }
        panel.setBorder(border);
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.label.UserContextDesc")), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.jRBSystem, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.jRBUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void updatePanel() {
        this.jTFCommand.setText(this.runObj.getCmdLine());
        this.jCbxShow.setSelected(this.runObj.getOptWindowStyle() == 1);
        if (this.runObj.getOptUserContext() != null && this.runObj.getOptUserContext().equals(HiParm_Run.SYSTEM)) {
            this.jRBSystem.setSelected(true);
        } else {
            this.jRBUser.setSelected(true);
        }
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.runObj = new HiParam_RunObject(call.getParameter());
            this.updatePanel();
            this.waitPanel.updatePanel(this.runObj.getOptMaxTimeToWaitForComplete());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "RunPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }
}

