/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ProgramWaitPanel
extends JPanel {
    private static final long serialVersionUID = -4129730752335650736L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.hi.customized.hicustomized");
    private static final String[] WAIT_TYPE = new String[]{MSG_RES.getString("ProgramWaitPanel.combo.DoNotWait"), MSG_RES.getString("ProgramWaitPanel.combo.WaitForComplete"), MSG_RES.getString("ProgramWaitPanel.combo.WaitCustom")};
    private JComboBox<String> jCmbTime = new JComboBox<String>(WAIT_TYPE);
    private JTextField jTFTime = new JTextField(new NumberPlainDocument(), "", 7);
    private JLabel jLSecond = new JLabel(MSG_RES.getString("ProgramWaitPanel.label.Seconds"));
    private JCheckBox checkBox;

    public ProgramWaitPanel(JCheckBox checkBox) {
        this.checkBox = checkBox;
        this.initialize();
    }

    public boolean validateInput() throws GUICheckException {
        if (this.jCmbTime.getSelectedIndex() == 2) {
            String time = this.jTFTime.getText().trim();
            int iTime = -1;
            if (time.length() == 0) {
                throw new GUICheckException(MSG_RES.getString("ProgramWaitPanel.error.EnterMaxTime"), this.jTFTime);
            }
            try {
                iTime = Integer.parseInt(time);
                if (iTime <= 0) {
                    throw new GUICheckException(MSG_RES.getString("ProgramWaitPanel.error.MaxPositive"), this.jTFTime);
                }
            }
            catch (NumberFormatException e) {
                throw new GUICheckException(MSG_RES.getString("ProgramWaitPanel.error.InvalidMax"), this.jTFTime);
            }
        }
        return true;
    }

    public void updatePanel(Integer maxWaitTime) {
        if (maxWaitTime != null) {
            int t = maxWaitTime;
            if (t == 0) {
                this.jCmbTime.setSelectedIndex(0);
            } else {
                this.jCmbTime.setSelectedIndex(2);
                this.jTFTime.setText("" + t);
            }
        } else {
            this.jCmbTime.setSelectedIndex(1);
        }
    }

    private void initialize() {
        this.jCmbTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramWaitPanel.this.waitTypeChanged();
            }
        });
        this.jTFTime.setHorizontalAlignment(2);
        this.setLayout(new GridBagLayout());
        TitledBorder border = BorderFactory.createTitledBorder(MSG_RES.getString("ProgramWaitPanel.title.SpecifyWait"));
        if (border.getTitleFont() != null) {
            border.setTitleFont(border.getTitleFont().deriveFont(0));
        } else {
            border.setTitleFont(this.getFont());
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(border), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.getWaitPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MSG_RES.getString("ProgramWaitPanel.label.TermAfterTimeout")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
    }

    private Box getWaitPanel() {
        Box box = new Box(0);
        box.add(this.jCmbTime);
        box.add(Box.createHorizontalStrut(2));
        box.add(this.jTFTime);
        box.add(Box.createHorizontalStrut(2));
        box.add(this.jLSecond);
        return box;
    }

    private void waitTypeChanged() {
        boolean isEnable = this.jCmbTime.getSelectedIndex() == 2;
        this.jTFTime.setEnabled(isEnable);
        this.jLSecond.setEnabled(isEnable);
        if (this.checkBox != null) {
            boolean isEnabled = this.jCmbTime.getSelectedIndex() != 0;
            this.checkBox.setEnabled(isEnabled);
            if (!isEnabled) {
                this.checkBox.setSelected(false);
            }
        }
    }

    public Integer getMaxWaitTime() {
        int index = this.jCmbTime.getSelectedIndex();
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return null;
            }
        }
        return Integer.valueOf(this.jTFTime.getText().trim());
    }

    public Boolean isDeleteTmpFileAfterExec() {
        return this.jCmbTime.getSelectedIndex() != 0;
    }
}

