/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_PopupObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_Popup;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class PopupPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = -5717373381189414186L;
    private static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.PanelInfo");
    private static final Image INFO = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconInfo.png"));
    private static final Image QUESTION = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconQuestion.png"));
    private static final Image WARNING = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconWarning.png"));
    private static final Image ERROR = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("IconError.png"));
    private static final String OK = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.button.OK");
    private static final String CANCEL = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.button.Cancel");
    private static final String YES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.button.Yes");
    private static final String NO = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.button.No");
    private static final String[] BUTTON_TYPE = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.button.OK"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.button.OKAndCancel"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.button.YesAndNo")};
    private static final Integer[] BUTTON_VALUE = new Integer[]{HiParm_Popup.MSG_OK, HiParm_Popup.MSG_OK_CANCEL, HiParm_Popup.MSG_YES_NO};
    private static final IconObject[] ICON_TYPE = new IconObject[]{new IconObject(INFO, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.icon.Info")), new IconObject(QUESTION, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.icon.Question")), new IconObject(WARNING, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.icon.Warning")), new IconObject(ERROR, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.icon.Error"))};
    private static final Integer[] ICON_VALUE = new Integer[]{HiParm_Popup.MSG_INFO, HiParm_Popup.MSG_QUESTION, HiParm_Popup.MSG_EXCLAMATION, HiParm_Popup.MSG_STOP};
    private static final String[][] DEFAULT_BUTTON = new String[][]{{OK}, {OK, CANCEL}, {YES, NO}};
    private JTextField jTFTitle = new JTextField(new RestrictedPlainDocument(64), "", 5);
    private JTextArea jTAText = new JTextArea();
    private JComboBox<String> jCmbButton = new JComboBox<String>(BUTTON_TYPE);
    private JComboBox<IconObject> jCmbIcon = new JComboBox<IconObject>(ICON_TYPE);
    private JComboBox<String> jCmbDefButton = new JComboBox<String>(DEFAULT_BUTTON[0]);
    private JCheckBox jChkDismiss;
    private JComboBox<String> jCmbRetButton = new JComboBox<String>(DEFAULT_BUTTON[0]);
    private JTextField jTFTime = new JTextField();
    private HiCALLObject callObj;
    private HiParam_PopupObject popupObj;

    public PopupPanel() {
        this.initialize();
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.popupObj = new HiParam_PopupObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        boolean dismiss;
        String title = this.jTFTitle.getText().trim();
        if (this.jTFTitle.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.error.EmptyCaption"), this.jTFTitle);
        }
        String text = this.jTAText.getText().trim();
        if (text.length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.error.EnterText"), this.jTAText);
        }
        String strWait = this.jTFTime.getText().trim();
        int wait = -1;
        if (strWait.length() > 0) {
            wait = Integer.parseInt(strWait);
        }
        if ((dismiss = this.jChkDismiss.isSelected()) && wait < 1) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.error.EnterWaitTime"), this.jTFTime);
        }
        this.popupObj.setOptTitle(title);
        this.popupObj.setText(text);
        this.popupObj.setOptType(BUTTON_VALUE[this.jCmbButton.getSelectedIndex()]);
        this.popupObj.setOptIcon(ICON_VALUE[this.jCmbIcon.getSelectedIndex()]);
        this.popupObj.setDismiss(dismiss);
        this.popupObj.setOptDefaultButton(this.translateButtonName((String)this.jCmbDefButton.getSelectedItem()));
        this.popupObj.setDefaultButton(this.translateButtonName((String)this.jCmbRetButton.getSelectedItem()));
        this.popupObj.setOptSecondsToWait(wait);
        try {
            this.callObj.setParameter((ConfigObject)this.popupObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private void initialize() {
        DescriptionTextArea desc = new DescriptionTextArea(DESCRIPTION);
        desc.setPreferredSize(desc.getPreferredSize());
        this.jTFTime.setDocument(new NumberPlainDocument(Integer.MAX_VALUE));
        this.jTFTime.setHorizontalAlignment(4);
        this.jCmbIcon.setRenderer(new ImageComboBoxRenderer());
        this.jCmbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupPanel.this.buttonTypeChanged();
            }
        });
        this.jChkDismiss = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.checkbox.DismissMsg"));
        this.jChkDismiss.setSelected(new HiParam_PopupObject().getDismiss());
        this.jChkDismiss.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupPanel.this.dismissStatusChanged();
            }
        });
        RestrictedPlainDocument textDoc = new RestrictedPlainDocument(1000);
        this.jTAText.setDocument(textDoc);
        this.jTAText.setWrapStyleWord(true);
        this.jTAText.setLineWrap(true);
        this.jTAText.setRows(4);
        this.jTAText.setPreferredSize(this.jTAText.getPreferredSize());
        this.setLayout(new GridBagLayout());
        this.add((Component)desc, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.label.CaptionMsgBox")), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTFTitle, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.label.TextMsgBox")), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        JScrollPane scrollPanel = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPanel, (JTextArea)this.jTAText);
        this.add((Component)scrollPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.label.SpecifyIcon")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.jCmbIcon, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.label.SpecifyButtons")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.jCmbButton, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.label.DefaultButton")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.jCmbDefButton, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.getDismissPanel(), new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
    }

    private JPanel getDismissPanel() {
        JPanel dismissPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        dismissPanel.add((Component)this.jChkDismiss, constraints);
        constraints.gridx = 1;
        constraints.insets.top = 0;
        constraints.insets.left = 5;
        constraints.weightx = 0.0;
        dismissPanel.add(this.jCmbRetButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets.top = 5;
        constraints.insets.left = 22;
        dismissPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "PopupPanel.label.MaximumSeconds")), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.5;
        constraints.insets.left = 5;
        dismissPanel.add((Component)this.jTFTime, constraints);
        return dismissPanel;
    }

    private void buttonTypeChanged() {
        int index = this.jCmbButton.getSelectedIndex();
        DefaultComboBoxModel buttonModel = (DefaultComboBoxModel)this.jCmbRetButton.getModel();
        buttonModel.removeAllElements();
        DefaultComboBoxModel defModel = (DefaultComboBoxModel)this.jCmbDefButton.getModel();
        defModel.removeAllElements();
        String[] answerList = DEFAULT_BUTTON[index];
        for (int i = 0; i < answerList.length; ++i) {
            buttonModel.addElement(answerList[i]);
            defModel.addElement(answerList[i]);
        }
    }

    private void dismissStatusChanged() {
        boolean dismiss = this.jChkDismiss.isSelected();
        this.jCmbRetButton.setEnabled(dismiss);
        this.jTFTime.setEnabled(dismiss);
    }

    private void updatePanel() {
        this.jTFTitle.setText(this.popupObj.getOptTitle());
        this.jTAText.setText(this.popupObj.getText());
        this.jCmbIcon.setSelectedIndex(this.getIndex(this.popupObj.getOptIcon(), ICON_VALUE));
        this.jCmbButton.setSelectedIndex(this.getIndex(this.popupObj.getOptType(), BUTTON_VALUE));
        this.buttonTypeChanged();
        this.jCmbRetButton.setSelectedItem(this.tranlateBackButtonName(this.popupObj.getDefaultButton()));
        this.jCmbDefButton.setSelectedItem(this.tranlateBackButtonName(this.popupObj.getOptDefaultButton()));
        this.jChkDismiss.setSelected(this.popupObj.getDismiss());
        this.jTFTime.setText((String)(this.popupObj.getOptSecondsToWait() != -1 ? "" + this.popupObj.getOptSecondsToWait() : ""));
        this.dismissStatusChanged();
    }

    private int getIndex(Integer value, Integer[] values) {
        if (value != null) {
            for (int i = 0; i < values.length; ++i) {
                if (!value.equals(values[i])) continue;
                return i;
            }
        }
        return 0;
    }

    private Integer translateButtonName(String button) {
        if (OK.equals(button)) {
            return HiParm_Popup.BTN_OK;
        }
        if (CANCEL.equals(button)) {
            return HiParm_Popup.BTN_CANCEL;
        }
        if (YES.equals(button)) {
            return HiParm_Popup.BTN_YES;
        }
        if (NO.equals(button)) {
            return HiParm_Popup.BTN_NO;
        }
        return HiParm_Popup.BTN_OK;
    }

    private String tranlateBackButtonName(Integer button) {
        if (HiParm_Popup.BTN_OK.equals(button)) {
            return OK;
        }
        if (HiParm_Popup.BTN_CANCEL.equals(button)) {
            return CANCEL;
        }
        if (HiParm_Popup.BTN_YES.equals(button)) {
            return YES;
        }
        if (HiParm_Popup.BTN_NO.equals(button)) {
            return NO;
        }
        return OK;
    }

    private static class IconObject {
        private ImageIcon icon;
        private String description;

        public IconObject(Image image, String desc) {
            this.icon = new ImageIcon(image);
            this.description = desc;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class ImageComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        public ImageComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setIcon(((IconObject)value).getIcon());
            this.setText(value.toString());
            return this;
        }
    }
}

