/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.OSPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckOSLanguage;
import com.sygate.scm.console.ui.policy.hi.logicobject.OSObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OSLanguagePanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 7993183201422951649L;
    private OSPanel osPanel = new OSPanel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSLanguagePanel.title.LangVer"), 2);
    private JTextField jTFId = new JTextField();
    private HiCALLObject callObj;
    private HiParam_CheckOSLanguage langObj;

    public OSLanguagePanel() {
        this.initialize();
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        try {
            int[] arr;
            OSObject osObj = this.osPanel.getOSObject();
            String id = this.jTFId.getText().trim();
            if (id.length() > 0) {
                osObj.addOS(new IntegerSet(id, 16));
            }
            if ((arr = osObj.getOSSet().toArray()) == null || arr.length < 1) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSLanguagePanel.error.SelectLang"));
            }
            this.langObj.setOSObject(osObj);
            this.callObj.setParameter((ConfigObject)this.langObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSLanguagePanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        catch (HeadlessException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        catch (BadFormatException ex) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSLanguagePanel.error.LangFormat"));
        }
        return true;
    }

    @Override
    public void setObject(HiCALLObject callObj) {
        try {
            this.callObj = callObj;
            this.langObj = new HiParam_CheckOSLanguage(callObj.getParameter());
            this.osPanel.setObject(this.langObj.getOSObject(), null);
            this.jTFId.setText(this.osPanel.getNonStandardOSType(this.langObj.getOSObject().getOSString()));
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSLanguagePanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add((Component)this.getLanguageIdPanel(), "South");
        Dimension p = this.osPanel.getPreferredSize();
        this.osPanel.setPreferredSize(new Dimension(p.width, 300));
        this.add((Component)this.osPanel, "Center");
    }

    private JPanel getLanguageIdPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSLanguagePanel.label.AdditionalLangs")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSLanguagePanel.label.LangIDs")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFId, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }
}

