/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.OSPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_IsOSObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.OSObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OSExistPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = -2654941998389407237L;
    private OSPanel osPanel = null;
    private HiCALLObject callObj;
    private HiParam_IsOSObject isOSObj;
    private String clientType = null;

    public OSExistPanel(String clientType) {
        this.clientType = clientType;
        this.initialize();
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        OSObject osObj = this.osPanel.getOSObject();
        int[] arr = osObj.getOSSet().toArray();
        if (arr == null || arr.length < 1) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSExistPanel.error.SelectOS"));
        }
        try {
            this.isOSObj.setOSObject(osObj);
            this.callObj.setParameter((ConfigObject)this.isOSObj.getHiParamIsOS());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSExistPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    @Override
    public void setObject(HiCALLObject callObj) {
        try {
            this.callObj = callObj;
            this.isOSObj = new HiParam_IsOSObject(callObj.getParameter());
            OSObject osObj = this.isOSObj.getOSObject();
            this.osPanel.setObject(osObj, null);
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSExistPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.osPanel = "Mac".equals(this.clientType) ? new OSPanel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSExistPanel.title.CheckWinVer"), 3) : new OSPanel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "OSExistPanel.title.CheckWinVer"), 0);
        Dimension p = this.osPanel.getPreferredSize();
        this.osPanel.setPreferredSize(new Dimension(p.width, 300));
        this.add((Component)this.osPanel, "Center");
    }
}

