/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_LogObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_Log;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = -7127671742002700512L;
    private static final String[] SEVERITY_DESC = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.combo.SeverityInfo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.combo.SeverityMinor"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.combo.SeverityMajor"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.combo.SeverityCritical")};
    private static final Integer[] SEVERITY_VALUE = new Integer[]{HiParm_Log.INFO, HiParm_Log.MINOR, HiParm_Log.MAJOR, HiParm_Log.CRITICAL};
    private JComboBox<String> jCmbSeverity = new JComboBox<String>(SEVERITY_DESC);
    private JTextArea jTAMessage = new JTextArea();
    private HiParam_LogObject logObj;
    private HiCALLObject callObj;

    public LogPanel() {
        this.initialize();
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.logObj = new HiParam_LogObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        if (this.jTAMessage == null || this.jTAMessage.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.error.EmptyLogMessage"), this.jTAMessage);
        }
        this.messageChanged();
        return true;
    }

    private void initialize() {
        RestrictedPlainDocument textDocument = new RestrictedPlainDocument(512);
        textDocument.setValidator("\t", false);
        this.jTAMessage.setDocument(textDocument);
        this.jTAMessage.setLineWrap(true);
        this.jCmbSeverity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.this.severityChanged();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.label.SeverityType")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add(this.jCmbSeverity, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.label.LogDesc")), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
        this.jTAMessage.setRows(10);
        JScrollPane scrollPanel = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPanel, (JTextArea)this.jTAMessage);
        this.add((Component)scrollPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
    }

    private void messageChanged() {
        String msg = this.jTAMessage.getText().trim();
        if (msg != null) {
            try {
                this.logObj.setMessage(msg);
                this.callObj.setParameter((ConfigObject)this.logObj.getSchemaObject());
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.title.ConsoleError"), 0);
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void severityChanged() {
        try {
            int index = this.jCmbSeverity.getSelectedIndex();
            this.logObj.setSeverity(SEVERITY_VALUE[index]);
            this.callObj.setParameter((ConfigObject)this.logObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "LogPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void updatePanel() {
        Integer severity = this.logObj.getSeverity();
        int index = 0;
        for (int i = 0; i < SEVERITY_VALUE.length; ++i) {
            if (!SEVERITY_VALUE[i].equals(severity)) continue;
            index = i;
            break;
        }
        this.jCmbSeverity.setSelectedIndex(index);
        String message = this.logObj.getMessage();
        this.jTAMessage.setText(message);
    }
}

