/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.ConfigPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.FunctionType;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.RefreshableCompInt;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FunctionPanel
extends JPanel
implements ConfigPanelInt {
    private static final long serialVersionUID = 7381219705876514523L;
    private static final String LABEL_CONDITION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FunctionPanel.label.SelectCondition");
    private static final String LABEL_FUNCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FunctionPanel.label.SelectFunction");
    private DefaultComboBoxModel<FunctionType> conditionModel;
    private DefaultComboBoxModel<FunctionType> executableModel;
    private transient ActionListener typeCmbBoxListener;
    private JLabel jLFuncType = new JLabel();
    private JComboBox<FunctionType> jCmbFuncType = new JComboBox();
    private JPanel configPanel = new JPanel(new BorderLayout());
    private JScrollPane sconfigPanel = new JScrollPane();
    private JPanel emptyPanel = new JPanel();
    private HiParamPanelInt cpanel;
    private transient HiCALLObject callObj;
    private transient FunctionType previousType;
    private transient RefreshableCompInt refreshComp;

    public FunctionPanel() {
        this.initialize();
    }

    public void selectFuncType(int index) {
        if (index != -1) {
            this.jCmbFuncType.setSelectedIndex(index);
        }
    }

    public void setObject(HiCALLObject object) {
        this.callObj = object;
        this.updatePanel();
    }

    @Override
    public void setRefreshComponent(RefreshableCompInt com) {
        this.refreshComp = com;
    }

    public boolean checkValidation() throws GUICheckException {
        return this.cpanel.validateInput();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)this.getFunctionTypePanel(), "North");
        this.add((Component)this.configPanel, "Center");
        this.sconfigPanel.setBorder(null);
        this.configPanel.add((Component)this.sconfigPanel, "Center");
    }

    private JPanel getFunctionTypePanel() {
        this.jCmbFuncType.addActionListener(this.getActionListener());
        JPanel panel = new JPanel(new VerticalFlowLayout(0, 0));
        panel.add(this.jLFuncType);
        panel.add(this.jCmbFuncType);
        return panel;
    }

    private ActionListener getActionListener() {
        if (this.typeCmbBoxListener == null) {
            this.typeCmbBoxListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FunctionPanel.this.functionTypeChanged();
                }
            };
        }
        return this.typeCmbBoxListener;
    }

    private DefaultComboBoxModel<FunctionType> getConditionModel(String clientType) {
        if (this.conditionModel == null) {
            this.conditionModel = !StringUtilities.isEmpty((String)clientType) && "Mac".equals(clientType) ? new DefaultComboBoxModel<FunctionType>(FunctionType.getConditionFuncTypeMac()) : new DefaultComboBoxModel<FunctionType>(FunctionType.getConditionFuncType());
        }
        return this.conditionModel;
    }

    private DefaultComboBoxModel<FunctionType> getExecutableModel(String clientType) {
        if (this.executableModel == null) {
            this.executableModel = !StringUtilities.isEmpty((String)clientType) && "Mac".equals(clientType) ? new DefaultComboBoxModel<FunctionType>(FunctionType.getMacExeFuncType()) : new DefaultComboBoxModel<FunctionType>(FunctionType.getExeFuncType());
        }
        return this.executableModel;
    }

    private void functionTypeChanged() {
        try {
            FunctionType ctype = (FunctionType)this.jCmbFuncType.getSelectedItem();
            if (this.previousType != null && this.previousType.equals(ctype)) {
                return;
            }
            if (ctype != null) {
                this.callObj.setFunctionType(ctype);
            }
            this.showConfigPanel(ctype);
            if (this.refreshComp != null) {
                this.refreshComp.refresh();
            }
            this.previousType = ctype;
        }
        catch (ConsoleException e1) {
            LoggerUtilities.logException((Throwable)e1);
            JOptionPane.showMessageDialog(Manager.getFrame(), e1.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FunctionPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void showConfigPanel(FunctionType ctype) {
        JPanel panel = this.emptyPanel;
        if (ctype != null) {
            this.cpanel = ctype.getPanel(this.callObj.getClientType());
            this.cpanel.setObject(this.callObj);
            panel = (JPanel)((Object)this.cpanel);
        }
        this.sconfigPanel.setViewportView(panel);
    }

    private void updatePanel() {
        boolean isCondition = this.callObj.usedAsCondition();
        String clientType = this.callObj.getClientType();
        if (isCondition) {
            this.jLFuncType.setText(LABEL_CONDITION);
            this.jCmbFuncType.setModel(this.getConditionModel(clientType));
        } else {
            this.jLFuncType.setText(LABEL_FUNCTION);
            this.jCmbFuncType.setModel(this.getExecutableModel(clientType));
        }
        String funcName = this.callObj.getFuncName();
        int index = -1;
        DefaultComboBoxModel curModel = (DefaultComboBoxModel)this.jCmbFuncType.getModel();
        for (int i = 0; i < curModel.getSize(); ++i) {
            FunctionType fType = (FunctionType)curModel.getElementAt(i);
            if (!fType.getFuncName().equals(funcName)) continue;
            index = i;
        }
        this.jCmbFuncType.removeActionListener(this.getActionListener());
        this.jCmbFuncType.setSelectedIndex(index);
        FunctionType ctype = (FunctionType)this.jCmbFuncType.getSelectedItem();
        this.showConfigPanel(ctype);
        this.jCmbFuncType.addActionListener(this.getActionListener());
    }
}

