/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_FileDownloadObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class FileDownloadPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 8483608527514230435L;
    private JTextField jTFSource = new JTextField();
    private JTextField jTFTarget = new JTextField();
    private JTextField jTFUserName = new JTextField();
    private JPasswordField jPFPassword = new SEPMPasswordField();
    private JCheckBox jCbxAuth = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.checkbox.AuthReqForHTTPOnly"));
    private JCheckBox jCbxShow = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.checkbox.ShowDownloadProgress"));
    private JCheckBox jCbxCancel = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.checkbox.AllowCancelHI"));
    private HiCALLObject callObj;
    private HiParam_FileDownloadObject downloadObj;
    private String osType = "Windows";

    public FileDownloadPanel(String osType) {
        this.initialize();
        if (osType != null) {
            this.osType = osType;
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        if (this.jTFSource.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.error.EmptyFileURL"), this.jTFSource);
        }
        if (!this.validateURL(this.jTFSource.getText().trim())) {
            throw new GUICheckException(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.error.InvalidURL"), this.jTFSource.getText().trim()), this.jTFSource);
        }
        String targetFolder = this.jTFTarget.getText().trim();
        if (targetFolder.length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.error.EmptyTargetDir"), this.jTFTarget);
        }
        if (this.jCbxAuth.isSelected()) {
            if (this.jTFUserName == null || this.jTFUserName.getText().trim().length() == 0) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.error.EmptyUsername"), this.jTFUserName);
            }
            if (this.jPFPassword == null || this.jPFPassword.getPassword().length == 0) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.error.EmptyPwd"), this.jPFPassword);
            }
        }
        if (!this.validTarget()) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.error.InvalidTargetDir"), this.jTFTarget);
        }
        try {
            this.downloadObj.setSource(this.jTFSource.getText().trim());
            this.downloadObj.setTargetDirectory(this.jTFTarget.getText().trim());
            if (this.jCbxAuth.isSelected()) {
                this.downloadObj.setOptPassword(new String(this.jPFPassword.getPassword()));
                this.downloadObj.setOptUserName(this.jTFUserName.getText().trim());
            } else {
                this.downloadObj.setOptPassword(null);
                this.downloadObj.setOptUserName(null);
            }
            this.downloadObj.setOptVisible(this.jCbxShow.isSelected());
            this.downloadObj.setOptAllowUserToCancel(this.jCbxCancel.isSelected());
            this.callObj.setParameter((ConfigObject)this.downloadObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private boolean validateURL(String urlStr) {
        if ("Mac".equalsIgnoreCase(this.osType)) {
            return URLUtility.isValidURLForMac((String)urlStr);
        }
        return URLUtility.isValidURLForWindows((String)urlStr);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        this.jTFSource.setDocument(new RestrictedPlainDocument(512));
        RestrictedPlainDocument pathDoc = new RestrictedPlainDocument(512);
        pathDoc.setValidator("\"<>*?|", false);
        this.jTFTarget.setDocument(pathDoc);
        this.jTFUserName.setDocument(new RestrictedPlainDocument(128));
        this.jPFPassword.setDocument(new RestrictedPlainDocument(128));
        this.jCbxAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isEnabled = FileDownloadPanel.this.jCbxAuth.isSelected();
                FileDownloadPanel.this.jTFUserName.setEnabled(isEnabled);
                FileDownloadPanel.this.jPFPassword.setEnabled(isEnabled);
            }
        });
        this.jCbxShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDownloadPanel.this.jCbxCancel.setEnabled(FileDownloadPanel.this.jCbxShow.isSelected());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.label.DownloadFromURLToTargetDir")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.label.FileURL")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFSource, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.label.TargetDir")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFTarget, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxAuth, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.label.UserName")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.jTFUserName, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.label.Password")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.jPFPassword, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.jCbxShow, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxCancel, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        return panel;
    }

    private void updatePanel() {
        this.jTFSource.setText(this.downloadObj.getSource());
        this.jTFTarget.setText(this.downloadObj.getTargetDirectory());
        boolean isEnabled = this.downloadObj.getOptPassword() != null;
        this.jCbxAuth.setSelected(isEnabled);
        this.jTFUserName.setEnabled(isEnabled);
        this.jPFPassword.setEnabled(isEnabled);
        this.jTFUserName.setText(isEnabled ? this.downloadObj.getOptUserName() : "");
        this.jPFPassword.setText(isEnabled ? this.downloadObj.getOptPassword() : "");
        this.jCbxShow.setSelected(Utility.getBooleanValue((Boolean)this.downloadObj.getOptVisible(), (Boolean)true));
        this.jCbxCancel.setSelected(Utility.getBooleanValue((Boolean)this.downloadObj.getOptAllowUserToCancel(), (Boolean)false));
        this.jCbxCancel.setEnabled(this.jCbxShow.isSelected());
    }

    private boolean validTarget() {
        String targetDir = this.jTFTarget.getText();
        if (targetDir.trim().length() < 3) {
            return false;
        }
        if (targetDir.startsWith("%") && targetDir.endsWith("%")) {
            return true;
        }
        if (targetDir.startsWith("%")) {
            String substr = null;
            int count = 0;
            StringTokenizer st = new StringTokenizer(targetDir, "%");
            while (st.hasMoreTokens()) {
                substr = st.nextToken();
                ++count;
            }
            if (count != 2) {
                return false;
            }
            return substr.charAt(0) == '\\';
        }
        if (targetDir.startsWith("/")) {
            return true;
        }
        String strUpper = targetDir.toUpperCase();
        return strUpper.charAt(0) >= 'A' && strUpper.charAt(0) <= 'Z' && targetDir.charAt(1) == ':' && targetDir.charAt(2) == '\\';
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.downloadObj = new HiParam_FileDownloadObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "FileDownloadPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }
}

