/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.schema.HiConditionBlock;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.logicobject.HiCommentObject;
import com.sygate.scm.console.logicobject.HiConditionBlockObject;
import com.sygate.scm.console.logicobject.HiENDIFObject;
import com.sygate.scm.console.logicobject.HiElseObject;
import com.sygate.scm.console.logicobject.HiIFObject;
import com.sygate.scm.console.logicobject.HiRequirementObject;
import com.sygate.scm.console.logicobject.HiReturnObject;
import com.sygate.scm.console.logicobject.HiScriptBlockObject;
import com.sygate.scm.console.logicobject.HiThenObject;
import com.sygate.scm.console.logicobject.HiTreeNodeInt;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.FunctionPanel;
import com.sygate.scm.console.ui.policy.hi.logicobject.ConfigPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.FunctionType;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiAddConditionNodeInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiAddStatementNodeInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiConditionNodeInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiCopitableInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiNotNodeInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiStatementNodeInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.RefreshableCompInt;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.BooleanWrapper;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CustomRequirementDlg
extends DialogBase
implements RefreshableCompInt {
    private static final long serialVersionUID = 7165834664947828854L;
    private static final String PARENT_NODE = "ParentNode";
    private static final String INDEX = "Index";
    private static final String ADD_COMMAND = "AddCommand";
    private static final String ADD_CONDITION = "AddCondition";
    private static final Map<String, Integer> ConditionTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> FunctionTypeMap = new HashMap<String, Integer>();
    private transient HiRequirementObject reqObj;
    private transient HostIntegrityObject hiObj;
    private JTree jTCondition = new JTree();
    private DefaultTreeModel conditionModel;
    private DefaultMutableTreeNode root;
    private JButton jBAdd = new JButton(UIText.get(0));
    private JPanel nodePanel;
    private JTextField jTFName = new JTextField();
    private JPanel andOrPanel;
    private JRadioButton andRdBtn;
    private JRadioButton orRdBtn;
    private JCheckBox jCbxPass = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.checkbox.AllowHICheckPass"));
    private Action addIf;
    private Action addComment;
    private Action addReturn;
    private Action addCall;
    private Action addAnd;
    private Action addOr;
    private Action addElse;
    private Action notCondition;
    private Action delete;
    private Action copy;
    private Action paste;
    private Action cut;
    private JPopupMenu addCommandPMenu;
    private JPopupMenu addConditionPMenu;
    private JPopupMenu addCommandWithElsePMenu;
    private JPopupMenu commandPMenu;
    private JPopupMenu conditionPMenu;
    private JPopupMenu commandWithElsePMenu;
    private JPopupMenu deletePMenu;
    private TreePath previousPath;
    private transient TreeSelectionListener treeListener;
    private int fun_exe_type_index = -1;
    private boolean dontCheck;
    private DefaultMutableTreeNode cutNode;
    private String modeValue = "NORMAL";
    private boolean isReadonly;
    private JTextField clientTypeTF;

    public CustomRequirementDlg(boolean isReadonly) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.CustomReq"), true);
        this.isReadonly = isReadonly;
        this.initialize();
    }

    public CustomRequirementDlg(JFrame frame) {
        super(frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.CustomReq"), true);
        this.initialize();
    }

    @Override
    public void refresh() {
        TreePath path = this.jTCondition.getSelectionPath();
        if (path != null) {
            TreeNode node = (TreeNode)path.getLastPathComponent();
            this.conditionModel.reload(node);
            this.jTCondition.setSelectionPath(path);
        } else {
            this.conditionModel.reload();
        }
    }

    @Override
    protected boolean isValidate() {
        DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)this.root.getLastChild();
        Object lastobj = lastNode.getUserObject();
        if (!(lastobj instanceof HiReturnObject)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.LastStatmentReturn"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.Error"), 0);
            return false;
        }
        return this.isOKtoMove();
    }

    @Override
    protected void commit() {
        block7: {
            if (!this.isOKtoMove()) {
                return;
            }
            String name = this.jTFName.getText().trim();
            try {
                int childCnt;
                DefaultMutableTreeNode node;
                if (name.length() == 0) {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.ReqNameEmpty"), this.jTFName);
                }
                boolean valid = this.hiObj.checkRequirementName(name, this.reqObj);
                if (!valid) {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.NameInUse"), this.jTFName);
                }
                this.reqObj.setName(name);
                if (this.previousPath != null && (node = (DefaultMutableTreeNode)this.previousPath.getLastPathComponent()).getUserObject() instanceof HiCALLObject) {
                    this.reqObj.setPhysicalFileObject(((HiCALLObject)node.getUserObject()).getPhysicalFileObject());
                }
                if ((childCnt = this.root.getChildCount()) == 0) {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.MinStatements"), this.jBAdd);
                }
                this.reqObj.setOptModeValue(this.modeValue);
                this.dispose();
            }
            catch (GUICheckException ge) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ge.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.Error"), 0);
                JComponent errComponent = ge.getErrorComponent();
                if (errComponent == null) break block7;
                errComponent.requestFocusInWindow();
            }
        }
    }

    @Override
    protected void cancel() {
        this.dontCheck = true;
        super.cancel();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.getHelpString();
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (!this.isOKtoMove(false)) {
                this.getDeletePMenu().show(this.jTCondition, e.getX(), e.getY());
                return;
            }
            this.getPaste().setEnabled(false);
            TreePath location = this.jTCondition.getPathForLocation(e.getX(), e.getY());
            this.jTCondition.setSelectionPath(location);
            if (location != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)location.getLastPathComponent();
                Map<String, Serializable> retMap = this.getCurrentAppendingNode();
                boolean addCommand = (Boolean)retMap.get(ADD_COMMAND);
                boolean addCondition = (Boolean)retMap.get(ADD_CONDITION);
                if (addCondition) {
                    HiConditionNodeInt condition;
                    JPopupMenu pMenu = this.getConditionPMenu();
                    this.jTCondition.add(pMenu);
                    if (PolicyHandler.hasCopiedObject(HiConditionNodeInt.class) && (condition = (HiConditionNodeInt)PolicyHandler.getCopiedObject()).isCondition()) {
                        this.getPaste().setEnabled(!this.isReadonly);
                    }
                    pMenu.show(this.jTCondition, e.getX(), e.getY());
                } else if (addCommand) {
                    HiStatementNodeInt statement;
                    DefaultMutableTreeNode elseNode;
                    Object elseObj;
                    Object thisObj;
                    JPopupMenu pMenu = null;
                    if (node != null && (thisObj = node.getUserObject()) instanceof HiThenObject && !((elseObj = (elseNode = node.getNextSibling()).getUserObject()) instanceof HiElseObject)) {
                        pMenu = this.getCommandWithElsePMenu();
                        if (PolicyHandler.hasCopiedObject(HiElseObject.class)) {
                            this.getPaste().setEnabled(!this.isReadonly);
                        }
                    }
                    if (pMenu == null) {
                        pMenu = this.getCommandPMenu();
                    }
                    this.jTCondition.add(pMenu);
                    if (!this.getPaste().isEnabled() && PolicyHandler.hasCopiedObject(HiStatementNodeInt.class) && (statement = (HiStatementNodeInt)PolicyHandler.getCopiedObject()).isStatement()) {
                        this.getPaste().setEnabled(!this.isReadonly);
                    }
                    pMenu.show(this.jTCondition, e.getX(), e.getY());
                }
            } else {
                HiStatementNodeInt statement;
                JPopupMenu pMenu = this.getCommandPMenu();
                this.jTCondition.add(pMenu);
                if (PolicyHandler.hasCopiedObject(HiStatementNodeInt.class) && (statement = (HiStatementNodeInt)PolicyHandler.getCopiedObject()).isStatement()) {
                    this.getPaste().setEnabled(!this.isReadonly);
                }
                pMenu.show(this.jTCondition, e.getX(), e.getY());
            }
        }
    }

    private JPopupMenu getDeletePMenu() {
        if (this.deletePMenu == null) {
            this.deletePMenu = new JPopupMenu();
            JMenuItem menu = new JMenuItem(this.getDelete());
            this.deletePMenu.add(menu);
            this.jTCondition.add(this.deletePMenu);
        }
        return this.deletePMenu;
    }

    private void treeValueChanged(TreeSelectionEvent e) {
        if (!this.isOKtoMove()) {
            return;
        }
        if (this.previousPath != null) {
            this.conditionModel.nodeChanged((TreeNode)this.previousPath.getLastPathComponent());
        }
        this.setActionStatus();
        TreePath path = this.jTCondition.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        HiTreeNodeInt treeNode = (HiTreeNodeInt)node.getUserObject();
        if (node.getParent().equals(this.root) && node.equals(this.root.getFirstChild())) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(!this.isReadonly);
        }
        this.nodePanel.removeAll();
        if (treeNode != null) {
            if (treeNode instanceof HiCALLObject) {
                ((HiCALLObject)treeNode).setClientType(this.reqObj.getClientTypeString());
            }
            JPanel showPanel = treeNode.getShowPanel();
            this.nodePanel.add((Component)showPanel, "Center");
            ((ConfigPanelInt)((Object)showPanel)).setRefreshComponent(this);
            if (showPanel instanceof FunctionPanel) {
                FunctionPanel p = (FunctionPanel)showPanel;
                p.selectFuncType(this.fun_exe_type_index);
            }
        }
        this.fun_exe_type_index = -1;
        this.nodePanel.updateUI();
        if (this.isReadonly) {
            UIUtilities.setContainerStatus(this.nodePanel, false);
        }
        this.previousPath = path;
    }

    private boolean isOKtoMove() {
        return this.isOKtoMove(true);
    }

    private boolean isOKtoMove(boolean showMessage) {
        if (this.dontCheck) {
            return true;
        }
        if (this.previousPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.previousPath.getLastPathComponent();
            HiTreeNodeInt treeNode = (HiTreeNodeInt)node.getUserObject();
            try {
                if (treeNode != null) {
                    treeNode.isValid();
                }
                return true;
            }
            catch (GUICheckException e) {
                this.jTCondition.removeTreeSelectionListener(this.getTreeSelectionListener());
                this.jTCondition.setSelectionPath(this.previousPath);
                this.jTCondition.addTreeSelectionListener(this.getTreeSelectionListener());
                if (showMessage) {
                    if (!StringUtilities.isEmpty((String)e.getMessage())) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage());
                    }
                    if (e.getErrorComponent() != null) {
                        e.getErrorComponent().requestFocusInWindow();
                    }
                }
                return false;
            }
        }
        return true;
    }

    private void addNode() {
        if (!this.isOKtoMove()) {
            return;
        }
        Map<String, Serializable> retMap = this.getCurrentAppendingNode();
        boolean addCommand = (Boolean)retMap.get(ADD_COMMAND);
        boolean addCondition = (Boolean)retMap.get(ADD_CONDITION);
        DefaultMutableTreeNode node = null;
        TreePath path = this.jTCondition.getSelectionPath();
        if (path != null) {
            node = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        if (addCondition) {
            JPopupMenu pMenu = this.getAddConditionPMenu();
            this.jBAdd.add(pMenu);
            pMenu.show(this.jBAdd, this.jBAdd.getX(), this.jBAdd.getY());
        } else if (addCommand) {
            Object ifObj;
            DefaultMutableTreeNode ifNode;
            Object thisObj;
            JPopupMenu pMenu = null;
            if (node != null && (thisObj = node.getUserObject()) instanceof HiThenObject && (ifNode = node.getNextSibling()) != null && (ifObj = ifNode.getUserObject()) instanceof HiENDIFObject) {
                pMenu = this.getAddCommandWithElsePMenu();
            }
            if (pMenu == null) {
                pMenu = this.getAddCommandPMenu();
            }
            this.jBAdd.add(pMenu);
            pMenu.show(this.jBAdd, this.jBAdd.getX(), this.jBAdd.getY());
        }
    }

    private JPopupMenu getAddCommandPMenu() {
        if (this.addCommandPMenu == null) {
            JMenuItem functionItem;
            int i;
            this.addCommandPMenu = new JPopupMenu();
            JMenuItem ifItem = new JMenuItem(this.getAddIf());
            JMenu callMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.menu.Function"));
            if ("Mac".equals(this.getClientTypeStr())) {
                for (i = 0; i < FunctionType.getMacExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            } else {
                for (i = 0; i < FunctionType.getExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            }
            JMenuItem returnItem = new JMenuItem(this.getAddReturn());
            JMenuItem commentItem = new JMenuItem(this.getAddComment());
            this.addCommandPMenu.add(ifItem);
            this.addCommandPMenu.add(callMenu);
            this.addCommandPMenu.add(returnItem);
            this.addCommandPMenu.add(commentItem);
        }
        return this.addCommandPMenu;
    }

    private JPopupMenu getConditionPMenu() {
        if (this.conditionPMenu == null) {
            this.conditionPMenu = new JPopupMenu();
            JMenu addMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.menu.AddBelow"));
            JMenuItem addAndItem = new JMenuItem(this.getAddAnd());
            JMenuItem addOrItem = new JMenuItem(this.getAddOr());
            addMenu.add(addAndItem);
            addMenu.add(addOrItem);
            JMenuItem notItem = new JMenuItem(this.getNotCondition());
            JMenuItem deleteItem = new JMenuItem(this.getDelete());
            JMenuItem copyItem = new JMenuItem(this.getCopy());
            JMenuItem pasteItem = new JMenuItem(this.getPaste());
            JMenuItem cutItem = new JMenuItem(this.getCut());
            this.conditionPMenu.add(notItem);
            this.conditionPMenu.add(addMenu);
            this.conditionPMenu.add(deleteItem);
            this.conditionPMenu.addSeparator();
            this.conditionPMenu.add(cutItem);
            this.conditionPMenu.add(copyItem);
            this.conditionPMenu.add(pasteItem);
            notItem.setEnabled(!this.isReadonly);
            addMenu.setEnabled(!this.isReadonly);
        }
        return this.conditionPMenu;
    }

    private Action getNotCondition() {
        if (this.notCondition == null) {
            this.notCondition = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.ToggleNOT")){
                private static final long serialVersionUID = 7402133609716485941L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.notAction();
                }
            };
        }
        return this.notCondition;
    }

    private void notAction() {
        TreePath path = this.jTCondition.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        if (nodeObj instanceof HiNotNodeInt) {
            HiNotNodeInt conditionNode = (HiNotNodeInt)nodeObj;
            conditionNode.setNotCondition();
            this.conditionModel.reload(node);
        }
    }

    private JPopupMenu getCommandWithElsePMenu() {
        if (this.commandWithElsePMenu == null) {
            JMenuItem functionItem;
            int i;
            this.commandWithElsePMenu = new JPopupMenu();
            JMenu addMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.menu.AddBelow"));
            JMenuItem ifItem = new JMenuItem(this.getAddIf());
            JMenuItem elseItem = new JMenuItem(this.getAddElse());
            JMenu callMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.menu.Function"));
            if ("Mac".equals(this.getClientTypeStr())) {
                for (i = 0; i < FunctionType.getMacExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            } else {
                for (i = 0; i < FunctionType.getExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            }
            JMenuItem returnItem = new JMenuItem(this.getAddReturn());
            JMenuItem commentItem = new JMenuItem(this.getAddComment());
            addMenu.add(ifItem);
            addMenu.add(elseItem);
            addMenu.add(callMenu);
            addMenu.add(returnItem);
            addMenu.add(commentItem);
            JMenuItem deleteItem = new JMenuItem(this.getDelete());
            JMenuItem copyItem = new JMenuItem(this.getCopy());
            JMenuItem pasteItem = new JMenuItem(this.getPaste());
            JMenuItem cutItem = new JMenuItem(this.getCut());
            this.commandWithElsePMenu.add(addMenu);
            this.commandWithElsePMenu.add(deleteItem);
            this.commandWithElsePMenu.addSeparator();
            this.commandWithElsePMenu.add(cutItem);
            this.commandWithElsePMenu.add(copyItem);
            this.commandWithElsePMenu.add(pasteItem);
            addMenu.setEnabled(!this.isReadonly);
        }
        return this.commandWithElsePMenu;
    }

    private JPopupMenu getCommandPMenu() {
        if (this.commandPMenu == null) {
            JMenuItem functionItem;
            int i;
            this.commandPMenu = new JPopupMenu();
            JMenu addMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.menu.AddBelow"));
            JMenuItem ifItem = new JMenuItem(this.getAddIf());
            JMenu callMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.menu.Function"));
            if ("Mac".equals(this.getClientTypeStr())) {
                for (i = 0; i < FunctionType.getMacExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            } else {
                for (i = 0; i < FunctionType.getExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            }
            JMenuItem returnItem = new JMenuItem(this.getAddReturn());
            JMenuItem commentItem = new JMenuItem(this.getAddComment());
            addMenu.add(ifItem);
            addMenu.add(callMenu);
            addMenu.add(returnItem);
            addMenu.add(commentItem);
            JMenuItem deleteItem = new JMenuItem(this.getDelete());
            JMenuItem copyItem = new JMenuItem(this.getCopy());
            JMenuItem pasteItem = new JMenuItem(this.getPaste());
            JMenuItem cutItem = new JMenuItem(this.getCut());
            this.commandPMenu.add(addMenu);
            this.commandPMenu.add(deleteItem);
            this.commandPMenu.addSeparator();
            this.commandPMenu.add(cutItem);
            this.commandPMenu.add(copyItem);
            this.commandPMenu.add(pasteItem);
            addMenu.setEnabled(!this.isReadonly);
        }
        return this.commandPMenu;
    }

    private Action getPaste() {
        if (this.paste == null) {
            this.paste = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.Paste")){
                private static final long serialVersionUID = -3771127636243439394L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.pasteNode();
                }
            };
        }
        return this.paste;
    }

    private void pasteNode() {
        CopitableObject copied = PolicyHandler.getCopiedObject();
        if (copied == null) {
            return;
        }
        try {
            Map<String, Serializable> retMap = this.getCurrentAppendingNode();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)retMap.get(PARENT_NODE);
            int index = (Integer)retMap.get(INDEX);
            boolean addCondition = (Boolean)retMap.get(ADD_CONDITION);
            boolean addStatement = (Boolean)retMap.get(ADD_COMMAND);
            if (copied instanceof HiCopitableInt) {
                HiCopitableInt hiCopied = (HiCopitableInt)copied;
                if (hiCopied.isStatement() && addStatement) {
                    CopitableObject newNode = copied.getPastedObject();
                    HiStatementNodeInt newStatement = newNode instanceof HiConditionBlockObject ? ((HiConditionBlockObject)newNode).getHiCallObject() : (HiStatementNodeInt)newNode;
                    this.addStatement(newStatement, -1);
                } else if (hiCopied.isCondition() && addCondition) {
                    HiConditionNodeInt newNode = (HiConditionNodeInt)copied.getPastedObject();
                    Object nodeObj = parentNode.getUserObject();
                    HiAddConditionNodeInt treeNode = (HiAddConditionNodeInt)nodeObj;
                    BooleanWrapper conditionType = treeNode.getAddConditionType();
                    if (conditionType == null || conditionType.isNull()) {
                        int ret = JOptionPane.showConfirmDialog(this, this.getAndOrPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.ConfirmOperator"), 2);
                        if (ret != 0) {
                            return;
                        }
                        conditionType = this.andRdBtn.isSelected() ? BooleanWrapper.TRUE_VALUE : BooleanWrapper.FALSE_VALUE;
                    }
                    HiConditionBlock newBlock = newNode.wrapWithBlock();
                    Map<String, Object> ret = treeNode.addCondition(newBlock, index, conditionType.booleanValue());
                    Boolean reload = (Boolean)ret.get("IsReplace");
                    DefaultMutableTreeNode focusNode = (DefaultMutableTreeNode)ret.get("FocusNode");
                    if (reload.booleanValue()) {
                        DefaultMutableTreeNode[] allNodes = (DefaultMutableTreeNode[])ret.get("NODE");
                        parentNode.removeAllChildren();
                        for (int i = 0; i < allNodes.length; ++i) {
                            parentNode.add(allNodes[i]);
                        }
                        this.conditionModel.reload(parentNode);
                        UIUtilities.expandTreeByDepth(this.jTCondition, parentNode, 5);
                    } else {
                        DefaultMutableTreeNode nextNode;
                        DefaultMutableTreeNode insertedNode = (DefaultMutableTreeNode)ret.get("NODE");
                        this.conditionModel.insertNodeInto(insertedNode, parentNode, index + 1);
                        if (parentNode.getIndex(insertedNode) == 0 && (nextNode = insertedNode.getNextSibling()) != null) {
                            this.conditionModel.reload(nextNode);
                        }
                    }
                    TreePath newPath = new TreePath(focusNode.getPath());
                    this.jTCondition.setSelectionPath(newPath);
                } else if (copied instanceof HiElseObject) {
                    HiElseObject copiedObj = (HiElseObject)copied.getPastedObject();
                    this.addElseStatement(copiedObj);
                }
            }
            if (this.cutNode != null) {
                this.deleteNode(this.cutNode, false);
                this.cutNode = null;
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private Action getCopy() {
        if (this.copy == null) {
            this.copy = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.Copy")){
                private static final long serialVersionUID = 2403358701860623526L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.copyNode();
                }
            };
        }
        return this.copy;
    }

    private Action getCut() {
        if (this.cut == null) {
            this.cut = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.Cut")){
                private static final long serialVersionUID = -720112167490888211L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.cutNode();
                }
            };
            this.cut.setEnabled(!this.isReadonly);
        }
        return this.cut;
    }

    private void cutNode() {
        try {
            TreePath path = this.jTCondition.getSelectionPath();
            if (path != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object nodeObj = node.getUserObject();
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                Object parentObj = parentNode.getUserObject();
                this.deletionTest(node, nodeObj, parentNode, parentObj);
                if (nodeObj instanceof CopitableObject) {
                    PolicyHandler.copyObject((CopitableObject)nodeObj);
                    this.cutNode = node;
                }
            }
        }
        catch (GUICheckException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.Error"), 0);
        }
    }

    private void copyNode() {
        DefaultMutableTreeNode node;
        Object nodeObj;
        TreePath path = this.jTCondition.getSelectionPath();
        if (path != null && (nodeObj = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof CopitableObject) {
            PolicyHandler.copyObject((CopitableObject)nodeObj);
        }
    }

    private Action getDelete() {
        if (this.delete == null) {
            this.delete = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = -667793505120108149L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.deleteNode();
                }
            };
            this.delete.setEnabled(!this.isReadonly);
        }
        return this.delete;
    }

    private void deleteNode(DefaultMutableTreeNode node) {
        this.deleteNode(node, true);
    }

    private void deleteNode(DefaultMutableTreeNode node, boolean reselect) {
        Object parentObj;
        DefaultMutableTreeNode parentNode;
        this.dontCheck = true;
        Object nodeObj = node.getUserObject();
        if ((node = this.getDeletionNode(node, nodeObj, parentNode = (DefaultMutableTreeNode)node.getParent(), parentObj = parentNode.getUserObject())) == null) {
            this.dontCheck = false;
            return;
        }
        nodeObj = node.getUserObject();
        HiTreeNodeInt treeNode = (HiTreeNodeInt)nodeObj;
        boolean refreshParent = treeNode.delete();
        DefaultMutableTreeNode newSelectNode = this.getNewSelectedNode(node, node);
        if (nodeObj instanceof HiIFObject) {
            DefaultMutableTreeNode thenNode = node.getNextSibling();
            DefaultMutableTreeNode endifNode = thenNode.getNextSibling();
            DefaultMutableTreeNode elseNode = null;
            if (endifNode.getUserObject() instanceof HiElseObject) {
                elseNode = endifNode;
                endifNode = elseNode.getNextSibling();
            }
            newSelectNode = this.getNewSelectedNode(node, endifNode);
            this.conditionModel.removeNodeFromParent(thenNode);
            this.conditionModel.removeNodeFromParent(endifNode);
            if (elseNode != null) {
                this.conditionModel.removeNodeFromParent(elseNode);
            }
            this.conditionModel.removeNodeFromParent(node);
        } else {
            this.conditionModel.removeNodeFromParent(node);
        }
        if (refreshParent) {
            HiTreeNodeInt parentTreeNode = (HiTreeNodeInt)parentObj;
            DefaultMutableTreeNode[] newNodes = parentTreeNode.getTreeNode();
            DefaultMutableTreeNode upperParentNode = (DefaultMutableTreeNode)parentNode.getParent();
            int index = upperParentNode.getIndex(parentNode);
            this.conditionModel.removeNodeFromParent(parentNode);
            if (newNodes != null) {
                this.conditionModel.insertNodeInto(newNodes[0], upperParentNode, index);
                UIUtilities.expandTreeByDepth(this.jTCondition, newNodes[0], 1);
                if (reselect) {
                    TreePath selectPath = new TreePath(newNodes[0].getPath());
                    this.jTCondition.setSelectionPath(selectPath);
                }
            }
        } else {
            if (newSelectNode == null) {
                try {
                    newSelectNode = (DefaultMutableTreeNode)parentNode.getFirstChild();
                }
                catch (NoSuchElementException e) {
                    LoggerUtilities.logException((Throwable)e);
                    newSelectNode = null;
                }
            }
            if (reselect) {
                if (newSelectNode != null) {
                    TreePath selectPath = new TreePath(newSelectNode.getPath());
                    this.jTCondition.setSelectionPath(selectPath);
                } else {
                    this.showNothingRightPane();
                }
            }
        }
        this.dontCheck = false;
    }

    private DefaultMutableTreeNode getDeletionNode(DefaultMutableTreeNode node, Object nodeObj, DefaultMutableTreeNode parentNode, Object parentObj) {
        int childCnt;
        String message = null;
        boolean isConfirming = false;
        if (parentObj instanceof HiIFObject) {
            childCnt = parentNode.getChildCount();
            if (childCnt == 1) {
                message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.ConfirmOneCond");
                node = parentNode;
                isConfirming = true;
            }
        } else if (parentObj instanceof HiThenObject) {
            childCnt = parentNode.getChildCount();
            if (childCnt == 1) {
                message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.OneStatementUnderTHEN");
                node = null;
            }
        } else if (parentObj instanceof HiElseObject && (childCnt = parentNode.getChildCount()) == 1) {
            message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.OneStatementUnderELSE");
            node = null;
        }
        if (nodeObj instanceof HiThenObject) {
            message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.ConfirmDeleteTHEN");
            node = node.getPreviousSibling();
            isConfirming = true;
        } else if (nodeObj instanceof HiENDIFObject) {
            message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.ConfirmDeleteENDIF");
            Object obj = (node = node.getPreviousSibling().getPreviousSibling()).getUserObject();
            if (obj instanceof HiThenObject) {
                node = node.getPreviousSibling();
            }
            isConfirming = true;
        }
        if (message != null) {
            if (isConfirming) {
                int ret = JOptionPane.showConfirmDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.Warning"), 0);
                if (ret == 0) {
                    return node;
                }
                return null;
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.Error"), 0);
            return null;
        }
        return node;
    }

    private DefaultMutableTreeNode getNewSelectedNode(DefaultMutableTreeNode startNode, DefaultMutableTreeNode endNode) {
        DefaultMutableTreeNode selNode = endNode.getNextNode();
        if (selNode == null) {
            selNode = startNode.getPreviousNode();
        }
        return selNode;
    }

    private void deletionTest(DefaultMutableTreeNode node, Object nodeObj, DefaultMutableTreeNode parentNode, Object parentObj) throws GUICheckException {
        int childCnt;
        if (parentObj instanceof HiIFObject) {
            int childCnt2 = parentNode.getChildCount();
            if (childCnt2 == 1) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.OneConditionUnderIF"));
            }
        } else if (parentObj instanceof HiThenObject) {
            int childCnt3 = parentNode.getChildCount();
            if (childCnt3 == 1) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.OneStatementUnderTHEN"));
            }
        } else if (parentObj instanceof HiElseObject && (childCnt = parentNode.getChildCount()) == 1) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.OneStatementUnderELSE"));
        }
        if (nodeObj instanceof HiThenObject) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.DeleteTHEN"));
        }
        if (nodeObj instanceof HiENDIFObject) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.error.DeleteENDIF"));
        }
    }

    private void showNothingRightPane() {
        this.nodePanel.removeAll();
        this.previousPath = null;
        this.nodePanel.updateUI();
    }

    private void deleteNode() {
        TreePath path = this.jTCondition.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.deleteNode(node);
        }
    }

    private Action getAddElse() {
        if (this.addElse == null) {
            this.addElse = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.Else")){
                private static final long serialVersionUID = 9019080841341230388L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.addElseStatement();
                }
            };
        }
        return this.addElse;
    }

    private void addElseStatement() {
        HiElseObject newElseObj = new HiElseObject();
        this.addElseStatement(newElseObj);
    }

    private void addElseStatement(HiElseObject elseObj) {
        DefaultMutableTreeNode node;
        Object treeObj;
        TreePath path = this.jTCondition.getSelectionPath();
        if (path != null && (treeObj = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof HiThenObject) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            int index = parentNode.getIndex(node);
            ++index;
            DefaultMutableTreeNode ifNode = node.getPreviousSibling();
            HiIFObject ifObj = (HiIFObject)ifNode.getUserObject();
            ifObj.setElseNode(elseObj);
            DefaultMutableTreeNode[] newNodes = elseObj.getTreeNode();
            for (int i = 0; i < newNodes.length; ++i) {
                this.conditionModel.insertNodeInto(newNodes[i], parentNode, index + i);
            }
            if (newNodes.length > 0) {
                TreePath newPath = new TreePath(newNodes[0].getPath());
                this.jTCondition.setSelectionPath(newPath);
            }
            UIUtilities.expandTreeByDepth(this.jTCondition, parentNode, 2);
        }
    }

    private JPopupMenu getAddCommandWithElsePMenu() {
        if (this.addCommandWithElsePMenu == null) {
            JMenuItem functionItem;
            int i;
            this.addCommandWithElsePMenu = new JPopupMenu();
            JMenuItem ifItem = new JMenuItem(this.getAddIf());
            JMenuItem elseItem = new JMenuItem(this.getAddElse());
            JMenu callMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.menu.Function"));
            if ("Mac".equals(this.getClientTypeStr())) {
                for (i = 0; i < FunctionType.getMacExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            } else {
                for (i = 0; i < FunctionType.getExeFuncType().length; ++i) {
                    functionItem = new JMenuItem(this.getAddCall(i));
                    callMenu.add(functionItem);
                }
            }
            JMenuItem returnItem = new JMenuItem(this.getAddReturn());
            JMenuItem commentItem = new JMenuItem(this.getAddComment());
            this.addCommandWithElsePMenu.add(ifItem);
            this.addCommandWithElsePMenu.add(elseItem);
            this.addCommandWithElsePMenu.add(callMenu);
            this.addCommandWithElsePMenu.add(returnItem);
            this.addCommandWithElsePMenu.add(commentItem);
        }
        return this.addCommandWithElsePMenu;
    }

    private Action getAddComment() {
        if (this.addComment == null) {
            this.addComment = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.Comment")){
                private static final long serialVersionUID = 2867605022022252118L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.addCommentStatement();
                }
            };
        }
        return this.addComment;
    }

    private void addCommentStatement() {
        HiCommentObject newComment = new HiCommentObject();
        this.addStatement(newComment, -1);
    }

    private Action getAddReturn() {
        if (this.addReturn == null) {
            this.addReturn = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.Return")){
                private static final long serialVersionUID = 7033561459846716700L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.addReturnStatement();
                }
            };
        }
        return this.addReturn;
    }

    private void addReturnStatement() {
        HiReturnObject newRetObj = new HiReturnObject();
        this.addStatement(newRetObj, -1);
    }

    private void addStatement(HiStatementNodeInt newObj, int fun_exe_type_index) {
        Map<String, Serializable> retMap = this.getCurrentAppendingNode();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)retMap.get(PARENT_NODE);
        int index = (Integer)retMap.get(INDEX);
        boolean addCommand = (Boolean)retMap.get(ADD_COMMAND);
        if (!addCommand) {
            return;
        }
        Object nodeObj = parentNode.getUserObject();
        HiScriptBlock block = newObj.wrapWithABlock();
        HiScriptBlockObject bObj = new HiScriptBlockObject(block);
        if (nodeObj instanceof HiAddStatementNodeInt) {
            HiAddStatementNodeInt treeNode = (HiAddStatementNodeInt)nodeObj;
            treeNode.addBlock(bObj, index);
        } else {
            this.reqObj.addBlock(bObj, index);
        }
        DefaultMutableTreeNode[] newNodes = newObj.getTreeNode();
        for (int i = 0; i < newNodes.length; ++i) {
            this.conditionModel.insertNodeInto(newNodes[i], parentNode, index + i);
        }
        if (newNodes.length > 0) {
            TreePath newPath = newNodes[0].getChildCount() > 0 ? new TreePath(((DefaultMutableTreeNode)newNodes[0].getFirstChild()).getPath()) : new TreePath(newNodes[0].getPath());
            this.fun_exe_type_index = fun_exe_type_index;
            this.jTCondition.setSelectionPath(newPath);
        }
        UIUtilities.expandTreeByDepth(this.jTCondition, parentNode, 2);
    }

    private Action getAddCall(int index) {
        FunctionType type = null;
        type = "Mac".equals(this.getClientTypeStr()) ? FunctionType.getMacExeFuncTypeByIndex(index) : FunctionType.getExeFuncTypeByIndex(index);
        String fuc_exe_type = type.getTypeDesc();
        final int type_index = index;
        this.addCall = new AbstractAction(fuc_exe_type){
            private static final long serialVersionUID = 3718002162190820888L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomRequirementDlg.this.addCallStatement(type_index);
            }
        };
        return this.addCall;
    }

    private void addCallStatement(int index) {
        HiCALLObject newCallObj = new HiCALLObject(this.reqObj.getClientTypeString());
        this.addStatement(newCallObj, index);
    }

    private Action getAddIf() {
        if (this.addIf == null) {
            this.addIf = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.IFTHENBlock")){
                private static final long serialVersionUID = 8779855363046625928L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.addIfStatement();
                }
            };
        }
        return this.addIf;
    }

    private void addIfStatement() {
        HiIFObject newIfObj = new HiIFObject();
        this.addStatement(newIfObj, -1);
    }

    private Map<String, Serializable> getCurrentAppendingNode() {
        int index;
        DefaultMutableTreeNode parentNode;
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        TreePath path = this.jTCondition.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object treeObj = node.getUserObject();
            if (treeObj instanceof HiIFObject) {
                parentNode = node;
                index = -1;
            } else if (treeObj instanceof HiThenObject || treeObj instanceof HiElseObject) {
                parentNode = node;
                index = 0;
            } else {
                parentNode = (DefaultMutableTreeNode)node.getParent();
                index = parentNode.getIndex(node);
                Object parentObj = parentNode.getUserObject();
                if (!(parentObj instanceof HiIFObject) && !(parentObj instanceof HiConditionBlockObject)) {
                    ++index;
                }
            }
        } else {
            parentNode = this.root;
            index = this.root.getChildCount();
        }
        boolean addCondition = false;
        boolean addCommand = true;
        Object nodeObj = parentNode.getUserObject();
        if (nodeObj instanceof HiTreeNodeInt) {
            HiTreeNodeInt parent = (HiTreeNodeInt)nodeObj;
            addCondition = parent.canAddCondition();
            addCommand = parent.canAddCommand();
        }
        retMap.put(PARENT_NODE, parentNode);
        retMap.put(INDEX, Integer.valueOf(index));
        retMap.put(ADD_COMMAND, Boolean.valueOf(addCommand));
        retMap.put(ADD_CONDITION, Boolean.valueOf(addCondition));
        return retMap;
    }

    private JPopupMenu getAddConditionPMenu() {
        if (this.addConditionPMenu == null) {
            this.addConditionPMenu = new JPopupMenu();
            JMenuItem addAndItem = new JMenuItem(this.getAddAnd());
            JMenuItem addOrItem = new JMenuItem(this.getAddOr());
            this.addConditionPMenu.add(addAndItem);
            this.addConditionPMenu.add(addOrItem);
        }
        return this.addConditionPMenu;
    }

    private Action getAddOr() {
        if (this.addOr == null) {
            this.addOr = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.Or")){
                private static final long serialVersionUID = -7924794105485476858L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.addOrCondition();
                }
            };
        }
        return this.addOr;
    }

    private void addOrCondition() {
        DefaultMutableTreeNode nextNode;
        HiCALLObject newCallObj;
        Map<String, Serializable> retMap = this.getCurrentAppendingNode();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)retMap.get(PARENT_NODE);
        int index = (Integer)retMap.get(INDEX);
        boolean addCondition = (Boolean)retMap.get(ADD_CONDITION);
        if (!addCondition) {
            return;
        }
        Object nodeObj = parentNode.getUserObject();
        HiAddConditionNodeInt treeNode = (HiAddConditionNodeInt)nodeObj;
        Map<String, Object> ret = treeNode.addOrConditionUnderIt(newCallObj = new HiCALLObject(this.reqObj.getClientTypeString()), index);
        if (ret == null) {
            ConsoleLogger.log("CustomRequirementDialog>addOrCondition>>ret unexpectedly null, returning");
            return;
        }
        boolean needReplace = (Boolean)ret.get("IsReplace");
        DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)ret.get("NODE");
        DefaultMutableTreeNode focusNode = (DefaultMutableTreeNode)ret.get("FocusNode");
        if (needReplace) {
            TreePath path = this.jTCondition.getSelectionPath();
            if (path != null) {
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object curObj = curNode.getUserObject();
                if (curObj instanceof HiIFObject) {
                    while (curNode.getChildCount() > 0) {
                        DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)curNode.getFirstChild();
                        this.conditionModel.removeNodeFromParent(firstChild);
                    }
                } else {
                    this.conditionModel.removeNodeFromParent(curNode);
                }
            }
            if (index != -1) {
                this.conditionModel.insertNodeInto(newNode, parentNode, index);
            } else {
                this.conditionModel.insertNodeInto(newNode, parentNode, 0);
            }
        } else {
            this.conditionModel.insertNodeInto(newNode, parentNode, index + 1);
        }
        if (parentNode.getIndex(newNode) == 0 && (nextNode = newNode.getNextSibling()) != null) {
            this.conditionModel.reload(nextNode);
        }
        if (newNode.getIndex(focusNode) == 0 && (nextNode = focusNode.getNextSibling()) != null) {
            this.jTCondition.expandPath(new TreePath(nextNode.getPath()));
        }
        TreePath newPath = new TreePath(focusNode.getPath());
        this.jTCondition.setSelectionPath(newPath);
    }

    private Action getAddAnd() {
        if (this.addAnd == null) {
            this.addAnd = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.action.And")){
                private static final long serialVersionUID = -8086543268584177023L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomRequirementDlg.this.addAndCondition();
                }
            };
        }
        return this.addAnd;
    }

    private void addAndCondition() {
        DefaultMutableTreeNode nextNode;
        Map<String, Serializable> retMap = this.getCurrentAppendingNode();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)retMap.get(PARENT_NODE);
        int index = (Integer)retMap.get(INDEX);
        boolean addCondition = (Boolean)retMap.get(ADD_CONDITION);
        if (!addCondition) {
            return;
        }
        Object nodeObj = parentNode.getUserObject();
        HiCALLObject newCallObj = new HiCALLObject(this.reqObj.getClientTypeString());
        HiAddConditionNodeInt treeNode = (HiAddConditionNodeInt)nodeObj;
        Map<String, Object> ret = treeNode.addAddConditionUnderIt(newCallObj, index);
        boolean needReplace = (Boolean)ret.get("IsReplace");
        DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)ret.get("NODE");
        DefaultMutableTreeNode focusNode = (DefaultMutableTreeNode)ret.get("FocusNode");
        if (needReplace) {
            TreePath path = this.jTCondition.getSelectionPath();
            if (path != null) {
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object curObj = curNode.getUserObject();
                if (curObj instanceof HiIFObject) {
                    while (curNode.getChildCount() > 0) {
                        DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)curNode.getFirstChild();
                        this.conditionModel.removeNodeFromParent(firstChild);
                    }
                } else {
                    this.conditionModel.removeNodeFromParent(curNode);
                }
            }
            if (index != -1) {
                this.conditionModel.insertNodeInto(newNode, parentNode, index);
            } else {
                this.conditionModel.insertNodeInto(newNode, parentNode, 0);
            }
        } else {
            this.conditionModel.insertNodeInto(newNode, parentNode, index + 1);
        }
        if (parentNode.getIndex(newNode) == 0 && (nextNode = newNode.getNextSibling()) != null) {
            this.conditionModel.reload(nextNode);
        }
        if (newNode.getIndex(focusNode) == 0 && (nextNode = focusNode.getNextSibling()) != null) {
            this.jTCondition.expandPath(new TreePath(nextNode.getPath()));
        }
        TreePath newPath = new TreePath(focusNode.getPath());
        this.jTCondition.setSelectionPath(newPath);
    }

    private void initialize() {
        this.setSize(950, 700);
        this.getContentPane().add(this.getInnerPanel());
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel top = this.getTopPanel();
        panel.add((Component)top, "North");
        panel.add((Component)this.getScriptPanel(), "Center");
        panel.add((Component)this.getBottomPane(), "South");
        if (this.isReadonly) {
            UIUtilities.setContainerStatus(top, false);
            this.jBAdd.setEnabled(false);
            this.jCbxPass.setEnabled(false);
            this.resetOKButton(false);
        }
        return panel;
    }

    private JPanel getTopPanel() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(256);
        doc.setValidator("\"/\\*?<>|:", false);
        this.jTFName.setDocument(doc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 8, 0, 5));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.label.Name")), cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.gridheight = 2;
        cons.gridwidth = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 2;
        cons.anchor = 10;
        cons.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.jTFName, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.label.ClientType")), cons);
        cons.gridx = 1;
        cons.gridy = 2;
        cons.gridheight = 2;
        cons.gridwidth = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 2;
        cons.anchor = 10;
        cons.insets = new Insets(5, 0, 0, 0);
        this.clientTypeTF = new JTextField(50);
        this.clientTypeTF.setEditable(false);
        panel.add((Component)this.clientTypeTF, cons);
        return panel;
    }

    private String getClientTypeStr() {
        String ret = "Windows";
        if (this.reqObj != null) {
            ret = this.reqObj.getClientTypeDisplayValue();
        }
        return ret;
    }

    private JSplitPane getScriptPanel() {
        JPanel treePanel = this.getTreePanel();
        JPanel nodePanel = this.getNodePanel();
        treePanel.setMinimumSize(new Dimension(100, treePanel.getMinimumSize().height));
        nodePanel.setMinimumSize(new Dimension(100, nodePanel.getMinimumSize().height));
        JSplitPane pane = new JSplitPane(1, treePanel, nodePanel);
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        pane.setResizeWeight(0.4);
        pane.setOneTouchExpandable(true);
        return pane;
    }

    private JPanel getTreePanel() {
        this.initConditionTree();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.title.CustomizedReqScript")));
        panel.add((Component)new JScrollPane(this.jTCondition), "Center");
        panel.add((Component)this.getTreeButtonPanel(), "South");
        panel.setPreferredSize(new Dimension(100, panel.getPreferredSize().height));
        return panel;
    }

    private JPanel getNodePanel() {
        if (this.nodePanel == null) {
            this.nodePanel = new JPanel(new BorderLayout());
            this.nodePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 0, 2, 0), BorderFactory.createTitledBorder("")));
        }
        return this.nodePanel;
    }

    private JComponent getBottomPane() {
        this.jCbxPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomRequirementDlg.this.modeValue = CustomRequirementDlg.this.jCbxPass.isSelected() ? "TEST" : "NORMAL";
            }
        });
        Box upBox = Box.createHorizontalBox();
        upBox.add(this.jCbxPass);
        upBox.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)upBox, "North");
        panel.add((Component)this.getButtonPanel(), "South");
        return panel;
    }

    private void initConditionTree() {
        DefaultTreeCellRenderer render = (DefaultTreeCellRenderer)this.jTCondition.getCellRenderer();
        render.setLeafIcon(null);
        render.setOpenIcon(null);
        render.setClosedIcon(null);
        this.root = new DefaultMutableTreeNode();
        this.conditionModel = new DefaultTreeModel(this.root);
        this.jTCondition.setModel(this.conditionModel);
        this.jTCondition.setShowsRootHandles(true);
        this.jTCondition.setRootVisible(false);
        this.jTCondition.addTreeSelectionListener(this.getTreeSelectionListener());
        this.jTCondition.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CustomRequirementDlg.this.showPopupMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CustomRequirementDlg.this.showPopupMenu(e);
            }
        });
    }

    private TreeSelectionListener getTreeSelectionListener() {
        if (this.treeListener == null) {
            this.treeListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    CustomRequirementDlg.this.treeValueChanged(e);
                }
            };
        }
        return this.treeListener;
    }

    private JPanel getTreeButtonPanel() {
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomRequirementDlg.this.addNode();
            }
        });
        JPanel panel = new JPanel();
        GridLayout gLayout = new GridLayout(1, 2);
        gLayout.setHgap(2);
        panel.setLayout(gLayout);
        panel.add(this.jBAdd);
        panel.add(new JButton(this.getDelete()));
        return panel;
    }

    private void updatePanel() {
        this.jTFName.setText(this.reqObj.getName());
        DefaultMutableTreeNode[] allNodes = this.reqObj.getTreeNode();
        for (int i = 0; i < allNodes.length; ++i) {
            this.conditionModel.insertNodeInto(allNodes[i], this.root, i);
        }
        UIUtilities.expandTreeByDepth(this.jTCondition, this.root, 5);
        if (allNodes.length > 0) {
            TreePath path = new TreePath(allNodes[0].getPath());
            this.jTCondition.setSelectionPath(path);
        }
        this.modeValue = this.reqObj.getOptModeValue();
        if (this.modeValue == null || this.modeValue.equals("NORMAL")) {
            this.jCbxPass.setSelected(false);
        } else {
            this.jCbxPass.setSelected(true);
        }
    }

    private void setActionStatus() {
        this.getDelete().setEnabled(false);
        this.getCopy().setEnabled(false);
        this.getCut().setEnabled(false);
        TreePath path = this.jTCondition.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeObj = curNode.getUserObject();
            if (nodeObj instanceof HiTreeNodeInt) {
                this.getDelete().setEnabled(!this.isReadonly);
            }
            if (nodeObj instanceof CopitableObject) {
                this.getCopy().setEnabled(true);
                this.getCut().setEnabled(!this.isReadonly);
            }
        }
    }

    private JPanel getAndOrPanel() {
        if (this.andOrPanel == null) {
            this.andOrPanel = new JPanel();
            JLabel title = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.label.ConfirmConditionOperator"));
            this.andRdBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.radio.ANDCond"));
            this.orRdBtn = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CustomRequirementDlg.radio.ORCond"));
            ButtonGroup bGrp = new ButtonGroup();
            bGrp.add(this.andRdBtn);
            bGrp.add(this.orRdBtn);
            this.andOrPanel.setLayout(new BoxLayout(this.andOrPanel, 1));
            this.andOrPanel.add(title);
            this.andOrPanel.add(this.andRdBtn);
            this.andOrPanel.add(this.orRdBtn);
        }
        this.andRdBtn.setSelected(true);
        return this.andOrPanel;
    }

    private String getHelpString() {
        HiCALLObject cobj = null;
        DefaultMutableTreeNode node = null;
        TreePath path = this.jTCondition.getSelectionPath();
        System.out.println(path != null);
        if (path != null) {
            node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof HiCALLObject)) {
                if (node.getUserObject() == null) {
                    return "sesm_policies_dialog_hi_requirements_add_customrequirement_default";
                }
                if (node.getUserObject().toString().indexOf("//") == 0) {
                    return "sesm_policies_dialog_hi_requirements_add_customrequirement_comment";
                }
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_return";
            }
        } else {
            return "sesm_policies_dialog_hi_requirements_add_customrequirement_default";
        }
        cobj = (HiCALLObject)node.getUserObject();
        System.out.println("function name " + cobj.getFuncName());
        int type = -11;
        type = cobj.usedAsCondition() ? FunctionType.getConditionTypeByName(cobj.getFuncName()) : FunctionType.getFunctionTypeByName(cobj.getFuncName());
        switch (type) {
            case 0: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_os_is";
            }
            case 1: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_process_is_running";
            }
            case 2: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_service_is_running";
            }
            case 3: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_message_dialog_return_value_equals";
            }
            case 4: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_os_system_language_is";
            }
            case 5: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_patch_compare_current_servicepack_with_specified_version";
            }
            case 6: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_file_compare_file_exists";
            }
            case 8: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_file_compare_sizeto";
            }
            case 9: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_file_compare_dateto";
            }
            case 10: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_file_compare_ageto";
            }
            case 11: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_file_compare_versionto";
            }
            case 12: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_file_download_complete";
            }
            case 7: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_file_fingerprint_equals";
            }
            case 13: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_registry_key_existing";
            }
            case 14: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_registry_value_existing";
            }
            case 15: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_registry_value_equals";
            }
            case 16: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_registry_set_registry_value";
            }
            case 17: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_registry_increment_registrywith_dword_value";
            }
            case 18: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_av_installed";
            }
            case 19: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_av_running";
            }
            case 20: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_av_signature_uptodate";
            }
            case 21: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_patch_is_installed";
            }
            case 22: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_check_timestamp";
            }
            case 23: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_asw_installed";
            }
            case 24: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_asw_running";
            }
            case 25: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_asw_signature_uptodate";
            }
            case 26: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_firewall_is_installed";
            }
            case 27: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_firewall_is_running";
            }
            case 28: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_log_message";
            }
            case 29: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_wait";
            }
            case 30: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_show_message_dialog";
            }
            case 31: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_run_a_program";
            }
            case 32: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_run_a_script";
            }
            case 33: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_function_download";
            }
            case 34: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_registry_set_registry_value";
            }
            case 35: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_registry_increment_registrywith_dword_value";
            }
            case 36: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_utility_set_timestamp";
            }
            case 37: {
                return "sesm_policies_dialog_hi_requirements_add_customrequirement_av_check_not_infected";
            }
        }
        return "sesm_policies_dialog_hi_requirements_add_customrequirement_default";
    }

    public void setObject(HiRequirementObject reqObj, HostIntegrityObject hiObj) {
        this.reqObj = reqObj;
        this.hiObj = hiObj;
        this.clientTypeTF.setText(this.getClientTypeStr());
        this.updatePanel();
    }

    static {
        ConditionTypeMap.put("CheckOS", 0);
        ConditionTypeMap.put("CheckProcess", 1);
        ConditionTypeMap.put("CheckService", 2);
        ConditionTypeMap.put("Popup", 3);
        ConditionTypeMap.put("CheckOSLanguage", 4);
        ConditionTypeMap.put("CheckServicePack", 5);
        ConditionTypeMap.put("FileExist", 6);
        ConditionTypeMap.put("FileChecksumEqualTo", 7);
        ConditionTypeMap.put("FileSizeCompare", 8);
        ConditionTypeMap.put("FileDateCompare", 9);
        ConditionTypeMap.put("FileAge", 10);
        ConditionTypeMap.put("FileVersion", 11);
        ConditionTypeMap.put("FileDownload", 12);
        ConditionTypeMap.put("RegistryKeyExist", 13);
        ConditionTypeMap.put("RegistryValueExist", 14);
        ConditionTypeMap.put("RegistryValue", 15);
        ConditionTypeMap.put("RegistrySetValue", 16);
        ConditionTypeMap.put("RegistryIncrementValue", 17);
        ConditionTypeMap.put("CheckAvInstallation", 18);
        ConditionTypeMap.put("CheckAvRunning", 19);
        ConditionTypeMap.put("CheckAvUpToDate", 20);
        ConditionTypeMap.put("CheckPatch", 21);
        ConditionTypeMap.put("SavedTimePeriodCompare", 22);
        ConditionTypeMap.put("CheckAswInstallation", 23);
        ConditionTypeMap.put("CheckAswRunning", 24);
        ConditionTypeMap.put("CheckAswUpToDate", 25);
        ConditionTypeMap.put("CheckFwInstallation", 26);
        ConditionTypeMap.put("CheckFwRunning", 27);
        FunctionTypeMap.put("Log", 28);
        FunctionTypeMap.put("Sleep", 29);
        FunctionTypeMap.put("Popup", 30);
        FunctionTypeMap.put("Run", 31);
        FunctionTypeMap.put("RunScript", 32);
        FunctionTypeMap.put("FileDownload", 33);
        FunctionTypeMap.put("RegistrySetValue", 34);
        FunctionTypeMap.put("RegistryIncrementValue", 35);
        FunctionTypeMap.put("SaveTime", 36);
    }
}

