/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_SavedTimePeriodObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CheckTimestampPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = 4844978582617127576L;
    private static String[] STR_RADIO = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.label.CheckTimestampMinutes"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.label.CheckTimestampHours"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.label.CheckTimestampDays"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.label.CheckTimestampWeeks")};
    private static long[] UNIT = new long[]{60000L, 3600000L, 86400000L, 604800000L};
    private static final long[] TIME_LIMIT = new long[]{Utility.getMaxMinute((boolean)false), Utility.getMaxHour((boolean)false), Utility.getMaxDay((boolean)false), Utility.getMaxWeek((boolean)false)};
    private JTextField jTFName = new JTextField(10);
    private JTextField[] jTFTime = new JTextField[]{new JTextField(15), new JTextField(15), new JTextField(15), new JTextField(15)};
    private JRadioButton[] jrbLable = new JRadioButton[]{new JRadioButton(STR_RADIO[0]), new JRadioButton(STR_RADIO[1]), new JRadioButton(STR_RADIO[2]), new JRadioButton(STR_RADIO[3])};
    private ButtonGroup buttonGroup = new ButtonGroup();
    private CJRBListener jrbListener = new CJRBListener();
    private HiCALLObject callObj;
    private HiParam_SavedTimePeriodObject proObj;

    public CheckTimestampPanel() {
        this.initialize();
        this.timeUnitChanged();
    }

    @Override
    public void setObject(HiCALLObject callObj) {
        try {
            this.callObj = callObj;
            this.proObj = new HiParam_SavedTimePeriodObject(callObj.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        if (this.jTFName.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.error.NameEmpty"), this.jTFName);
        }
        if (this.jTFTime[this.getSelectedIndex()].getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.error.TimeEmpty"), this.jTFTime[this.getSelectedIndex()]);
        }
        try {
            this.proObj.setName(this.jTFName.getText().trim());
            String strTime = this.jTFTime[this.getSelectedIndex()].getText().trim();
            long time = Long.parseLong(strTime);
            int index = this.getSelectedIndex();
            this.proObj.setTime(time * UNIT[index]);
            this.callObj.setParameter((ConfigObject)this.proObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private void initialize() {
        this.jTFName.setDocument(new RestrictedPlainDocument(255, "^=\t", false));
        for (int i = 0; i < 4; ++i) {
            this.jTFTime[i].setHorizontalAlignment(4);
            this.jrbLable[i].addChangeListener(this.jrbListener);
            this.buttonGroup.add(this.jrbLable[i]);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        DescriptionTextArea desc1 = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.CompareTimestamp"));
        DescriptionTextArea desc2 = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.PerformActionInfo"));
        Dimension size = desc2.getPreferredSize();
        desc1.setPreferredSize(size);
        desc2.setPreferredSize(size);
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.label.TimestampEmpty"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)desc1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)desc2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getNamePanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.getTimePanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)label, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getNamePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckTimestampPanel.label.TimestampName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTimePanel() {
        JPanel panel1 = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new FlowLayout(7));
        panel1.add((Component)this.jrbLable[0], new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jTFTime[0], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jrbLable[1], new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jTFTime[1], new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jrbLable[2], new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jTFTime[2], new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jrbLable[3], new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)this.jTFTime[3], new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(panel1);
        return panel;
    }

    private void timeUnitChanged() {
        String timeStr = this.jTFTime[this.getSelectedIndex()].getText().trim();
        long timeLimit = TIME_LIMIT[this.getSelectedIndex()];
        this.jTFTime[this.getSelectedIndex()].setDocument(new NumberPlainDocument(timeLimit, true));
        for (int i = 0; i < 4; ++i) {
            this.jTFTime[i].setEnabled(i == this.getSelectedIndex());
        }
        long time = timeStr.length() == 0 ? 0L : Long.parseLong(timeStr);
        this.jTFTime[this.getSelectedIndex()].setText(time <= timeLimit ? timeStr : String.valueOf(timeLimit));
    }

    private void updatePanel() {
        this.jTFName.setText(this.proObj.getName());
        long time = this.proObj.getTime();
        int index = PolicyHandler.getIndexOfValueFromList(time, UNIT);
        this.jrbLable[index].setSelected(true);
        this.jTFTime[this.getSelectedIndex()].setText(String.valueOf(time / UNIT[index]));
    }

    protected int getSelectedIndex() {
        for (int i = 0; i < 4; ++i) {
            if (!this.jrbLable[i].isSelected()) continue;
            return i;
        }
        return 0;
    }

    class CJRBListener
    implements ChangeListener {
        CJRBListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            CheckTimestampPanel.this.timeUnitChanged();
        }
    }
}

