/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.customized;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.HIUtility;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParamPanelInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_CheckServicePackObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.hi.library.HiParm_CheckServicePack;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CheckServicePackPanel
extends JPanel
implements HiParamPanelInt {
    private static final long serialVersionUID = -2943897555782416004L;
    private static final String[] OP_TYPES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.combo.EqualTo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.combo.NotEqualTo"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.combo.LessThan"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.combo.GreaterThan")};
    private static final Integer[] OP_VALUES = new Integer[]{HiParm_CheckServicePack.EQUAL, HiParm_CheckServicePack.NOT_EQUAL, HiParm_CheckServicePack.LESS_THAN, HiParm_CheckServicePack.GREATER_THAN};
    private JTextField jTFPack = new JTextField();
    private JComboBox<String> jCmbPack = new JComboBox<String>(OP_TYPES);
    private HiParam_CheckServicePackObject packObj;
    private HiCALLObject callObj;

    public CheckServicePackPanel() {
        this.initialize();
    }

    @Override
    public void setObject(HiCALLObject call) {
        try {
            this.callObj = call;
            this.packObj = new HiParam_CheckServicePackObject(call.getParameter());
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public boolean validateInput() throws GUICheckException {
        if (this.jTFPack == null || this.jTFPack.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.error.EnterSPNo"), this.jTFPack);
        }
        try {
            this.packObj.setOperator(OP_VALUES[this.jCmbPack.getSelectedIndex()]);
            this.packObj.setServicePackNum(Long.parseLong(this.jTFPack.getText().trim()));
            this.callObj.setParameter((ConfigObject)this.packObj.getSchemaObject());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        this.jTFPack.setDocument(HIUtility.createServicePackNumberDocument(this.jTFPack, 2));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.label.CompareSPNo")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getServicePackPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private Box getServicePackPanel() {
        Box box = new Box(0);
        box.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "CheckServicePackPanel.label.SPNoIs")));
        box.add(this.jCmbPack);
        box.add(this.jTFPack);
        return box;
    }

    private void updatePanel() {
        this.jCmbPack.setSelectedIndex(this.packObj.getOperator());
        long sp = this.packObj.getServicePackNum();
        this.jTFPack.setText((String)(sp != 0L ? "" + sp : ""));
    }
}

