/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.hi.HIAdvancePanel;
import com.sygate.scm.console.ui.policy.hi.HIRequirementPanel;
import com.sygate.scm.console.ui.policy.hi.HiPolicyTabPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JPanel;

public class HiPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 2156858767963380489L;
    private HostIntegrityObject hiObj;
    private HIRequirementPanel requirementPane;
    private HIAdvancePanel advancePane;

    public HiPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(56, name, gpObj, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyDialog.title"), true, isLocal);
    }

    public HiPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public HiPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(56, pool, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyDialog.title"), isCheckPolicyEnforcement, true);
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        this.setNewPolicy(true);
        this.hiObj = new HostIntegrityObject();
        try {
            this.hiObj.createNewHostIntegrityByDefault();
            List<String> nameList = pool.getAllName();
            String newName = PolicyHandler.adjustName(this.hiObj.getName(), nameList, 512);
            if (newName != null) {
                this.hiObj.setName(newName);
            }
            this.updatePanel();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            this.hiObj.createNewHostIntegrity();
        }
        return this.hiObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        this.hiObj = new HostIntegrityObject(schema);
        this.updatePanel();
        return this.hiObj;
    }

    @Override
    protected void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.hiObj.setName(this.getOverviewPanel().getPolicyName());
        this.hiObj.setDescription(this.getOverviewPanel().getPolicyDesc());
        this.hiObj.setEnabled(this.getOverviewPanel().isPolicyEnabled());
        this.requirementPane.save();
        this.advancePane.save();
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected boolean isValidate() {
        return this.isValidName(this.hiObj.getSchemaObj(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyDialog.nameIsARequirementFiled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyDialog.theNameHasBeenUsed"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyDialog.invalidName")) && this.advancePane.isValidate();
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        HiPolicyTabPanel panel = new HiPolicyTabPanel(this, "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyDialog.HostIntegrityPolicy") + "</html>", "hi_policy_32.png");
        panel.putClientProperty("cssClass", "HiPolicyDialogTabPanel");
        return panel;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getRequirementPanel()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyTabPanel.Requirements"));
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getAdvancePanel()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HiPolicyTabPanel.AdvancedSettings"));
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getRequirementPanel(), this.getAdvancePanel()};
    }

    private HIRequirementPanel getRequirementPanel() {
        if (this.requirementPane == null) {
            this.requirementPane = new HIRequirementPanel();
        }
        return this.requirementPane;
    }

    private HIAdvancePanel getAdvancePanel() {
        if (this.advancePane == null) {
            this.advancePane = new HIAdvancePanel();
        }
        return this.advancePane;
    }

    private void updatePanel() {
        this.getOverviewPanel().setObject(this.hiObj);
        this.requirementPane.setObject(this.hiObj);
        this.advancePane.setObject(this.hiObj);
        this.getOverviewPanel().setPolicyEnabled(this.hiObj.getEnabled());
    }
}

