/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.schema.HiPredefinedReqName;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryPool;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedType;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SafeSimpleDateFormat;
import com.sygate.scm.util.Utility;
import java.awt.Toolkit;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class HIUtility {
    private static final SafeSimpleDateFormat dateSsdf = new SafeSimpleDateFormat("MM/dd/yyyy");
    private static final SafeSimpleDateFormat timeSsdf = new SafeSimpleDateFormat("HH:mm");

    public static long parseDate(String date) throws ParseException {
        if (date.length() == 0) {
            return System.currentTimeMillis();
        }
        return ((SimpleDateFormat)dateSsdf.get()).parse(date).getTime();
    }

    public static String formatDate(long time) {
        return UIUtilities.formatDate(time, (Format)dateSsdf.get());
    }

    public static String validateAvTypeString(String avType) {
        if (null != avType && avType.equals("AV_NORTON_CORP")) {
            return "AV_NORTON_CORP_SEP";
        }
        return avType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateDate(JTextField jTFDate) throws GUICheckException {
        boolean MONTH = false;
        boolean DAY = true;
        int YEAR = 2;
        String text = jTFDate.getText().trim();
        if (text.length() == 0) {
            return false;
        }
        boolean isvalid = true;
        int col = 0;
        StringTokenizer st = new StringTokenizer(text, "/");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            switch (col) {
                case 0: {
                    try {
                        if (!part.equals("*")) {
                            int month = Integer.parseInt(part);
                            if (month >= 1 && month <= 12) break;
                            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidMonth"), jTFDate);
                        }
                        isvalid = false;
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidMonth"), jTFDate);
                    }
                }
                case 1: {
                    if (part.equals("*")) {
                        isvalid = false;
                        break;
                    }
                    try {
                        int day = Integer.parseInt(part);
                        if (day < 1 || day > 31) {
                            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidDay"), jTFDate);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidDay"), jTFDate);
                    }
                }
                case 2: {
                    if (part.equals("*")) {
                        isvalid = false;
                        break;
                    }
                    try {
                        int year = Integer.parseInt(part);
                        if (year < 1000 || year > 9999) {
                            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidYear"), jTFDate);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidYear"), jTFDate);
                    }
                }
                default: {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidDateFormat"), jTFDate);
                }
            }
            ++col;
        }
        if (col < 3) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidDateFormat"), jTFDate);
        }
        if (text.endsWith("/")) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidDateFormat"), jTFDate);
        }
        return isvalid;
    }

    public static long parseTime(String time) throws ParseException {
        if (time.length() == 0) {
            return -1L;
        }
        return ((SimpleDateFormat)timeSsdf.get()).parse(time).getTime();
    }

    public static String formatTime(long time) {
        if (time == -1L) {
            return "";
        }
        return UIUtilities.formatDate(time, (Format)timeSsdf.get());
    }

    public static long parseSSEPDateTimeWithTimeZone(long date, long time, TimeZone timeZone) {
        long dateTime = 0L;
        TimeZone parseTimeZone = timeZone;
        try {
            if (parseTimeZone == null) {
                parseTimeZone = Utility.getLocalTimeZone();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            dateFormat.setTimeZone(parseTimeZone);
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            timeFormat.setTimeZone(parseTimeZone);
            Date d = new Date(date);
            String dateString = dateFormat.format(d);
            d = new Date(time);
            String timeString = timeFormat.format(d);
            String dateStr = dateString + " " + timeString;
            SimpleDateFormat dateFormatWithTimeZone = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            dateFormatWithTimeZone.setTimeZone(parseTimeZone);
            d = dateFormatWithTimeZone.parse(dateStr);
            dateTime = d.getTime();
        }
        catch (Exception e) {
            dateTime = date + time;
        }
        return dateTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateTime(JTextField jTFTime) throws GUICheckException {
        boolean HOUR = false;
        boolean MINUTE = true;
        String text = jTFTime.getText().trim();
        if (text.length() == 0) {
            return true;
        }
        boolean isvalid = true;
        int col = 0;
        StringTokenizer st = new StringTokenizer(text, ":");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            switch (col) {
                case 0: {
                    try {
                        if (!part.equals("*")) {
                            int hour = Integer.parseInt(part);
                            if (hour >= 0 && hour <= 23) break;
                            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidHour"), jTFTime);
                        }
                        isvalid = false;
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidHour"), jTFTime);
                    }
                }
                case 1: {
                    if (part.equals("*")) {
                        isvalid = false;
                        break;
                    }
                    try {
                        int minute = Integer.parseInt(part);
                        if (minute < 0 || minute > 59) {
                            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidMinute"), jTFTime);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidMinute"), jTFTime);
                    }
                }
                default: {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidTimeFormat"), jTFTime);
                }
            }
            ++col;
        }
        if (col < 2) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidTimeFormat"), jTFTime);
        }
        if (text.endsWith("/")) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIUtility.error.InvalidTimeFormat"), jTFTime);
        }
        return isvalid;
    }

    public static String getDate(String dateAndTime) {
        int index = dateAndTime.indexOf(" ");
        if (index == -1) {
            return dateAndTime;
        }
        return dateAndTime.substring(0, index);
    }

    public static String getTime(String dateAndTime) {
        int index = dateAndTime.indexOf(" ");
        if (index == -1) {
            return "";
        }
        return dateAndTime.substring(index + 1);
    }

    public static HiPredefinedType[] getAvailableAVTypes(String platform) {
        HiPredefinedType[] avTypes = HIUtility.getDownloadedTypes(HiPredefinedReqName.ENFORCE_AV, platform);
        if (avTypes == null) {
            avTypes = platform.equalsIgnoreCase("Mac") ? PredefinedType.getMacAvTypes() : PredefinedType.getAvTypes();
        }
        return avTypes;
    }

    public static HiPredefinedType[] getAvailableASWTypes(String platform) {
        HiPredefinedType[] aswTypes = HIUtility.getDownloadedTypes(HiPredefinedReqName.ENFORCE_ASW, platform);
        if (aswTypes == null) {
            aswTypes = PredefinedType.getAswTypes();
        }
        return aswTypes;
    }

    public static HiPredefinedType[] getAvailableFWTypes(String platform) {
        HiPredefinedType[] fwTypes = HIUtility.getDownloadedTypes(HiPredefinedReqName.ENFORCE_FW, platform);
        if (fwTypes == null) {
            fwTypes = platform.equalsIgnoreCase("Mac") ? PredefinedType.getMacFwTypes() : PredefinedType.getFwTypes();
        }
        return fwTypes;
    }

    public static ServicePackNumberDocument createServicePackNumberDocument(JTextField owner, int maxChars) {
        return new ServicePackNumberDocument(owner, maxChars);
    }

    private static HiPredefinedType[] getDownloadedTypes(Integer hiType, String platform) {
        try {
            HostIntegrityTemplateLibraryPool templatePool = HostIntegrityTemplateLibraryPool.getHiReqTemplateLibraryPool();
            if (templatePool != null && templatePool.getHiTemplateLibraryObj(platform) != null) {
                return templatePool.getHiTemplateLibraryObj(platform).getPredefinedType(hiType);
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return null;
    }

    private static class ServicePackNumberDocument
    extends RestrictedPlainDocument {
        private static final long serialVersionUID = -2132452421542720843L;
        private JTextField owner;

        public ServicePackNumberDocument(JTextField owner, int maxChars) {
            super(maxChars);
            this.owner = owner;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.length() == 0) {
                super.insertString(offs, str, a);
                return;
            }
            char c = str.charAt(0);
            if (offs == 0 && !Character.isDigit(c) || offs > 0 && (c != 'a' && c != 'A' || !this.owner.getText().equals("6")) || c == '0') {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

