/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.configobject.schema.HiReqTemplate;
import com.sygate.scm.common.configobject.schema.HiReqTemplateGroup;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryObject;
import com.sygate.scm.console.ui.policy.explorer.common.TitledPolicyExplorerPanel;
import com.sygate.scm.console.ui.policy.hi.HIOnlineHandler;
import com.sygate.scm.console.ui.policy.hi.HIOnlineUpdatingDlg;
import com.sygate.scm.console.ui.policy.hi.HITemplateDescDlg;
import com.sygate.scm.console.ui.policy.hi.HiTemplateHTMLPane;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HITemplateDetailsPanel
extends TitledPolicyExplorerPanel {
    private static final long serialVersionUID = -5796309235785156799L;
    private JLabel totaltemplatesLbl = new JLabel();
    private int index = 0;

    public HITemplateDetailsPanel(int index, HostIntegrityTemplateLibraryObject newLibObj) {
        this.index = index;
        this.initialize(newLibObj);
    }

    private void initialize(HostIntegrityTemplateLibraryObject newLibObj) {
        HiReqTemplateLibrary existingLib = (HiReqTemplateLibrary)newLibObj.getSchemaObj();
        HiReqTemplateGroup group = existingLib.getOptHiReqTemplateGroupArray().getHiReqTemplateGroup(this.index - 2);
        this.setMainComponent(this.getPanel(group), HIOnlineHandler.getInstance().getI18nContent(group.getName()));
    }

    private JPanel getPanel(HiReqTemplateGroup group) {
        DescriptionTextArea desc = new DescriptionTextArea(HIOnlineHandler.getInstance().getI18nContent(group.getOptDescription()));
        desc.setMinimumSize(new Dimension(1, 1));
        this.totaltemplatesLbl.setFont(this.totaltemplatesLbl.getFont().deriveFont(1));
        this.totaltemplatesLbl.setText(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDetailsPanel.label.TotalTemplatesSelected"), HIOnlineHandler.getInstance().getGlobalCount()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)desc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.totaltemplatesLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JSeparator(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.getScrollPane(group), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JScrollPane getScrollPane(HiReqTemplateGroup group) {
        ArrayList<JPanel> list = new ArrayList<JPanel>();
        for (HiReqTemplate hireqtemplate : group.getHiReqTemplate()) {
            list.add(new IndReqPanel(hireqtemplate, this.index));
        }
        JScrollPane pane = new JScrollPane();
        this.updateScrollPane(pane, list);
        return pane;
    }

    public void setTemplateLabel(String text) {
        this.totaltemplatesLbl.setText(text);
    }

    static class IndReqPanel
    extends JPanel {
        private static final long serialVersionUID = 5508792347715379258L;
        private static final int DESCRIPTION_COUNT = 235;
        private JLabel jLSelected = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDetailsPanel.label.ItemSelected"));
        private JButton jBAdd = new JButton(UIText.get(0));
        private JButton jBRemove = new JButton(UIText.get(4354));
        private String seeMore = "<a href=\"http://aaa.html#DETAILS\">" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDetailsPanel.html.SeeMoreDetails") + "</a>";
        private HiReqTemplate hireqtemplate;
        private HIOnlineHandler hiOnlineHandler;
        private int index = 0;

        public IndReqPanel(HiReqTemplate hireqtemplate, int parentindex) {
            this.hireqtemplate = hireqtemplate;
            this.index = parentindex;
            this.initialize();
            this.selectedTypeChanged(false);
        }

        private void initialize() {
            this.hiOnlineHandler = HIOnlineHandler.getInstance();
            this.setLayout(new BorderLayout());
            this.add((Component)this.getInnerPanel(), "Center");
        }

        private JPanel getInnerPanel() {
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            df.setTimeZone(Utility.getLocalTimeZone());
            String dateStr = df.format(new Date(this.hireqtemplate.getLastModifiedTime()));
            JLabel modTime = new JLabel(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDetailsPanel.label.LastModTime"), dateStr));
            modTime.setFont(modTime.getFont().deriveFont(1));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            panel.add((Component)modTime, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
            panel.add((Component)this.getDescriptionPane(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            return panel;
        }

        private JPanel getTitlePanel() {
            JLabel title = new JLabel(HIOnlineHandler.getInstance().getI18nContent(this.hireqtemplate.getName()));
            title.setFont(UIFontUtilities.TITLE_FONT);
            JPanel panel = new JPanel(new FlowLayout(3));
            panel.add(title);
            panel.add(new JLabel(this.getImageIcon()));
            return panel;
        }

        private JEditorPane getDescriptionPane() {
            HiTemplateHTMLPane pane = new HiTemplateHTMLPane("text/html", this.getDescription());
            pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    try {
                        String url;
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = e.getURL().getRef()) != null && "DETAILS".equals(url)) {
                            HITemplateDescDlg dlg = new HITemplateDescDlg(hireqtemplate);
                            dlg.setVisible(true);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDetailsPanel.title.ConsoleError"), 0);
                        Manager.getFrame().showLoginPanel();
                    }
                }
            });
            return pane;
        }

        private Box getButtonPanel() {
            this.jLSelected.setFont(this.jLSelected.getFont().deriveFont(1));
            this.jBAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    hiOnlineHandler.add(Integer.toString(index - 2), hireqtemplate.getId());
                    this.selectedTypeChanged(true);
                }
            });
            this.jBRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    hiOnlineHandler.remove(Integer.toString(index - 2), hireqtemplate.getId());
                    this.selectedTypeChanged(false);
                }
            });
            UIUtilities.fitJComponent(new JButton[]{this.jBAdd, this.jBRemove});
            Box panel = Box.createHorizontalBox();
            panel.add(Box.createHorizontalGlue());
            panel.add(this.jLSelected);
            panel.add(Box.createHorizontalStrut(3));
            panel.add(this.jBAdd);
            panel.add(Box.createHorizontalStrut(3));
            panel.add(this.jBRemove);
            return panel;
        }

        private void selectedTypeChanged(boolean isSelected) {
            this.jBAdd.setEnabled(!isSelected);
            this.jBRemove.setEnabled(isSelected);
            this.jLSelected.setVisible(isSelected);
            this.hiOnlineHandler.setDescText(this.index, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDetailsPanel.label.TotalTemplatesSelected"), this.hiOnlineHandler.getGlobalCount()));
            HIOnlineUpdatingDlg dlg = this.hiOnlineHandler.getParentDlg();
            if (dlg != null) {
                dlg.resetOKButton(this.hiOnlineHandler.getGlobalCount() > 0);
            }
        }

        private String getDescription() {
            Object description = HIOnlineHandler.getInstance().getI18nContent(this.hireqtemplate.getOptDescription());
            if (description == null || ((String)description).length() == 0) {
                return null;
            }
            if (((String)description).length() > 235) {
                description = ((String)description).substring(0, 235) + "..." + this.seeMore;
            }
            return HTMLUtilities.HTML_DOCUMENT_BEGIN + (String)description + "</BODY></HTML>";
        }

        private ImageIcon getImageIcon() {
            Integer flagvalue = this.hireqtemplate.getOptAccessFlag();
            if (flagvalue == null) {
                flagvalue = HiReqTemplate.NORMAL;
            }
            ImageIcon imageIcon = null;
            imageIcon = flagvalue.intValue() == HiReqTemplate.NEW.intValue() ? HIOnlineHandler.flagImageNew : (flagvalue.intValue() == HiReqTemplate.CHANGED.intValue() ? HIOnlineHandler.flagImageChanged : HIOnlineHandler.flagImageNormal);
            return imageIcon;
        }
    }
}

