/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.schema.HiReqTemplate;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.hi.HIOnlineHandler;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HITemplateDescDlg
extends DialogBase {
    private static final long serialVersionUID = -1394167210390258237L;

    public HITemplateDescDlg(HiReqTemplate hireqtemplate) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDescDlg.title.title"), true);
        this.initialize(hireqtemplate);
    }

    @Override
    protected boolean isOkButtonShown() {
        return false;
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    @Override
    protected String getCancelButtonText() {
        return UIText.get(519);
    }

    private void initialize(HiReqTemplate hireqtemplate) {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getMainPanel(hireqtemplate), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getMainPanel(HiReqTemplate hireqtemplate) {
        JLabel name = new JLabel(HIOnlineHandler.getInstance().getI18nContent(hireqtemplate.getName()));
        name.setFont(UIFontUtilities.TITLE_FONT);
        DateFormat formatter = DateFormat.getDateTimeInstance(1, 1);
        formatter.setTimeZone(Utility.getLocalTimeZone());
        String dateTime = formatter.format(new Date(hireqtemplate.getLastModifiedTime()));
        JLabel modTime = new JLabel(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HITemplateDescDlg.label.LastModified"), dateTime));
        modTime.setFont(UIFontUtilities.SUBTITLE_FONT);
        DescriptionTextArea description = new DescriptionTextArea(HIOnlineHandler.getInstance().getI18nContent(hireqtemplate.getOptDescription()));
        description.setColumns(50);
        description.setRows(8);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)name, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)modTime, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(description), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        return panel;
    }
}

