/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.HiRequirement;
import com.sygate.scm.common.configobject.schema.HostIntegrityTrigger;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AbstractHIRequirementObject;
import com.sygate.scm.console.logicobject.HiRequirementGroupObject;
import com.sygate.scm.console.logicobject.HiRequirementObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.ConsoleOptions;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.hi.AddRequirementDlg;
import com.sygate.scm.console.ui.policy.hi.customized.CustomRequirementDlg;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedRequirementDlg;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedType;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.xml.sax.SAXException;

public class HIRequirementPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final int IMPORT_EXPORT_MENU = 0;
    private static final int POPUP_OR_EDIT_MENU = 1;
    private static final String HI_CHECKING_PANEL_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.HICheckingPanel");
    private static final String[] TABLE_TITLE = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.ExpandOrCollapse"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.Name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.Enable")};
    private static final float[] COL_SIZE_RATE = new float[]{0.1f, 0.8f, 0.1f};
    private final ConsoleOptions consoleOption = ConsoleOptions.getInstance();
    private HostIntegrityObject hiObj;
    private JRadioButton jRBNever;
    private JRadioButton jRBAlways;
    private JRadioButton jEBEnforce;
    private JRadioButton jRBSystem;
    private JTable jTRequirement;
    private Action add;
    private Action delete;
    private Action edit;
    private Action up;
    private Action down;
    private Action copy;
    private Action paste;
    private Action importAction;
    private Action export;
    private CustomTableModel requirementModel;
    private JPopupMenu impExpPopup;
    private JPopupMenu delExpMenu;
    private boolean libDownloaded;
    private boolean isReadonly;
    private HiRequirementGroupObject windowsGroup;
    private HiRequirementGroupObject macGroup;

    public HIRequirementPanel() {
        this.initializeAction();
        this.initialize();
    }

    public void save() {
        Integer tType = HostIntegrityTrigger.BY_ENFORCER;
        if (this.jRBNever.isSelected()) {
            tType = HostIntegrityTrigger.ALWAYS_OFF;
        } else if (this.jRBAlways.isSelected()) {
            tType = HostIntegrityTrigger.ALWAYS_ON;
        } else if (this.jRBSystem.isSelected()) {
            tType = HostIntegrityTrigger.BY_SEM_SERVER;
        }
        this.hiObj.setHostIntegrityTriggerType(tType);
        this.consoleOption.setHIReqTableShowStatus(this.hiObj.getId(), this.windowsGroup.isFolded(), this.macGroup.isFolded());
    }

    private void updateTemplate(Hashtable<String, ConfigObject> newRules, String clientTypeStr) {
        ArrayList<String> nameList = new ArrayList<String>();
        List<HiRequirementObject> reqObjs = null;
        if ("Mac".equalsIgnoreCase(clientTypeStr)) {
            reqObjs = this.macGroup.getHiRequirementObjectsInGroup();
        } else if ("Windows".equalsIgnoreCase(clientTypeStr)) {
            reqObjs = this.windowsGroup.getHiRequirementObjectsInGroup();
        }
        if (reqObjs != null) {
            for (HiRequirementObject reqObj : reqObjs) {
                nameList.add(reqObj.getName());
            }
        }
        ArrayList<HiRequirementObject> newAddedReqList = new ArrayList<HiRequirementObject>();
        for (Map.Entry<String, ConfigObject> entry : newRules.entrySet()) {
            String name = entry.getKey();
            HiRequirement hiReq = (HiRequirement)entry.getValue();
            HiRequirementObject newReq = new HiRequirementObject(hiReq);
            if (!this.hiObj.checkRequirementName(name, new HiRequirementObject((ConfigObject)this.hiObj.getSchemaObj()))) {
                String newName = PolicyHandler.adjustName(name, nameList, 256);
                newReq.setName(newName);
            }
            newReq.setOsTypeString(clientTypeStr);
            newAddedReqList.add(newReq);
            this.hiObj.addRequirement(newReq);
        }
        this.addNewRequirementObjectsToGroup(newAddedReqList, clientTypeStr);
        this.updateReqMode();
    }

    public void showPopupOrEdit(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getSelectedRows(true, e);
            this.showImpExpPopupMenu(e);
        }
        if (e.getClickCount() == 2) {
            this.editRequirment();
        }
    }

    protected void editRequirment() {
        try {
            boolean inRequirement = true;
            int index = this.jTRequirement.getSelectedRow();
            HiRequirementObject reqObj = null;
            if (index != -1) {
                reqObj = (HiRequirementObject)this.requirementModel.getRow(index);
            }
            if (reqObj != null) {
                HiRequirementObject newObj = reqObj.getClone();
                if (newObj.isCustomRequirement()) {
                    CustomRequirementDlg dlg = new CustomRequirementDlg(this.isReadonly);
                    dlg.setObject(newObj, this.hiObj);
                    dlg.setVisible(true);
                    if (dlg.isOk()) {
                        this.hiObj.replaceRequirement(reqObj, newObj);
                        this.hiObj.setPhysicalFileObject(newObj.getPhysicalFileObject());
                        if (inRequirement) {
                            this.requirementModel.setRow(index, newObj);
                        }
                    }
                } else {
                    PredefinedRequirementDlg dlg = new PredefinedRequirementDlg(newObj, this.hiObj, this.isReadonly);
                    if (dlg.isOk()) {
                        this.hiObj.replaceRequirement(reqObj, newObj);
                        if (inRequirement) {
                            this.requirementModel.setRow(index, newObj);
                        }
                    }
                }
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    protected void deleteRequirmentForMultipleSelection() {
        int result = UIUtilities.confirmYesNoOptionDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.ConfirmDeleteReq"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.DeleteRequirement"));
        if (result == 0) {
            int[] select = this.jTRequirement.getSelectedRows();
            for (int i = 0; i < select.length; ++i) {
                select[i] = select[i] - i;
                HiRequirementObject curRequire = (HiRequirementObject)this.requirementModel.getRow(select[i]);
                this.hiObj.deleteRequirement(curRequire);
                this.requirementModel.removeRow(select[i]);
                String clientType = curRequire.getClientTypeString();
                if ("Mac".equalsIgnoreCase(clientType)) {
                    this.macGroup.removeRequirementObject(curRequire);
                    continue;
                }
                this.windowsGroup.removeRequirementObject(curRequire);
            }
            this.updateReqMode();
        }
    }

    private void initializeAction() {
        this.add = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.addRequirement();
                HIRequirementPanel.this.actionStatusChanged();
            }
        };
        this.delete = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.deleteRequirmentForMultipleSelection();
                HIRequirementPanel.this.actionStatusChanged();
            }
        };
        this.edit = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.editRequirment();
                HIRequirementPanel.this.actionStatusChanged();
            }
        };
        this.up = new AbstractAction(UIText.get(3075)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.moveUpRequirment();
                HIRequirementPanel.this.actionStatusChanged();
            }
        };
        this.down = new AbstractAction(UIText.get(3074)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.moveDownRequirment();
                HIRequirementPanel.this.actionStatusChanged();
            }
        };
        this.copy = new AbstractAction(UIText.get(520)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.copyRequirment();
                HIRequirementPanel.this.actionStatusChanged();
            }
        };
        this.paste = new AbstractAction(UIText.get(3840)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.pasteRequirment();
                HIRequirementPanel.this.actionStatusChanged();
            }
        };
        this.importAction = new AbstractAction(UIText.get(2049)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.importRule();
            }
        };
        this.export = new AbstractAction(UIText.get(1031)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRequirementPanel.this.exportHiRuleForMultipleSelection();
            }
        };
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        this.add((Component)this.getHICheckingPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getRequirementPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(20, 0, 0, 0), 0, 0));
    }

    private void updateGroupObjects() {
        if (this.windowsGroup == null) {
            this.windowsGroup = new HiRequirementGroupObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.windowsReqGroupName"), HiRequirementGroupObject.GROUP_TYPES.GROUP_TYPE_WINDOWS, this.hiObj);
        }
        if (this.macGroup == null) {
            this.macGroup = new HiRequirementGroupObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.macReqGroupName"), HiRequirementGroupObject.GROUP_TYPES.GROUP_TYPE_MAC, this.hiObj);
        }
        this.windowsGroup.setHostIntegrityObject(this.hiObj);
        this.macGroup.setHostIntegrityObject(this.hiObj);
        String policyId = this.hiObj.getId();
        this.windowsGroup.setFolded(this.consoleOption.isHIReqTableWindowsFolded(policyId));
        this.macGroup.setFolded(this.consoleOption.isHIReqTableMacFolded(policyId));
    }

    private JPanel getHICheckingPanel() {
        this.jRBNever = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.radio.NeverDoHIChecking"));
        this.jRBAlways = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.radio.AlwaysDoHIChecking"));
        this.jEBEnforce = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.radio.HICheckingThruGatewayOrDHCPEnforcer"));
        this.jRBSystem = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.radio.HICheckingWhenConnectedToPolicyMgr"));
        ButtonGroup refreshGroup = new ButtonGroup();
        refreshGroup.add(this.jRBNever);
        refreshGroup.add(this.jRBAlways);
        refreshGroup.add(this.jEBEnforce);
        refreshGroup.add(this.jRBSystem);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add(this.jRBAlways);
        LicenseObject lObj = LicenseObject.getInstance();
        if (lObj.isALLProduct() || lObj.isSNACOnlyProduct()) {
            panel.add(this.jEBEnforce);
        }
        panel.add(this.jRBSystem);
        panel.add(this.jRBNever);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)new AvTemplatePane(HI_CHECKING_PANEL_TITLE, null, false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getRequirementPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.label.Requirements"), null, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)this.getRequireScrollPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 20, 0, 20), 0, 0));
        return panel;
    }

    private JScrollPane getRequireScrollPane() {
        this.initRequirementTable();
        JScrollPane pane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)pane, (JTable)this.jTRequirement);
        pane.getViewport().addMouseListener(new MouseListener(this.jTRequirement, 0));
        return pane;
    }

    private void initRequirementTable() {
        this.requirementModel = new CustomTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                if (this.getValueAt(row, col) == null) {
                    return false;
                }
                return col == 0 || col == 2 ? true : super.isCellEditable(row, col);
            }

            @Override
            public void setDataVector(Vector<TableRow> rows) {
                super.setDataVector(rows);
                this.fireTableRowsInserted(rows.size(), rows.size());
            }
        };
        this.requirementModel.setColumnNames(TABLE_TITLE);
        this.jTRequirement = new StripesTable(this.requirementModel){
            private static final long serialVersionUID = 1L;

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
                if (e.getSource() instanceof HIRequirementObjEditor) {
                    HIRequirementPanel.this.jTRequirement.clearSelection();
                    HIRequirementPanel.this.requirementModel.setDataVector((Vector)Cast.cast(HIRequirementPanel.this.getTableData()));
                }
            }

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                AbstractHIRequirementObject obj = (AbstractHIRequirementObject)HIRequirementPanel.this.requirementModel.getRow(rowIndex);
                if (obj.isGroupObject()) {
                    return;
                }
                super.changeSelection(rowIndex, columnIndex, toggle, false);
            }
        };
        this.jTRequirement.setShowGrid(false);
        Dimension size = this.jTRequirement.getPreferredScrollableViewportSize();
        this.jTRequirement.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.jTRequirement.getRowHeight() + this.jTRequirement.getRowMargin()) * 2 * 5));
        UIUtilities.setTableColumnWidth(this.jTRequirement, COL_SIZE_RATE, this.jTRequirement.getPreferredScrollableViewportSize().width);
        HIRequirementObjEditor bc = new HIRequirementObjEditor();
        this.jTRequirement.getColumnModel().getColumn(0).setCellRenderer(bc);
        this.jTRequirement.getColumnModel().getColumn(0).setCellEditor(bc);
        this.jTRequirement.getColumnModel().getColumn(0).setMaxWidth(35);
        this.jTRequirement.getColumnModel().getColumn(0).setResizable(false);
        this.jTRequirement.getColumnModel().getColumn(1).setCellRenderer(new RequirementNameRenderer());
        CheckBoxEditor ce = new CheckBoxEditor(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.requirementEnable"));
        this.jTRequirement.getColumnModel().getColumn(2).setCellRenderer(ce);
        this.jTRequirement.getColumnModel().getColumn(2).setCellEditor(ce);
        this.jTRequirement.addMouseListener(new MouseListener(this.jTRequirement, 1));
        this.jTRequirement.setSelectionMode(2);
        this.jTRequirement.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HIRequirementPanel.this.actionStatusChanged();
            }
        });
    }

    private JPanel getButtonPanel() {
        JButton bAdd = new JButton(this.add);
        JButton bEdit = new JButton(this.edit);
        JButton bDelete = new JButton(this.delete);
        JButton bUp = new JButton(this.up);
        JButton bDown = new JButton(this.down);
        JPanel panel = new JPanel();
        UIUtilities.layoutButtonPanel(panel, new JButton[]{bAdd, bEdit, bDelete, bUp, bDown}, 0, 4, true, false, 10);
        return panel;
    }

    private void copyRequirment() {
        int selectR = this.jTRequirement.getSelectedRow();
        HiRequirementObject curRequire = null;
        if (selectR != -1) {
            curRequire = (HiRequirementObject)this.requirementModel.getRow(selectR);
        }
        PolicyHandler.copyObject(curRequire);
    }

    private void pasteRequirment() {
        ArrayList<String> reqNames = new ArrayList<String>();
        String name = "";
        try {
            if (PolicyHandler.hasCopiedObject(HiRequirementObject.class)) {
                HiRequirementObject newObj = (HiRequirementObject)PolicyHandler.getPastedObject();
                List<HiRequirementObject> requirements = null;
                String clientType = newObj.getClientTypeString();
                if ("Mac".equals(clientType)) {
                    requirements = this.hiObj.getAllMacReqWithoutCancelableTable();
                } else if ("Windows".equalsIgnoreCase(clientType)) {
                    requirements = this.hiObj.getAllWindowsReqWithoutCancelableTable();
                }
                if (requirements == null) {
                    return;
                }
                for (HiRequirementObject reqObj : requirements) {
                    reqNames.add(reqObj.getName());
                }
                name = PolicyHandler.adjustName(newObj.getName().toString(), reqNames, 256);
                newObj.setName(name);
                this.hiObj.addRequirement(newObj);
                String clientTypeStr = newObj.getClientTypeString();
                this.addNewRequirementObjectToGroup(newObj, clientTypeStr);
                this.updateReqMode();
                this.selectNewAddedHiRequirement(clientType, 1);
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void moveDownRequirment() {
        int select = this.jTRequirement.getSelectedRow();
        if (select != -1) {
            HiRequirementObject curRequire = (HiRequirementObject)this.requirementModel.getRow(select);
            int size = this.requirementModel.getRowCount();
            if (select != size - 1) {
                this.requirementModel.removeRow(select);
                this.requirementModel.insertRow(select + 1, curRequire);
                this.jTRequirement.setRowSelectionInterval(select + 1, select + 1);
                this.hiObj.moveDownRequirement(curRequire);
            }
        }
    }

    private void moveUpRequirment() {
        int select = this.jTRequirement.getSelectedRow();
        if (select != -1) {
            HiRequirementObject curRequire = (HiRequirementObject)this.requirementModel.getRow(select);
            if (select > 0) {
                this.requirementModel.removeRow(select);
                this.requirementModel.insertRow(select - 1, curRequire);
                this.jTRequirement.setRowSelectionInterval(select - 1, select - 1);
                this.hiObj.moveUpRequirement(curRequire);
            }
        }
    }

    private void addRequirement() {
        try {
            HiRequirementObject newReq = new HiRequirementObject((ConfigObject)this.hiObj.getSchemaObj(), PredefinedType.getTYPESByIndex(0));
            newReq.setName(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.NewReq"));
            AddRequirementDlg dlg = new AddRequirementDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.NewReq"), true);
            dlg.setObject(newReq, this.hiObj);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                int newAddedNum = 0;
                String clientTypeStr = dlg.getAddRequiementClientType();
                if (dlg.isAddFromTemplate()) {
                    newAddedNum = dlg.getAddRuleSet().size();
                    this.updateTemplate(dlg.getAddRuleSet(), dlg.getAddRequiementClientType());
                } else {
                    newAddedNum = 1;
                    this.hiObj.addRequirement(newReq);
                    this.hiObj.setPhysicalFileObject(newReq.getPhysicalFileObject());
                    this.addNewRequirementObjectToGroup(newReq, clientTypeStr);
                    this.updateReqMode();
                }
                this.selectNewAddedHiRequirement(clientTypeStr, newAddedNum);
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void addNewRequirementObjectToGroup(HiRequirementObject reqObj, String clientTypeStr) {
        if (reqObj != null) {
            if (!StringUtilities.isEmpty((String)clientTypeStr) && "Mac".equalsIgnoreCase(clientTypeStr)) {
                this.macGroup.addHIRequirementObject(reqObj);
                this.macGroup.setFolded(false);
            } else if (!StringUtilities.isEmpty((String)clientTypeStr) && "Windows".equalsIgnoreCase(clientTypeStr)) {
                this.windowsGroup.addHIRequirementObject(reqObj);
                this.windowsGroup.setFolded(false);
            }
        }
    }

    private void addNewRequirementObjectsToGroup(List<HiRequirementObject> reqObjs, String clientTypeStr) {
        if (reqObjs != null && reqObjs.size() > 0) {
            if (!StringUtilities.isEmpty((String)clientTypeStr) && "Mac".equalsIgnoreCase(clientTypeStr)) {
                for (HiRequirementObject reqObj : reqObjs) {
                    this.macGroup.addHIRequirementObject(reqObj);
                }
                this.macGroup.setFolded(false);
            } else if (!StringUtilities.isEmpty((String)clientTypeStr) && "Windows".equalsIgnoreCase(clientTypeStr)) {
                for (HiRequirementObject reqObj : reqObjs) {
                    this.windowsGroup.addHIRequirementObject(reqObj);
                }
                this.windowsGroup.setFolded(false);
            }
        }
    }

    private void selectNewAddedHiRequirement(String clientTypeStr, int addedNum) {
        int firstSelectIndex = 0;
        int lastSelectIndex = 0;
        if (!StringUtilities.isEmpty((String)clientTypeStr) && "Mac".equalsIgnoreCase(clientTypeStr)) {
            lastSelectIndex = this.windowsGroup.getActualHIRequirementCount() + 1 + this.macGroup.getActualHIRequirementCount();
            firstSelectIndex = lastSelectIndex - addedNum + 1;
        } else {
            lastSelectIndex = this.windowsGroup.getActualHIRequirementCount();
            firstSelectIndex = lastSelectIndex - addedNum + 1;
        }
        this.jTRequirement.setRowSelectionInterval(firstSelectIndex, lastSelectIndex);
    }

    private int[] getSelectedRows(boolean forceSelection, MouseEvent e) {
        int[] rows = null;
        boolean ctrlKeyPressed = (e.getModifiers() & 2) != 0;
        Point clickedPoint = e.getPoint();
        rows = this.jTRequirement.getSelectedRows();
        if (forceSelection && clickedPoint != null) {
            int row = this.jTRequirement.rowAtPoint(clickedPoint);
            int column = this.jTRequirement.columnAtPoint(clickedPoint);
            if (row != -1 && this.outOfRange(row, rows) && !ctrlKeyPressed && e.isPopupTrigger()) {
                rows = new int[]{row};
                this.jTRequirement.changeSelection(rows[0], 0, false, false);
            }
            if ((rows = this.jTRequirement.getSelectedRows()).length == 1) {
                this.jTRequirement.changeSelection(rows[0], column, false, false);
            }
        }
        return rows;
    }

    private boolean outOfRange(int row, int[] rows) {
        boolean outOfRange = true;
        if (rows != null) {
            for (int i = 0; i < rows.length; ++i) {
                if (row != rows[i]) continue;
                outOfRange = false;
                break;
            }
        }
        return outOfRange;
    }

    private void actionStatusChanged() {
        int selCount = this.jTRequirement.getSelectedRowCount();
        boolean canMoveUp = true;
        boolean canMovedown = true;
        this.delete.setEnabled(selCount > 0);
        this.edit.setEnabled(selCount == 1);
        if (selCount == 1) {
            int selIndex = this.jTRequirement.getSelectedRow();
            HiRequirementObject curObj = (HiRequirementObject)this.requirementModel.getRow(selIndex);
            if (selIndex > 0) {
                AbstractHIRequirementObject prevObj = (AbstractHIRequirementObject)this.requirementModel.getRow(selIndex - 1);
                canMoveUp = prevObj.isGroupObject() ? false : curObj.getClientTypeString().equalsIgnoreCase(((HiRequirementObject)prevObj).getClientTypeString());
            }
            if (selIndex < this.jTRequirement.getRowCount() - 1) {
                AbstractHIRequirementObject nextObj = (AbstractHIRequirementObject)this.requirementModel.getRow(selIndex + 1);
                canMovedown = nextObj.isGroupObject() ? false : curObj.getClientTypeString().equalsIgnoreCase(((HiRequirementObject)nextObj).getClientTypeString());
            } else if (selIndex == this.jTRequirement.getRowCount() - 1) {
                canMovedown = false;
            }
        }
        this.up.setEnabled(selCount == 1 && canMoveUp);
        this.down.setEnabled(selCount == 1 && canMovedown);
        this.export.setEnabled(selCount > 0);
        this.copy.setEnabled(selCount > 0);
        this.paste.setEnabled(PolicyHandler.hasCopiedObject(HiRequirementObject.class) && !this.isReadonly);
    }

    private void updatePanel() {
        Integer doHi = this.hiObj.getHostIntegrityTriggerType();
        if (doHi.equals(HostIntegrityTrigger.ALWAYS_OFF)) {
            this.jRBNever.setSelected(true);
        } else if (doHi.equals(HostIntegrityTrigger.ALWAYS_ON)) {
            this.jRBAlways.setSelected(true);
        } else if (doHi.equals(HostIntegrityTrigger.BY_ENFORCER)) {
            this.jEBEnforce.setSelected(true);
        } else {
            this.jRBSystem.setSelected(true);
        }
        this.updateReqMode();
    }

    private void updateReqMode() {
        this.requirementModel.removeAll();
        this.requirementModel.setDataVector((Vector)Cast.cast(this.getTableData()));
    }

    private Vector<AbstractHIRequirementObject> getTableData() {
        List<HiRequirementObject> macReqs;
        List<HiRequirementObject> winReqs;
        Vector<AbstractHIRequirementObject> result = new Vector<AbstractHIRequirementObject>();
        if (this.windowsGroup.getActualHIRequirementCount() > 0) {
            result.add(this.windowsGroup);
        }
        if ((winReqs = this.windowsGroup.getHiRequirementObjectsInGroup()) != null && winReqs.size() > 0) {
            result.addAll(winReqs);
        }
        if (this.macGroup.getActualHIRequirementCount() > 0) {
            result.add(this.macGroup);
        }
        if ((macReqs = this.macGroup.getHiRequirementObjectsInGroup()) != null && macReqs.size() > 0) {
            result.addAll(macReqs);
        }
        return result;
    }

    private void showImpExpPopupMenu(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        if (this.jTRequirement.getSelectedRowCount() > 1) {
            if (this.delExpMenu == null) {
                this.delExpMenu = new JPopupMenu();
                this.delExpMenu.add(this.delete);
                this.delExpMenu.add(this.export);
            }
            this.delExpMenu.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (this.impExpPopup == null) {
            this.impExpPopup = new JPopupMenu();
            this.impExpPopup.add(this.add);
            this.impExpPopup.add(this.edit);
            this.impExpPopup.addSeparator();
            this.impExpPopup.add(this.importAction);
            this.impExpPopup.add(this.export);
            this.impExpPopup.addSeparator();
            this.impExpPopup.add(this.up);
            this.impExpPopup.add(this.down);
            this.impExpPopup.addSeparator();
            this.impExpPopup.add(this.delete);
            this.impExpPopup.add(this.copy);
            this.impExpPopup.add(this.paste);
        }
        this.impExpPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    private void importRule() {
        String errMsg = null;
        try {
            HiHostIntegrityPolicy policy = (HiHostIntegrityPolicy)PolicyHandler.importPolicy();
            if (policy == null) {
                return;
            }
            ArrayList<String> reqNames = new ArrayList<String>();
            List<HiRequirement> list = this.hiObj.getAllRequirmentWithoutCancelableTable();
            for (HiRequirement req : list) {
                reqNames.add(req.getName());
            }
            boolean hasRule = false;
            HostIntegrityObject obj = new HostIntegrityObject((TopLevelObject)policy);
            list = obj.getAllRequirmentWithoutCancelableTable();
            ArrayList<HiRequirementObject> addWinHiReqObjList = new ArrayList<HiRequirementObject>();
            ArrayList<HiRequirementObject> addMacHiReqObjList = new ArrayList<HiRequirementObject>();
            for (HiRequirement req : list) {
                if (reqNames != null && reqNames.size() != 0) {
                    String newName = PolicyHandler.validatePolicyName(req.getName(), reqNames, 256);
                    if (newName == null || newName.length() == 0) {
                        return;
                    }
                    req.setName(newName);
                }
                HashMap<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
                WashIDHandler washer = new WashIDHandler();
                ConfigObject newObj = washer.duplicateObject((ConfigObject)req, newObjSet);
                HiRequirementObject newHiReq = new HiRequirementObject((HiRequirement)newObj);
                this.hiObj.addRequirement(newHiReq);
                String clientType = newHiReq.getClientTypeString();
                if ("Mac".equalsIgnoreCase(clientType)) {
                    addMacHiReqObjList.add(newHiReq);
                } else if ("Windows".equalsIgnoreCase(clientType)) {
                    addWinHiReqObjList.add(newHiReq);
                }
                hasRule = true;
            }
            if (!hasRule) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.error.NoCompRulesInImportFile"));
            } else {
                this.addNewRequirementObjectsToGroup(addWinHiReqObjList, "Windows");
                this.addNewRequirementObjectsToGroup(addMacHiReqObjList, "Mac");
                this.updateReqMode();
            }
        }
        catch (SAXException se) {
            errMsg = se.getMessage();
        }
        catch (IOException ioe) {
            errMsg = ioe.getMessage();
        }
        catch (ValidationException ve) {
            errMsg = ve.getMessage();
        }
        catch (Exception e) {
            errMsg = e.getMessage();
            LoggerUtilities.logException((Throwable)e);
        }
        if (errMsg != null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.error.ImportingCompRule"), errMsg), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.ImportingCompRule"), 0);
        }
    }

    private void exportHiRuleForMultipleSelection() {
        try {
            TopLevelObject policy = this.hiObj.getCopyOfPolicyObject();
            HostIntegrityObject obj = new HostIntegrityObject(policy);
            List<HiRequirement> allReq = obj.getAllRequirmentWithoutCancelableTable();
            for (HiRequirement req : allReq) {
                obj.deleteRequirement(req);
            }
            int[] rows = this.jTRequirement.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                obj.addRequirement((HiRequirementObject)this.requirementModel.getRow(rows[i]));
            }
            if (obj.getName() == null || obj.getName().trim().length() == 0) {
                String policyName = this.validatePolicyName("");
                if (policyName == null) {
                    return;
                }
                obj.setName(policyName);
            }
            PolicyHandler.exportPolicy((ConfigObject)policy, obj.getName());
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private String validatePolicyName(String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            String input = JOptionPane.showInputDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.EnterPolicyName"), "");
            return this.validatePolicyName(input);
        }
        return name;
    }

    public void setObject(HostIntegrityObject hiObj) {
        this.hiObj = hiObj;
        this.updateGroupObjects();
        this.updatePanel();
        this.actionStatusChanged();
    }

    public void setReadOnly() {
        this.isReadonly = true;
        this.jRBNever.setEnabled(false);
        this.jRBAlways.setEnabled(false);
        this.jEBEnforce.setEnabled(false);
        this.jRBSystem.setEnabled(false);
        this.add.setEnabled(false);
        this.importAction.setEnabled(false);
    }

    public boolean getDownloaded() {
        return this.libDownloaded;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hi_requirements";
    }

    private static class CheckBoxEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 4343399799243130349L;
        private JCheckBox renderChk;
        private JCheckBox editChk;

        public CheckBoxEditor(String chkName) {
            this.renderChk = new JCheckBox(chkName);
            this.renderChk.setHorizontalAlignment(2);
            this.renderChk.setOpaque(false);
            this.editChk = new JCheckBox(chkName);
            this.editChk.setHorizontalAlignment(2);
            this.editChk.setOpaque(false);
            this.editChk.addActionListener(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.renderChk.setSelected((Boolean)value);
                return this.renderChk;
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null && value instanceof Boolean) {
                Boolean isFolded = (Boolean)value;
                this.editChk.setSelected(isFolded);
                return this.editChk;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editChk.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }
    }

    private static class RequirementNameRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font groupFont;
        private Font hiObjFont;

        public RequirementNameRenderer() {
            this.setOpaque(true);
            this.intialFont();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            if (value != null && value instanceof AbstractHIRequirementObject.RequirementNameItem) {
                AbstractHIRequirementObject.RequirementNameItem item = (AbstractHIRequirementObject.RequirementNameItem)value;
                if (item.isUsedForGroup()) {
                    this.setFont(this.groupFont);
                } else {
                    this.setFont(this.hiObjFont);
                }
                this.setText(item.getRequirementName());
                return this;
            }
            return null;
        }

        private void intialFont() {
            this.hiObjFont = this.getFont();
            this.groupFont = UIFontUtilities.BOLD_FONT;
        }
    }

    private static class HIRequirementObjEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JCheckBox renderChk = new JCheckBox();
        private JCheckBox editChk;

        public HIRequirementObjEditor() {
            this.renderChk.setIcon(CustomLookAndFeel.UP_ARROW_ICON);
            this.renderChk.setSelectedIcon(CustomLookAndFeel.DOWN_ARROW_ICON);
            this.renderChk.setHorizontalAlignment(0);
            this.renderChk.setOpaque(false);
            this.editChk = new JCheckBox();
            this.editChk.setIcon(CustomLookAndFeel.UP_ARROW_ICON);
            this.editChk.setSelectedIcon(CustomLookAndFeel.DOWN_ARROW_ICON);
            this.editChk.setHorizontalAlignment(0);
            this.editChk.setOpaque(false);
            this.editChk.addActionListener(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && value instanceof Boolean) {
                this.renderChk.setSelected((Boolean)value);
                return this.renderChk;
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null && value instanceof Boolean) {
                Boolean isFolded = (Boolean)value;
                this.editChk.setSelected(isFolded);
                return this.editChk;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editChk.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private JTable source;
        private int type;

        public MouseListener(JTable source, int type) {
            this.source = source;
            this.type = type;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showMenu(this.type, e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showMenu(this.type, e);
        }

        private void showMenu(int type, MouseEvent e) {
            if (this.source.isEnabled()) {
                switch (type) {
                    case 0: {
                        HIRequirementPanel.this.showImpExpPopupMenu(e);
                        break;
                    }
                    case 1: {
                        HIRequirementPanel.this.showPopupOrEdit(e);
                        break;
                    }
                }
            }
        }
    }
}

