/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.schema.HiReqTemplateGroup;
import com.sygate.scm.common.configobject.schema.HiReqTemplateGroupArray;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryObject;
import com.sygate.scm.console.ui.policy.explorer.common.TitledPolicyExplorerPanel;
import com.sygate.scm.console.ui.policy.hi.HIOnlineHandler;
import com.sygate.scm.console.ui.policy.hi.HIOnlineUpdatingDlg;
import com.sygate.scm.console.ui.policy.hi.HiTemplateHTMLPane;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.HyperlinkPane;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HIReqTemplatesPanel
extends TitledPolicyExplorerPanel {
    private static final long serialVersionUID = 3026710772803240449L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.hi.hi");
    private JPanel jPTemplate;
    private JLabel jLTotal = new JLabel(MSG_RES.getString("HIReqTemplatesPanel.label.ZeroTemplatesSel"));
    private JScrollPane scrollpane = new JScrollPane();
    private ArrayList<JPanel> indpanel = new ArrayList();
    private boolean isSet;

    public HIReqTemplatesPanel() {
        this.initialize();
    }

    public void setObject(HostIntegrityTemplateLibraryObject newLibObj) {
        if (!this.isSet) {
            Vector hireq;
            HiReqTemplateLibrary existingLib = (HiReqTemplateLibrary)newLibObj.getSchemaObj();
            HiReqTemplateGroupArray hiArray = existingLib.getOptHiReqTemplateGroupArray();
            if (hiArray != null && (hireq = hiArray.getHiReqTemplateGroup()) != null) {
                Iterator it = hireq.iterator();
                int i = 0;
                while (it.hasNext()) {
                    HiReqTemplateGroup hireqtemplategroup = (HiReqTemplateGroup)it.next();
                    IndReqTemplatePanel p = new IndReqTemplatePanel(i, hireqtemplategroup);
                    this.indpanel.add(p);
                    ++i;
                }
                this.updateScrollPane(this.scrollpane, this.indpanel);
            }
            this.isSet = true;
            this.updateUI();
        }
    }

    public void setTotalLabel(String text) {
        this.jLTotal.setText(text);
    }

    public void setIndTemplateText(int index, String text) {
        ((IndReqTemplatePanel)this.indpanel.get(index)).setTotalLabel(text);
    }

    private void initialize() {
        this.jPTemplate = this.createTemplatePanel();
        this.setMainComponent(this.jPTemplate, MSG_RES.getString("HIReqTemplatesPanel.title.HIRequirementTemplates"));
    }

    private JPanel createTemplatePanel() {
        DescriptionTextArea descArea = new DescriptionTextArea(MSG_RES.getString("HIReqTemplatesPanel.SelectTemplatesDesc"));
        descArea.setMinimumSize(new Dimension(1, descArea.getMinimumSize().height));
        this.jLTotal.setFont(this.jLTotal.getFont().deriveFont(1));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.setOpaque(false);
        centerPanel.add((Component)this.jLTotal, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        centerPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        centerPanel.add((Component)this.scrollpane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)descArea, "North");
        panel.add((Component)centerPanel, "Center");
        return panel;
    }

    private static class IndReqTemplatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel jLTotal = new JLabel(MSG_RES.getString("HIReqTemplatesPanel.label.ZeroTemplatesSel"));
        private String templateLink = "<a href=\"http://aaa.html#DETAILS\">" + MSG_RES.getString("HIReqTemplatesPanel.html.SeeTemplates") + "</a>";
        private HiReqTemplateGroup hireqtemplate;
        private int index = 0;

        public IndReqTemplatePanel(int index, HiReqTemplateGroup hireqtemplate) {
            this.index = index;
            this.hireqtemplate = hireqtemplate;
            this.initialize();
        }

        public void setTotalLabel(String text) {
            this.jLTotal.setText(text);
        }

        private void initialize() {
            this.jLTotal.setFont(this.jLTotal.getFont().deriveFont(1));
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.add((Component)this.getTitleLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.jLTotal, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)((Object)new HiTemplateHTMLPane("text/html", this.getDescription())), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.getTemplateLinkPane(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 10, 5), 0, 0));
        }

        private JLabel getTitleLabel() {
            JLabel title = new JLabel(HIOnlineHandler.getInstance().getI18nContent(this.hireqtemplate.getName()));
            title.setFont(UIFontUtilities.TITLE_FONT);
            return title;
        }

        private JEditorPane getTemplateLinkPane() {
            String link = HTMLUtilities.HTML_DOCUMENT_BEGIN + this.templateLink + "</BODY></HTML>";
            HyperlinkPane pane = new HyperlinkPane();
            pane.setContentType("text/html");
            pane.setEditable(false);
            pane.setText(link);
            pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        HIOnlineUpdatingDlg parentdlg = HIOnlineHandler.getInstance().getParentDlg();
                        parentdlg.setTreeSelectedNode(index);
                    }
                }
            });
            return pane;
        }

        private String getDescription() {
            return HTMLUtilities.HTML_DOCUMENT_BEGIN + HIOnlineHandler.getInstance().getI18nContent(this.hireqtemplate.getOptDescription()) + "</BODY></HTML>";
        }
    }
}

