/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.HiReqTemplate;
import com.sygate.scm.common.configobject.schema.HiReqTemplateGroup;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.configobject.schema.HiRequirement;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.ContainerObject;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.hi.HIOnlineHandler;
import com.sygate.scm.console.ui.policy.hi.HIOnlineUpdatePanel;
import com.sygate.scm.console.ui.policy.hi.HIReqTemplatesPanel;
import com.sygate.scm.console.ui.policy.hi.HITemplateDetailsPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HIOnlineUpdatingDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final int VISIBLE_TREE_VIEW_COUNT = 20;
    private JTree jTTemplate = new JTree();
    private JPanel nodePanel = new JPanel(new BorderLayout());
    private HIOnlineUpdatePanel updatePanel;
    private HIReqTemplatesPanel templatePanel;
    private ArrayList<HITemplateDetailsPanel> detailPanels = new ArrayList(2);
    private HostIntegrityTemplateLibraryObject hiTemplateLibObj;
    private Hashtable<String, ConfigObject> addedRuleSet = new Hashtable();
    private Map<String, HiReqTemplate> hiReqTemplatesMap;

    public HIOnlineUpdatingDlg(HostIntegrityTemplateLibraryObject hiTemplateLibObj) {
        super(Manager.getFrame(), "", true, false);
        this.setTitle(this.getRes("title.HIOnlineUpdating"));
        this.hiReqTemplatesMap = this.getHiReqTemplates(hiTemplateLibObj);
        this.hiTemplateLibObj = hiTemplateLibObj;
        this.initialize();
        this.setSize(new Dimension(700, 600));
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public Hashtable<String, ConfigObject> getAddedRuleSet() {
        Hashtable tempAddedRuleSet = (Hashtable)(this.addedRuleSet == null ? null : this.addedRuleSet.clone());
        return tempAddedRuleSet;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected boolean isOkButtonActive() {
        return false;
    }

    @Override
    protected void commit() {
        Map<String, ArrayList<String>> importMap = HIOnlineHandler.getInstance().getImportList();
        for (ArrayList<String> list : importMap.values()) {
            for (int i = 0; i < list.size(); ++i) {
                HiReqTemplate reqTemp = this.hiReqTemplatesMap.get(list.get(i));
                HiRequirement hiReq = reqTemp.getHiRequirement();
                String name = HIOnlineHandler.getInstance().getI18nContent(hiReq.getName());
                hiReq.setName(name);
                try {
                    this.addedRuleSet.put(name, PolicyHandler.getCopyOfObj((ConfigObject)hiReq));
                    continue;
                }
                catch (ConsoleException e) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.getRes("title.Error"), 0);
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
    }

    protected void setTreeSelectedNode(int index) {
        TreeNode root = (TreeNode)this.jTTemplate.getModel().getRoot();
        TreeNode tempNode = root.getChildAt(1);
        TreePath path = new TreePath(((DefaultMutableTreeNode)tempNode.getChildAt(index)).getPath());
        this.jTTemplate.setSelectionPath(path);
    }

    private void initialize() {
        this.nodePanel.setBorder(BorderFactory.createEtchedBorder());
        this.updatePanel = new HIOnlineUpdatePanel();
        this.templatePanel = new HIReqTemplatesPanel();
        this.jBOk.setText(UIText.get(2048));
        HiReqTemplateLibrary hilib = (HiReqTemplateLibrary)this.hiTemplateLibObj.getSchemaObj();
        HIOnlineHandler.getInstance().setObject(hilib);
        HIOnlineHandler.getInstance().setPanel("0", this.updatePanel);
        HIOnlineHandler.getInstance().setPanel("1", this.templatePanel);
        this.getContentPane().add((Component)this.getMainPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.updateAllPanels(hilib);
    }

    private JComponent getMainPanel() {
        this.initTemplateTree();
        JScrollPane treePane = new JScrollPane(this.jTTemplate);
        treePane.setMinimumSize(treePane.getPreferredSize());
        JSplitPane pane = new JSplitPane(1, treePane, this.nodePanel);
        pane.setOneTouchExpandable(true);
        pane.setDividerLocation(treePane.getMinimumSize().width + 20);
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        return pane;
    }

    private void initTemplateTree() {
        this.jTTemplate.setShowsRootHandles(true);
        this.jTTemplate.setRootVisible(false);
        this.jTTemplate.putClientProperty("JTree.lineStyle", "Angled");
        this.jTTemplate.setCellRenderer(new TreeCellRenderer());
        this.jTTemplate.setVisibleRowCount(20);
        this.jTTemplate.setSelectionRow(0);
        this.jTTemplate.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                HIOnlineUpdatingDlg.this.treeSelectionChanged();
            }
        });
        UIUtilities.expandAllNodesInTree(this.jTTemplate);
    }

    private void treeSelectionChanged() {
        TreePath path = this.jTTemplate.getSelectionPath();
        if (path == null) {
            return;
        }
        this.nodePanel.removeAll();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        TreeItem treeItem = (TreeItem)node.getUserObject();
        int type = treeItem.getItemType();
        switch (type) {
            case 0: {
                this.nodePanel.add((Component)this.updatePanel, "Center");
                break;
            }
            case 1: {
                this.nodePanel.add((Component)this.templatePanel, "Center");
                break;
            }
            default: {
                this.nodePanel.add((Component)this.detailPanels.get(type - 2), "Center");
            }
        }
        this.nodePanel.updateUI();
    }

    private void updateAllPanels(HiReqTemplateLibrary hilib) {
        Vector hiReq = null;
        if (hilib.getOptHiReqTemplateGroupArray() != null) {
            hiReq = hilib.getOptHiReqTemplateGroupArray().getHiReqTemplateGroup();
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ContainerObject(1, this.getRes("Templates")));
        root.add(new DefaultMutableTreeNode(new ContainerObject(0, this.getRes("WhatsNew"))));
        root.add(node);
        int index = 0;
        if (hiReq != null) {
            int i = 0;
            while (i < hiReq.size()) {
                HiReqTemplateGroup tempGroup = (HiReqTemplateGroup)hiReq.get(i);
                node.add(new DefaultMutableTreeNode(new ContainerObject(index + 2, HIOnlineHandler.getInstance().getI18nContent(tempGroup.getName()))));
                ++i;
                ++index;
            }
        }
        this.jTTemplate.setModel(new DefaultTreeModel(root));
        TreePath path = new TreePath(((DefaultMutableTreeNode)root.getFirstChild()).getPath());
        this.jTTemplate.setSelectionPath(path);
        UIUtilities.expandAllNodesInTree(this.jTTemplate);
        this.updatePanel.setObject(this.hiTemplateLibObj);
        this.templatePanel.setObject(this.hiTemplateLibObj);
        index = 2;
        if (hiReq != null) {
            int i = 0;
            while (i < hiReq.size()) {
                HITemplateDetailsPanel detailPanel = new HITemplateDetailsPanel(index, this.hiTemplateLibObj);
                this.detailPanels.add(detailPanel);
                HIOnlineHandler.getInstance().setPanel(Integer.toString(index), detailPanel);
                ++i;
                ++index;
            }
        }
        HIOnlineHandler.getInstance().setParentDlg(this);
    }

    private Map<String, HiReqTemplate> getHiReqTemplates(HostIntegrityTemplateLibraryObject templateLibObj) {
        HashMap<String, HiReqTemplate> map = new HashMap<String, HiReqTemplate>();
        HiReqTemplateLibrary templateLib = (HiReqTemplateLibrary)templateLibObj.getSchemaObj();
        if (templateLib.getOptHiReqTemplateGroupArray() != null) {
            Vector templateGroups = templateLib.getOptHiReqTemplateGroupArray().getHiReqTemplateGroup();
            for (int i = 0; i < templateGroups.size(); ++i) {
                HiReqTemplateGroup templateGroup = (HiReqTemplateGroup)templateGroups.get(i);
                Vector templates = templateGroup.getHiReqTemplate();
                for (int j = 0; j < templates.size(); ++j) {
                    HiReqTemplate template = (HiReqTemplate)templates.get(j);
                    map.put(template.getId(), template);
                }
            }
        }
        return map;
    }

    private String getRes(String tag) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIOnlineUpdatingDlg." + tag);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        TreePath path = this.jTTemplate.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        TreeItem treeItem = (TreeItem)node.getUserObject();
        int type = treeItem.getItemType();
        switch (type) {
            case 0: {
                return "sesm_policies_dialog_hi_requirements_templates_online_updating_whats_new";
            }
            case 1: {
                return "sesm_policies_dialog_hi_requirements_templates_online_updating_templates";
            }
        }
        return "sesm_policies_dialog_hi_requirements_templates_online_updating_individual_template";
    }

    public boolean isCancel() {
        return !this.isOk;
    }

    private static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -7669514840470457632L;

        private TreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setFont(this.getFont().deriveFont(1));
            Object item = ((DefaultMutableTreeNode)value).getUserObject();
            if (item == null || !(item instanceof TreeItem)) {
                return this;
            }
            switch (((TreeItem)item).getItemType()) {
                case 0: {
                    this.setIcon(ConsoleMain.globalIcon);
                    break;
                }
                case 1: {
                    this.setIcon(ConsoleMain.HIPolGroupIcon);
                    break;
                }
                default: {
                    this.setIcon(ConsoleMain.HIIcon);
                }
            }
            return this;
        }
    }
}

