/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.schema.HiLibOverview;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryObject;
import com.sygate.scm.console.ui.policy.explorer.common.TitledPolicyExplorerPanel;
import com.sygate.scm.console.ui.policy.hi.HIOnlineHandler;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class HIOnlineUpdatePanel
extends TitledPolicyExplorerPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.hi.hi");
    private OnlineUpdatePanel main;
    private boolean isSet;

    public HIOnlineUpdatePanel() {
        this.initialize();
    }

    public void setObject(HostIntegrityTemplateLibraryObject newLibObj) {
        if (!this.isSet) {
            HiReqTemplateLibrary existingLib = (HiReqTemplateLibrary)newLibObj.getSchemaObj();
            HiLibOverview hiliboverview = existingLib.getOptHiLibOverview();
            this.main.update(newLibObj.getVersion(), newLibObj.getLastModifiedTime(), hiliboverview.getContent());
            this.isSet = true;
        }
    }

    private void initialize() {
        this.main = new OnlineUpdatePanel();
        this.setMainComponent(this.main, MSG_RES.getString("HIOnlineUpdatePanel.title.HIOnlineUpdating"));
    }

    static class OnlineUpdatePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.hi.hi");
        private JLabel jLVersion = new JLabel();
        private JLabel jLLastModTime = new JLabel();
        private DescriptionTextArea descArea = new DescriptionTextArea();

        public OnlineUpdatePanel() {
            this.initialize();
        }

        public void update(String version, long modTime, String desc) {
            this.jLVersion.setText(MessageFormat.format(MSG_RES.getString("HIOnlineUpdatePanel.VersionNo"), version));
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            df.setTimeZone(Utility.getLocalTimeZone());
            String dateStr = df.format(new Date(modTime));
            this.jLLastModTime.setText(MessageFormat.format(MSG_RES.getString("HIOnlineUpdatePanel.ModTime"), dateStr));
            this.descArea.setText(HIOnlineHandler.getInstance().getI18nContent(desc));
        }

        private void initialize() {
            this.descArea.setMinimumSize(new Dimension(1, this.descArea.getMinimumSize().height));
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.add((Component)this.jLVersion, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.jLLastModTime, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.descArea, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        }
    }
}

