/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.configobject.schema.I18n;
import com.sygate.scm.common.configobject.schema.I18nCDATA;
import com.sygate.scm.common.configobject.schema.I18nString;
import com.sygate.scm.common.configobject.schema.I18nStrings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.policy.hi.HIOnlineUpdatingDlg;
import com.sygate.scm.console.ui.policy.hi.HIReqTemplatesPanel;
import com.sygate.scm.console.ui.policy.hi.HITemplateDetailsPanel;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;

public class HIOnlineHandler {
    public static final ImageIcon flagImageNew = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("template_new.gif")));
    public static final ImageIcon flagImageNormal = null;
    public static final ImageIcon flagImageChanged = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("template_update.gif")));
    private static HIOnlineHandler hiHandler;
    private Map<String, Object> hiOnlineMap = new HashMap<String, Object>();
    private Map<String, ArrayList<String>> hiOnlineList = new HashMap<String, ArrayList<String>>();
    private ArrayList<String> hisublist = new ArrayList();
    private Map<String, String> hiI18nMap = new HashMap<String, String>();
    private HIOnlineUpdatingDlg dlg;

    private HIOnlineHandler() {
    }

    public void add(String groupdid, String id) {
        this.hisublist = this.hiOnlineList.containsKey(groupdid) ? this.hiOnlineList.get(groupdid) : new ArrayList();
        this.hisublist.add(id);
        this.hiOnlineList.put(groupdid, this.hisublist);
    }

    public void remove(String groupdid, String id) {
        this.hisublist = this.hiOnlineList.get(groupdid);
        this.hisublist.remove(id);
        this.hiOnlineList.put(groupdid, this.hisublist);
    }

    public void removeimportData() {
        this.hiOnlineList = new HashMap<String, ArrayList<String>>();
    }

    private void createI18nMap(HiReqTemplateLibrary hilib) {
        this.hiI18nMap.clear();
        I18n i18n = hilib.getOptI18n();
        if (i18n != null) {
            this.createI18nMap("en", i18n);
            Locale locale = Locale.getDefault();
            boolean isFound = this.createI18nMap(locale.getLanguage() + "_" + locale.getCountry(), i18n);
            if (!isFound) {
                this.createI18nMap(locale.getLanguage(), i18n);
            }
        }
    }

    private boolean createI18nMap(String language, I18n i18n) {
        for (int i = 0; i < i18n.getI18nStringsCount(); ++i) {
            int j;
            I18nStrings i18nStrings = i18n.getI18nStrings(i);
            if (!i18nStrings.getLocale().equals(language)) continue;
            for (j = 0; j < i18nStrings.getI18nStringCount(); ++j) {
                I18nString str = i18nStrings.getI18nString(j);
                this.hiI18nMap.put(str.getTag(), str.getOptContent());
            }
            for (j = 0; j < i18nStrings.getI18nCDATACount(); ++j) {
                I18nCDATA cdata = i18nStrings.getI18nCDATA(j);
                this.hiI18nMap.put(cdata.getTag(), cdata.getOptContent());
            }
            return true;
        }
        return false;
    }

    public static HIOnlineHandler getInstance() {
        if (null == hiHandler) {
            hiHandler = new HIOnlineHandler();
        }
        return hiHandler;
    }

    public Map<String, ArrayList<String>> getImportList() {
        return this.hiOnlineList;
    }

    public int getGlobalCount() {
        int total = 0;
        Collection<ArrayList<String>> c = this.hiOnlineList.values();
        Iterator<ArrayList<String>> it = c.iterator();
        while (it.hasNext()) {
            total += it.next().size();
        }
        return total;
    }

    public int getIndCount(int index) {
        if (this.hiOnlineList.containsKey(Integer.toString(index))) {
            ArrayList<String> sublist = this.hiOnlineList.get(Integer.toString(index));
            return sublist.size();
        }
        return 0;
    }

    public void setPanel(String id, Object panel) {
        this.hiOnlineMap.put(id, panel);
    }

    public Object getPanel(String id) {
        return this.hiOnlineMap.get(id);
    }

    public void setParentDlg(HIOnlineUpdatingDlg dlg) {
        this.dlg = dlg;
    }

    public HIOnlineUpdatingDlg getParentDlg() {
        return this.dlg;
    }

    public void setObject(HiReqTemplateLibrary hilib) {
        this.createI18nMap(hilib);
    }

    public String getI18nContent(String tag) {
        if (this.hiI18nMap.containsKey(tag)) {
            String i18n = this.hiI18nMap.get(tag);
            i18n = i18n == null ? "" : i18n;
            return i18n.trim();
        }
        return tag;
    }

    public void setDescText(int index, String text) {
        for (int i = 2; i < this.hiOnlineMap.size(); ++i) {
            ((HITemplateDetailsPanel)this.getPanel(Integer.toString(i))).setTemplateLabel(text);
        }
        ((HIReqTemplatesPanel)this.getPanel("1")).setTotalLabel(text);
        text = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIOnlineHandler.TotalNumSelected"), this.getIndCount(index - 2));
        ((HIReqTemplatesPanel)this.getPanel("1")).setIndTemplateText(index - 2, text);
    }
}

