/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.dialog.AdditionalTextDialog;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HIAdvancePanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String HI = "com.sygate.scm.console.ui.policy.hi.hi";
    private static final String[] TIME_UNIT_FULL = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Minutes"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Hours"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Days")};
    private static final long[] TIME_UNIT_FULL_VALUE = new long[]{60L, 3600L, 86400L};
    private static final String[] TIME_UNIT_LAST = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Minutes"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Hours"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Days")};
    private static final long[] TIME_VALUE_LAST = new long[]{60L, 3600L, 86400L};
    private static final long[] TIME_LIMIT_LAST = new long[]{Utility.getMaxMinute((boolean)true), Utility.getMaxHour((boolean)true), Utility.getMaxDay((boolean)true)};
    private static final String[] TIME_INTERVAL = new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Minutes.2"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Minutes.5"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Minutes.10"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Minutes.15"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Minutes.30"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Hours.1"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Hours.2"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Hours.4"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Hours.8"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Days.1"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Days.2"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Days.4"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Weeks.1"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Weeks.2"), MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.combo.Weeks.4")};
    private static final long[] TIME_INTERVAL_VALUE = new long[]{120L, 300L, 600L, 900L, 1800L, 3600L, 7200L, 14400L, 28800L, 86400L, 172800L, 345600L, 604800L, 1209600L, 2419200L};
    private JTextField jTFrequency = new JTextField(15);
    private JComboBox<String> jCmbFrequency = new JComboBox<String>(TIME_UNIT_FULL);
    private JTextField jTFCancel = new JTextField(12);
    private JTextField jTFMaintain = new JTextField(15);
    private JComboBox<String> jCmbMaintain = new JComboBox<String>(TIME_UNIT_LAST);
    private JCheckBox jChkContinue = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.checkbox.checkContinue"));
    private JComboBox<String> jCmbMinTime = new JComboBox<String>(TIME_INTERVAL);
    private JComboBox<String> jCmbMaxTime = new JComboBox<String>(TIME_INTERVAL);
    private JCheckBox jChkPopup = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.checkbox.DisplayPopupIfHICheckFails"));
    private JCheckBox jChkPass = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.checkbox.DisplayPopupIfHIPassesAfterFail"));
    private JCheckBox jChkVerbose = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.checkbox.VerboseHILogging"));
    private JCheckBox userLogonCheckbox = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.hi.hi", "HIAdvancePanel.checkbox.UserLogon"));
    private JButton jBRestorationText = new JButton(UIText.get(4616));
    private JButton jBFailText = new JButton(UIText.get(4616));
    private JButton jBPassText = new JButton(UIText.get(4616));
    private HostIntegrityObject hiObj;
    private String appPromptString;

    public HIAdvancePanel() {
        this.initialize();
        this.timeUnitChanged();
    }

    public void setObject(HostIntegrityObject hiObj) {
        this.hiObj = hiObj;
        this.updatePanel();
    }

    public boolean isValidate() {
        try {
            int idxMax;
            String strFrequency = this.jTFrequency.getText().trim();
            if (strFrequency.length() == 0) {
                throw new GUICheckException(MSGRES.getString(HI, "HIAdvancePanel.error.EmptyHICheckingFreq"), this.jTFrequency);
            }
            long frequency = Long.parseLong(strFrequency);
            if (frequency == 0L) {
                throw new GUICheckException(MSGRES.getString(HI, "HIAdvancePanel.error.MinFreqHIChecking"), this.jTFrequency);
            }
            String strKeepResult = this.jTFMaintain.getText().trim();
            if (strKeepResult.length() == 0) {
                throw new GUICheckException(MSGRES.getString(HI, "HIAdvancePanel.error.EmptyKeepResults"), this.jTFMaintain);
            }
            long keepResult = Long.parseLong(strKeepResult);
            if ((keepResult *= TIME_VALUE_LAST[this.jCmbMaintain.getSelectedIndex()]) < (frequency *= TIME_UNIT_FULL_VALUE[this.jCmbFrequency.getSelectedIndex()])) {
                throw new GUICheckException(MSGRES.getString(HI, "HIAdvancePanel.error.KeepCheckResultsTooShort"), this.jTFMaintain);
            }
            int idxMin = this.jCmbMinTime.getSelectedIndex();
            if (idxMin >= (idxMax = this.jCmbMaxTime.getSelectedIndex())) {
                throw new GUICheckException(MSGRES.getString(HI, "HIAdvancePanel.error.MaxSmallerThanMinTime"), this.jCmbMaxTime);
            }
            String strCancel = this.jTFCancel.getText().trim();
            if (strCancel.length() > 0 && Integer.parseInt(strCancel) < 1) {
                throw new GUICheckException(MSGRES.getString(HI, "HIAdvancePanel.error.CancelTimeMin"), this.jTFCancel);
            }
            return true;
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(HI, "HIAdvancePanel.title.Error"), 0);
            ex.getErrorComponent().requestFocusInWindow();
            return false;
        }
    }

    public void save() {
        String strCancel = this.jTFCancel.getText().trim();
        this.hiObj.setCancelTime(strCancel.length() > 0 ? Long.parseLong(strCancel) : -1L);
        int frequency = Integer.parseInt(this.jTFrequency.getText().trim());
        int idxMin = this.jCmbMinTime.getSelectedIndex();
        int idxMax = this.jCmbMaxTime.getSelectedIndex();
        this.hiObj.setFrequency((long)frequency * TIME_UNIT_FULL_VALUE[this.jCmbFrequency.getSelectedIndex()]);
        this.hiObj.setEnableSnooze(true);
        this.hiObj.setMinimumSnoozeTime(TIME_INTERVAL_VALUE[idxMin]);
        this.hiObj.setMaximumSnoozeTime(TIME_INTERVAL_VALUE[idxMax]);
        String strLast = this.jTFMaintain.getText().trim();
        if (strLast.length() > 0) {
            this.hiObj.setHistoryTime(Long.parseLong(strLast) * TIME_VALUE_LAST[this.jCmbMaintain.getSelectedIndex()]);
        } else {
            this.hiObj.setHistoryTime(0L);
        }
        this.hiObj.setContinue(this.jChkContinue.isSelected());
        this.hiObj.setVerbose(this.jChkVerbose.isSelected());
        this.hiObj.setEnableFailPopup(this.jChkPopup.isSelected());
        this.hiObj.setEnableSuccessPopup(this.jChkPass.isSelected());
        this.hiObj.setUserLogonRequired(this.userLogonCheckbox.isSelected());
    }

    public void setReadOnly() {
        this.jTFrequency.setEnabled(false);
        this.jCmbFrequency.setEnabled(false);
        this.jCmbMinTime.setEnabled(false);
        this.jCmbMaxTime.setEnabled(false);
        this.jTFCancel.setEnabled(false);
        this.jTFMaintain.setEnabled(false);
        this.jCmbMaintain.setEnabled(false);
        this.jChkContinue.setEnabled(false);
        this.jChkVerbose.setEnabled(false);
        this.jChkPopup.setEnabled(false);
        this.jChkPass.setEnabled(false);
        this.userLogonCheckbox.setEnabled(false);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        panel.add((Component)this.getCheckOptionPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.getRestorationOptionPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.getDisplayOptionPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCheckOptionPanel() {
        this.jTFrequency.setDocument(new NumberPlainDocument(24855L));
        this.jTFrequency.setHorizontalAlignment(4);
        this.jTFMaintain.setHorizontalAlignment(4);
        this.jCmbMaintain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    HIAdvancePanel.this.timeUnitChanged();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString(HI, "HIAdvancePanel.label.HICheckingFreq")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFrequency, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(this.jCmbFrequency, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString(HI, "HIAdvancePanel.label.MaintainHIResultFor")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFMaintain, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add(this.jCmbMaintain, new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.jChkContinue, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 18, 0, new Insets(10, -5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString(HI, "HIAdvancePanel.label.checkContinueDesc")), new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 22, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(HI, "HIAdvancePanel.checkOption"), null, false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getRestorationOptionPanel() {
        this.jTFCancel.setDocument(new NumberPlainDocument());
        this.jTFCancel.setHorizontalAlignment(4);
        this.jBRestorationText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HIAdvancePanel.this.appPromptString = HIAdvancePanel.this.hiObj.getAdditionalText();
                RestrictedPlainDocument textDocument = new RestrictedPlainDocument(512);
                textDocument.setValidator("\n", false);
                AdditionalTextDialog dlg = new AdditionalTextDialog(MSGRES.getString(HIAdvancePanel.HI, "HIAdvancePanel.title.EnterAdditionalText"), HIAdvancePanel.this.appPromptString, textDocument);
                if (dlg.isOk()) {
                    HIAdvancePanel.this.hiObj.setAdditionalText(dlg.getAdditionalText());
                }
                dlg.dispose();
            }
        });
        Box timePanel = new Box(0);
        timePanel.add(new JLabel(MSGRES.getString(HI, "HIAdvancePanel.label.MinTime")));
        timePanel.add(Box.createHorizontalStrut(10));
        timePanel.add(this.jCmbMinTime);
        timePanel.add(Box.createHorizontalStrut(30));
        timePanel.add(new JLabel(MSGRES.getString(HI, "HIAdvancePanel.label.MaxTime")));
        timePanel.add(Box.createHorizontalStrut(10));
        timePanel.add(this.jCmbMaxTime);
        timePanel.add(Box.createHorizontalGlue());
        Box cancelPanel = new Box(0);
        cancelPanel.add(new JLabel(MSGRES.getString(HI, "HIAdvancePanel.label.OnlyAllowCancelHIRestore")));
        cancelPanel.add(Box.createHorizontalStrut(5));
        cancelPanel.add(this.jTFCancel);
        Box textPanel = new Box(0);
        textPanel.add(this.jBRestorationText);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString(HI, "HIAdvancePanel.label.allowCancelableRestore")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)timePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 25, 0, 0), 0, 0));
        panel.add((Component)cancelPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add((Component)textPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(HI, "HIAdvancePanel.cancelRestorationOption"), null, false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getDisplayOptionPanel() {
        this.jChkPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HIAdvancePanel.this.setPopupPanelStatus();
            }
        });
        this.jBFailText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String failString = HIAdvancePanel.this.hiObj.getFailExtraText();
                RestrictedPlainDocument textDocument = new RestrictedPlainDocument(512);
                textDocument.setValidator("\n", false);
                AdditionalTextDialog dlg = new AdditionalTextDialog(MSGRES.getString(HIAdvancePanel.HI, "HIAdvancePanel.title.EnterAdditionalText"), failString, textDocument);
                if (dlg.isOk()) {
                    HIAdvancePanel.this.hiObj.setFailExtraText(dlg.getAdditionalText());
                }
                dlg.dispose();
            }
        });
        this.jChkPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HIAdvancePanel.this.setPopupPanelStatus();
            }
        });
        this.jBPassText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String passString = HIAdvancePanel.this.hiObj.getSuccessExtraText();
                RestrictedPlainDocument textDocument = new RestrictedPlainDocument(512);
                textDocument.setValidator("\n", false);
                AdditionalTextDialog dlg = new AdditionalTextDialog(MSGRES.getString(HIAdvancePanel.HI, "HIAdvancePanel.title.EnterAdditionalText"), passString, textDocument);
                if (dlg.isOk()) {
                    HIAdvancePanel.this.hiObj.setSuccessExtraText(dlg.getAdditionalText());
                }
                dlg.dispose();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add((Component)this.jChkVerbose, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jChkPopup, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBFailText, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 28, 0, 0), 0, 0));
        panel.add((Component)this.jChkPass, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBPassText, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 28, 0, 0), 0, 0));
        panel.add((Component)this.userLogonCheckbox, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.userLogonCheckbox.setVisible(false);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(HI, "HIAdvancePanel.displayOption"), null, false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private void updatePanel() {
        long frequency = this.hiObj.getFrequency();
        int index = PolicyHandler.getIndexOfValueFromList(frequency, TIME_UNIT_FULL_VALUE);
        this.jTFrequency.setText(String.valueOf(frequency / TIME_UNIT_FULL_VALUE[index]));
        this.jCmbFrequency.setSelectedIndex(index);
        long minTime = this.hiObj.getMinimumSnoozeTime();
        this.jCmbMinTime.setSelectedIndex(this.translateToIndex(minTime));
        long maxTime = this.hiObj.getMaximumSnoozeTime();
        this.jCmbMaxTime.setSelectedIndex(this.translateToIndex(maxTime));
        long cancelTime = this.hiObj.getCancelTime();
        if (cancelTime != -1L) {
            this.jTFCancel.setText(String.valueOf(cancelTime));
        }
        long historyTime = this.hiObj.getHistoryTime();
        index = PolicyHandler.getIndexOfValueFromList(historyTime, TIME_VALUE_LAST);
        this.jTFMaintain.setText(String.valueOf(historyTime / TIME_VALUE_LAST[index]));
        this.jCmbMaintain.setSelectedIndex(index);
        this.jChkContinue.setSelected(this.hiObj.getContinue());
        this.jChkVerbose.setSelected(this.hiObj.getIsVerbose());
        this.jChkPopup.setSelected(this.hiObj.getEnableFailPopup());
        this.jChkPass.setSelected(this.hiObj.getEnableSuccessPopup());
        this.userLogonCheckbox.setSelected(this.hiObj.getUserLogonRequired());
        this.setPopupPanelStatus();
    }

    private void setPopupPanelStatus() {
        this.jBFailText.setEnabled(this.jChkPopup.isSelected());
        this.jBPassText.setEnabled(this.jChkPass.isSelected());
    }

    private void timeUnitChanged() {
        String timeStr = this.jTFMaintain.getText().trim();
        long timeLimit = TIME_LIMIT_LAST[this.jCmbMaintain.getSelectedIndex()];
        this.jTFMaintain.setDocument(new NumberPlainDocument(timeLimit, true));
        long time = timeStr.length() == 0 ? 0L : Long.parseLong(timeStr);
        this.jTFMaintain.setText(time <= timeLimit ? timeStr : String.valueOf(timeLimit));
    }

    private int translateToIndex(long time) {
        int index;
        for (index = 0; index < TIME_INTERVAL_VALUE.length && TIME_INTERVAL_VALUE[index] < time; ++index) {
        }
        if (index == TIME_INTERVAL_VALUE.length) {
            return index - 1;
        }
        if (TIME_INTERVAL_VALUE[index] == time) {
            return index;
        }
        return index - 1;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hi_advance_settings";
    }
}

