/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiRequirementObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryObject;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryPool;
import com.sygate.scm.console.ui.policy.hi.HIOnlineHandler;
import com.sygate.scm.console.ui.policy.hi.HIOnlineUpdatingDlg;
import com.sygate.scm.console.ui.policy.hi.customized.CustomRequirementDlg;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedRequirementDlg;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedType;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddRequirementDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MRS = MessageResources.getInstance();
    private HiRequirementObject reqObj;
    private HostIntegrityObject hiObj;
    private JPanel textPanel = null;
    private JComboBox<HiPredefinedType> clientTypeCmbBox = null;
    private DefaultListModel<PredefinedType> listModel;
    private JList<PredefinedType> reqTypeList;
    private String addRequiementClientType;
    private boolean isAddFromTemplate;
    private Hashtable<String, ConfigObject> addRuleSet;
    String[] strArr = new String[]{this.getString("AddRequirementDlg.InfoCustomReq"), this.getString("AddRequirementDlg.InfoAVReq"), this.getString("AddRequirementDlg.InfoASReq"), this.getString("AddRequirementDlg.InfoFWReq"), this.getString("AddRequirementDlg.InfoPatchReq"), this.getString("AddRequirementDlg.InfoSPReq"), this.getString("AddRequirementDlg.InfoHITemplate")};

    public AddRequirementDlg(JFrame frame, String string, boolean b) {
        super(frame, string, b);
        this.initialize();
    }

    public AddRequirementDlg(JDialog owner, String string, boolean b) {
        super(Manager.getFrame(), string, b);
        this.initialize();
    }

    public AddRequirementDlg() {
        super(Manager.getFrame(), "", true);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public String getAddRequiementClientType() {
        return this.addRequiementClientType;
    }

    public boolean isAddFromTemplate() {
        return this.isAddFromTemplate;
    }

    public Hashtable<String, ConfigObject> getAddRuleSet() {
        Hashtable tempRuleSet = this.addRuleSet == null ? null : (Hashtable)this.addRuleSet.clone();
        return tempRuleSet;
    }

    private JPanel getJContentPane() {
        JPanel jContentPane = new JPanel();
        jContentPane.setLayout(new BorderLayout());
        jContentPane.add((Component)this.getJPanel(), "Center");
        jContentPane.add((Component)this.getButtonPanel(), "South");
        return jContentPane;
    }

    private JPanel getTopDescriptionPane() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        JLabel label = new JLabel(this.getString("AddRequirementDlg.Label.AddHIPolicy"));
        label.setFont(UIFontUtilities.BOLD_FONT);
        ret.add(label);
        DescriptionTextArea descArea = new DescriptionTextArea(this.getString("AddRequirementDlg.Label.AddHIPolicyDescription"), 50);
        ret.add(descArea);
        return ret;
    }

    private JPanel getJPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridheight = 1;
        cons.gridwidth = 4;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 2;
        cons.anchor = 17;
        cons.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)this.getTopDescriptionPane(), cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridheight = 1;
        cons.gridwidth = 2;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.insets = new Insets(10, 10, 0, 10);
        JLabel label = new JLabel();
        label.setText(this.getString("AddRequirementDlg.Label.OSType"));
        label.setHorizontalAlignment(2);
        jPanel.add((Component)label, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.gridheight = 1;
        cons.gridwidth = 2;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 2;
        cons.anchor = 17;
        cons.insets = new Insets(5, 10, 0, 10);
        jPanel.add(this.getClientTypeCmbBox(), cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.fill = 0;
        cons.anchor = 17;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(10, 10, 0, 10);
        label = new JLabel();
        label.setText(this.getString("AddRequirementDlg.label.ReqName"));
        label.setHorizontalAlignment(2);
        jPanel.add((Component)label, cons);
        cons.gridx = 0;
        cons.gridy = 4;
        cons.gridheight = 4;
        cons.gridwidth = 2;
        cons.fill = 2;
        cons.anchor = 17;
        cons.weightx = 0.6;
        cons.weighty = 0.0;
        cons.insets = new Insets(5, 10, 60, 10);
        JScrollPane ps = new JScrollPane(this.getReqTypeList());
        ps.setPreferredSize(new Dimension(200, 120));
        ps.setMinimumSize(new Dimension(200, 120));
        jPanel.add((Component)ps, cons);
        cons.gridx = 2;
        cons.gridy = 4;
        cons.gridheight = 4;
        cons.gridwidth = 2;
        cons.fill = 2;
        cons.anchor = 17;
        cons.weightx = 0.4;
        cons.weighty = 0.0;
        cons.insets = new Insets(5, 10, 0, 10);
        jPanel.add((Component)this.getRequirementTextPanel(), cons);
        cons.gridx = 0;
        cons.gridy = 8;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.weighty = 1.0;
        cons.insets = new Insets(10, 10, 20, 10);
        JPanel nullPanel = new JPanel();
        jPanel.add((Component)nullPanel, cons);
        return jPanel;
    }

    private JComboBox<HiPredefinedType> getClientTypeCmbBox() {
        if (this.clientTypeCmbBox == null) {
            this.clientTypeCmbBox = new JComboBox();
            this.clientTypeCmbBox.setModel(new DefaultComboBoxModel<HiPredefinedType>(PredefinedType.getHi14PlusOsTypes()));
            this.clientTypeCmbBox.setSelectedIndex(0);
            this.clientTypeCmbBox.setEnabled(true);
            this.clientTypeCmbBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddRequirementDlg.this.updateReqListModel(AddRequirementDlg.this.getClientTypeStr());
                }
            });
            Dimension d = this.clientTypeCmbBox.getPreferredSize();
            this.clientTypeCmbBox.setPreferredSize(new Dimension(200, d.height));
            this.clientTypeCmbBox.setMinimumSize(new Dimension(200, d.height));
        }
        return this.clientTypeCmbBox;
    }

    private void updateReqListModel(String clientTypeStr) {
        PredefinedType[] contents = null;
        this.listModel.removeAllElements();
        contents = "Mac".equalsIgnoreCase(clientTypeStr) ? PredefinedType.getLINUX_MAC_TYPES() : PredefinedType.getTYPES();
        for (int i = 0; i < contents.length; ++i) {
            this.listModel.addElement(contents[i]);
        }
        PredefinedType cusomType = new PredefinedType(this.getString("AddRequirementDlg.TypeCustomRequirement"), 0);
        PredefinedType templateType = new PredefinedType(this.getString("AddRequirementDlg.TypeTemplate"), 7);
        this.listModel.addElement(cusomType);
        this.listModel.addElement(templateType);
        this.reqTypeList.setModel(this.listModel);
        this.reqTypeList.setSelectedIndex(0);
    }

    private JList<PredefinedType> getReqTypeList() {
        if (this.reqTypeList == null) {
            this.listModel = new DefaultListModel();
            this.reqTypeList = new JList();
            this.reqTypeList.getSelectionModel().setSelectionMode(0);
            this.reqTypeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    AddRequirementDlg.this.typeListItemChanged();
                }
            });
            this.reqTypeList.setSize(500, 100);
            this.updateReqListModel(this.getClientTypeStr());
        }
        return this.reqTypeList;
    }

    private String getClientTypeStr() {
        HiPredefinedType clientType = (HiPredefinedType)this.clientTypeCmbBox.getSelectedItem();
        return clientType.getValue();
    }

    private JPanel getRequirementTextPanel() {
        if (this.textPanel == null) {
            this.textPanel = new JPanel();
            this.textPanel.setLayout(new CardLayout());
            this.textPanel.add((Component)new RequirementTextPanel(this.strArr[0]), this.getString("AddRequirementDlg.TypeCustomRequirement"));
            for (int i = 1; i < 6; ++i) {
                this.textPanel.add((Component)new RequirementTextPanel(this.strArr[i]), PredefinedType.getTYPESByIndex(i - 1).getName());
            }
            this.textPanel.add((Component)new RequirementTextPanel(this.strArr[6]), this.getString("AddRequirementDlg.TypeTemplate"));
        }
        return this.textPanel;
    }

    private void typeListItemChanged() {
        if (this.reqTypeList == null || this.textPanel == null) {
            return;
        }
        PredefinedType type = this.reqTypeList.getSelectedValue();
        if (type == null) {
            return;
        }
        CardLayout card = (CardLayout)this.textPanel.getLayout();
        card.show(this.textPanel, type.getName());
        this.setNameField();
    }

    private void setNameField() {
        PredefinedType selected = this.reqTypeList.getSelectedValue();
        if (7 == selected.getType()) {
            return;
        }
        String reqType = selected.toString();
        String reqName = this.getRequirementName(reqType);
        this.reqObj.setName(reqName);
    }

    private String getRequirementName(String reqType) {
        int count = 1;
        String name = reqType + " " + count;
        while (!this.hiObj.checkRequirementName(name, this.reqObj)) {
            name = reqType + " " + ++count;
        }
        return name;
    }

    public void setObject(HiRequirementObject newReq, HostIntegrityObject hiObj) {
        this.reqObj = newReq;
        this.hiObj = hiObj;
        this.updatePanel();
    }

    private void updatePanel() {
        if (this.reqObj.isCustomRequirement()) {
            this.reqTypeList.setSelectedIndex(this.listModel.getSize() - 1);
        } else {
            this.reqTypeList.setSelectedIndex(0);
            this.typeListItemChanged();
        }
    }

    @Override
    protected void commit() {
        try {
            PredefinedType selected = this.reqTypeList.getSelectedValue();
            int selectType = selected.getType();
            String clientTypeStr = this.getClientTypeStr();
            this.reqObj.setOsTypeString(clientTypeStr);
            switch (selectType) {
                case 0: {
                    CustomRequirementDlg dlg = new CustomRequirementDlg(Manager.getFrame());
                    if (!this.reqObj.isCustomRequirement()) {
                        this.reqObj.setCustomRequirement();
                    }
                    dlg.setObject(this.reqObj, this.hiObj);
                    dlg.setVisible(true);
                    this.isAddFromTemplate = false;
                    this.addRequiementClientType = clientTypeStr;
                    this.addRuleSet = null;
                    this.isOk = dlg.isOk();
                    break;
                }
                case 7: {
                    this.isAddFromTemplate = true;
                    this.addRequiementClientType = clientTypeStr;
                    this.addFromHiOnlineUpdating();
                    break;
                }
                default: {
                    this.reqObj.setPredefinedCallObj(selected);
                    PredefinedRequirementDlg dlg1 = new PredefinedRequirementDlg(this.reqObj, this.hiObj, false);
                    this.isAddFromTemplate = false;
                    this.addRequiementClientType = clientTypeStr;
                    this.addRuleSet = null;
                    this.isOk = dlg1.isOk();
                    break;
                }
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.getString("PredefinedRequirementDlg.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void addFromHiOnlineUpdating() {
        HostIntegrityTemplateLibraryObject templateLibObj = this.getExistingTemplate();
        if (templateLibObj == null) {
            MultiLineLabel multiL = new MultiLineLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.noExistingHiTemplateLib"));
            JOptionPane.showMessageDialog(Manager.getFrame(), multiL, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.hi", "HIRequirementPanel.title.Error"), 0);
            return;
        }
        HIOnlineUpdatingDlg dlg = new HIOnlineUpdatingDlg(templateLibObj);
        this.addRuleSet = dlg.getAddedRuleSet();
        this.isOk = dlg.isOk();
    }

    private HostIntegrityTemplateLibraryObject getExistingTemplate() {
        HIOnlineHandler.getInstance().removeimportData();
        try {
            HostIntegrityTemplateLibraryPool templatePool = HostIntegrityTemplateLibraryPool.getHiReqTemplateLibraryPool();
            return templatePool.getHiTemplateLibraryObj(this.getClientTypeStr());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_hi_requirements_add_new_requirement";
    }

    private String getString(String key) {
        return MRS.getString("com.sygate.scm.console.ui.policy.hi.hi", key);
    }

    private static class RequirementTextPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextArea jTextArea = null;
        private String displayString;

        public RequirementTextPanel(String str) {
            this.initialize();
            this.setDisplayString(str);
        }

        public void setDisplayString(String str) {
            this.displayString = str;
            this.jTextArea.setText(this.displayString);
        }

        private void initialize() {
            this.setLayout(new BorderLayout());
            if (this.jTextArea == null) {
                this.jTextArea = new JTextArea();
                this.jTextArea.setEditable(false);
                this.jTextArea.setOpaque(false);
                this.jTextArea.setLineWrap(true);
                this.jTextArea.setWrapStyleWord(true);
                this.setAlignmentX(0.0f);
                this.add((Component)this.jTextArea, "Center");
            }
            this.setPreferredSize(new Dimension(240, 180));
            this.setMinimumSize(new Dimension(240, 180));
        }
    }
}

