/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.renderer;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ActionObject;
import com.sygate.scm.console.ui.policy.firewall.renderer.ListObjectCellRenderer;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;

public class TrackingRenderer
extends ListObjectCellRenderer {
    public TrackingRenderer(FirewallRulePanel firewallRulePanel) {
        super(firewallRulePanel);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ArrayList<JLabel> listData = new ArrayList<JLabel>();
        ActionObject actionObject = (ActionObject)value;
        if (actionObject != null) {
            Boolean trafficLog = actionObject.getTrafficLog();
            Boolean packetLog = actionObject.getPacketLog();
            Boolean alert = actionObject.getSendEmail();
            LicenseObject licenseobject = LicenseObject.getInstance();
            if (licenseobject.isSBProduct()) {
                if (trafficLog != null && trafficLog.booleanValue()) {
                    listData.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.action.Yes"), 2));
                } else {
                    listData.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.action.No"), 2));
                }
            } else {
                if (trafficLog != null && trafficLog.booleanValue()) {
                    listData.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingRenderer.label.WriteTrafficLog"), ConsoleMain.trafficAllIcon, 2));
                }
                if (packetLog != null && packetLog.booleanValue()) {
                    listData.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingRenderer.label.WritePacketLog"), ConsoleMain.packetIcon, 2));
                }
            }
            if (alert != null && alert.booleanValue()) {
                JLabel sendEmail = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingRenderer.label.SendEmail"), ConsoleMain.emailAlertIcon, 2);
                listData.add(sendEmail);
            }
        }
        return super.getTableCellRendererComponent(table, listData, isSelected, hasFocus, row, column);
    }

    @Override
    protected JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingRenderer.label.None"));
            this.label.setVerticalAlignment(1);
        }
        return this.label;
    }
}

