/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.renderer;

import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SingleValueRenderer
implements TableCellRenderer {
    private JLabel label;
    private FirewallRulePanel firewallRulePanel;

    public SingleValueRenderer(FirewallRulePanel firewallRulePanel) {
        this.firewallRulePanel = firewallRulePanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel comp = this.getLabel();
        Color[] colors = this.firewallRulePanel.getColor(table, row, column);
        Font font = this.firewallRulePanel.getFont(table, row);
        if (value instanceof String) {
            comp.setText((String)value);
        } else if (value instanceof Integer) {
            comp.setHorizontalAlignment(0);
            comp.setText(value.toString());
        } else if (value instanceof LabelObject) {
            comp.setHorizontalAlignment(2);
            comp.setText(((LabelObject)value).getText());
        }
        comp.setForeground(colors[0]);
        comp.setBackground(colors[1]);
        comp.setFont(font);
        comp.setVerticalAlignment(1);
        comp.setBorder(this.firewallRulePanel.getCellBorder());
        return comp;
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel("", 2);
            this.label.setOpaque(true);
        } else {
            this.label.setText("");
            this.label.setIcon(null);
            this.label.setHorizontalAlignment(2);
        }
        return this.label;
    }
}

