/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.renderer;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ListObjectCellRenderer
implements TableCellRenderer {
    protected JList<Object> list;
    protected MyListCellRenderer listCellRenderer = new MyListCellRenderer();
    protected JLabel label;
    protected FirewallRulePanel firewallRulePanel;
    protected Color[] colors;
    protected Font font;

    public ListObjectCellRenderer(FirewallRulePanel firewallRulePanel) {
        this.firewallRulePanel = firewallRulePanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ArrayList listData;
        JComponent comp = null;
        this.colors = this.firewallRulePanel.getColor(table, row, column);
        this.font = this.firewallRulePanel.getFont(table, row);
        if (value != null && value instanceof ArrayList && (listData = (ArrayList)value).size() != 0) {
            comp = this.getList();
            if (this.list != null) {
                this.getList().setListData((Object[])listData.toArray());
            }
        }
        if (comp == null) {
            comp = this.getLabel();
        }
        comp.setForeground(this.colors[0]);
        comp.setBackground(this.colors[1]);
        comp.setFont(this.font);
        comp.setBorder(this.firewallRulePanel.getCellBorder());
        return comp;
    }

    protected JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "ListObjectCellRenderer.label.Any"));
            this.label.setVerticalAlignment(1);
        }
        return this.label;
    }

    private JList<Object> getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setCellRenderer(this.listCellRenderer);
        }
        return this.list;
    }

    class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                if (value instanceof LabelObject) {
                    this.setText(((LabelObject)value).getText());
                } else if (value instanceof JLabel) {
                    this.setText(((JLabel)value).getText());
                }
                this.setBackground(ListObjectCellRenderer.this.colors[1]);
                this.setForeground(ListObjectCellRenderer.this.colors[0]);
                this.setFont(ListObjectCellRenderer.this.font);
            }
            return this;
        }
    }
}

