/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.popup;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulesTableModel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ActionObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class TrackingPopup
extends JPopupMenu {
    private static final long serialVersionUID = 4871909917907556653L;
    private JCheckBoxMenuItem sendEmailCheck;
    private Action sendEmailAction;
    private JRadioButtonMenuItem jRBYes;
    private JRadioButtonMenuItem jRBNo;
    private Action yesTrafficLogAction;
    private Action noTrafficLogAction;
    private FirewallRulePanel.JRuleTable rulesTable;
    private JCheckBoxMenuItem trafficLogCheck;
    private JCheckBoxMenuItem packetLogCheck;
    private Action writeToTrafficLogAction;
    private Action writeToPacketLogAction;
    private boolean isMacRulePanel = false;

    public TrackingPopup(boolean isMacRulePanel) {
        this.isMacRulePanel = isMacRulePanel;
        this.init();
    }

    private void init() {
        if (LicenseObject.getInstance().isSBProduct()) {
            ButtonGroup group = new ButtonGroup();
            this.jRBYes = new JRadioButtonMenuItem(this.getTrafficLogYes());
            this.jRBNo = new JRadioButtonMenuItem(this.getTrafficLogNo());
            group.add(this.jRBYes);
            group.add(this.jRBNo);
            this.add(this.jRBYes);
            this.add(this.jRBNo);
        } else {
            this.trafficLogCheck = new JCheckBoxMenuItem(this.getWriteToTrafficLog());
            this.add(this.trafficLogCheck);
            if (!this.isMacRulePanel) {
                this.packetLogCheck = new JCheckBoxMenuItem(this.getWriteToPacketLog());
                this.add(this.packetLogCheck);
            }
        }
        this.sendEmailCheck = new JCheckBoxMenuItem(this.getSendEmail());
        this.add(this.sendEmailCheck);
    }

    public void setRulesTable(FirewallRulePanel.JRuleTable rulesTable) {
        this.rulesTable = rulesTable;
    }

    private FirewallRulesTableModel getTableModel() {
        return (FirewallRulesTableModel)this.rulesTable.getModel();
    }

    private FirewallRulePanel.JRuleTable getRulesTable() {
        return this.rulesTable;
    }

    private int getSelectedRowNumber() {
        return this.rulesTable.getSelectedRow();
    }

    private Action getTrafficLogYes() {
        if (this.yesTrafficLogAction == null) {
            this.yesTrafficLogAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.action.Yes")){
                private static final long serialVersionUID = -1364360854477625096L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (!TrackingPopup.this.checkForEmail()) {
                        return;
                    }
                    int selectedRow = TrackingPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = TrackingPopup.this.getTableModel().getRuleObject(selectedRow);
                    ActionObject actionObject = ruleObject.getAction();
                    actionObject.setTrafficLog(true);
                    actionObject.setPacketLog(false);
                    TrackingPopup.this.getTableModel().fireTableRowsUpdated(TrackingPopup.this.getSelectedRowNumber(), selectedRow);
                    TrackingPopup.this.getRulesTable().updateRowHeight(selectedRow, ruleObject);
                }
            };
        }
        return this.yesTrafficLogAction;
    }

    private Action getTrafficLogNo() {
        if (this.noTrafficLogAction == null) {
            this.noTrafficLogAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.action.No")){
                private static final long serialVersionUID = 72225854088810452L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int selectedRow = TrackingPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = TrackingPopup.this.getTableModel().getRuleObject(selectedRow);
                    ActionObject actionObject = ruleObject.getAction();
                    actionObject.setTrafficLog(false);
                    actionObject.setPacketLog(false);
                    actionObject.setAlert(false);
                    TrackingPopup.this.getTableModel().fireTableRowsUpdated(TrackingPopup.this.getSelectedRowNumber(), selectedRow);
                    TrackingPopup.this.getRulesTable().updateRowHeight(selectedRow, ruleObject);
                }
            };
        }
        return this.noTrafficLogAction;
    }

    private Action getSendEmail() {
        if (this.sendEmailAction == null) {
            this.sendEmailAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.action.SendEmailAlert")){
                private static final long serialVersionUID = 7331585963939663376L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (LicenseObject.getInstance().isSBProduct() && !TrackingPopup.this.checkForYesLog() || !LicenseObject.getInstance().isSBProduct() && !TrackingPopup.this.checkForTrafficLog()) {
                        return;
                    }
                    int selectedRow = TrackingPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = TrackingPopup.this.getTableModel().getRuleObject(selectedRow);
                    ActionObject actionObject = ruleObject.getAction();
                    actionObject.setAlert(TrackingPopup.this.sendEmailCheck.isSelected());
                    TrackingPopup.this.getTableModel().fireTableRowsUpdated(TrackingPopup.this.getSelectedRowNumber(), selectedRow);
                    TrackingPopup.this.getRulesTable().updateRowHeight(selectedRow, ruleObject);
                }
            };
        }
        return this.sendEmailAction;
    }

    private boolean checkForYesLog() {
        if (this.jRBYes == null) {
            return false;
        }
        if (this.sendEmailCheck.getState() && !this.jRBYes.isSelected()) {
            if (JOptionPane.showConfirmDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.message.EnableAlertAndTrafficLog"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.title.EnableAlertAndTrafficLog"), 0) == 0) {
                this.jRBYes.doClick();
                return true;
            }
            this.sendEmailCheck.setState(false);
            return false;
        }
        return true;
    }

    private boolean checkForEmail() {
        if (this.sendEmailCheck == null) {
            return true;
        }
        if (LicenseObject.getInstance().isSBProduct() && !this.jRBYes.isSelected() && this.sendEmailCheck.getState() || !LicenseObject.getInstance().isSBProduct() && !this.trafficLogCheck.getState() && this.sendEmailCheck.getState()) {
            if (JOptionPane.showConfirmDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.message.DisableAlertAndTrafficLog"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.title.DisableAlertAndTrafficLog"), 0) == 0) {
                this.sendEmailCheck.doClick();
                return true;
            }
            if (LicenseObject.getInstance().isSBProduct()) {
                this.jRBYes.setSelected(false);
            } else {
                this.trafficLogCheck.setState(false);
            }
            return false;
        }
        return true;
    }

    public void show(MouseEvent ev, int rowNumber) {
        if (rowNumber == -1) {
            super.show(ev.getComponent(), ev.getX(), ev.getY());
            return;
        }
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(rowNumber);
        ActionObject actionObject = ruleObject.getAction();
        Boolean sendMail = actionObject.getSendEmail();
        Boolean trafficLog = actionObject.getTrafficLog();
        if (LicenseObject.getInstance().isSBProduct()) {
            if (trafficLog.booleanValue()) {
                this.jRBYes.setSelected(true);
            } else {
                this.jRBNo.setSelected(true);
            }
        } else {
            this.trafficLogCheck.setSelected(trafficLog);
            if (!this.isMacRulePanel) {
                Boolean packetLog = actionObject.getPacketLog();
                this.packetLogCheck.setSelected(packetLog);
            }
        }
        this.sendEmailCheck.setSelected(sendMail);
        super.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    private Action getWriteToTrafficLog() {
        if (this.writeToTrafficLogAction == null) {
            this.writeToTrafficLogAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.action.WriteTrafficLog")){
                private static final long serialVersionUID = 2452737105800794226L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (!TrackingPopup.this.checkForEmail()) {
                        return;
                    }
                    int selectedRow = TrackingPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = TrackingPopup.this.getTableModel().getRuleObject(selectedRow);
                    ActionObject actionObject = ruleObject.getAction();
                    actionObject.setTrafficLog(TrackingPopup.this.trafficLogCheck.isSelected());
                    TrackingPopup.this.getTableModel().fireTableRowsUpdated(TrackingPopup.this.getSelectedRowNumber(), selectedRow);
                    TrackingPopup.this.getRulesTable().updateRowHeight(selectedRow, ruleObject);
                }
            };
        }
        return this.writeToTrafficLogAction;
    }

    private Action getWriteToPacketLog() {
        if (this.writeToPacketLogAction == null) {
            this.writeToPacketLogAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.action.WritePacketLog")){
                private static final long serialVersionUID = 1698973310803674357L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int selectedRow = TrackingPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = TrackingPopup.this.getTableModel().getRuleObject(selectedRow);
                    ActionObject actionObject = ruleObject.getAction();
                    actionObject.setPacketLog(TrackingPopup.this.packetLogCheck.isSelected());
                    TrackingPopup.this.getTableModel().fireTableRowsUpdated(TrackingPopup.this.getSelectedRowNumber(), selectedRow);
                    TrackingPopup.this.getRulesTable().updateRowHeight(selectedRow, ruleObject);
                }
            };
        }
        return this.writeToPacketLogAction;
    }

    private boolean checkForTrafficLog() {
        if (this.trafficLogCheck == null) {
            return false;
        }
        if (this.sendEmailCheck.getState() && !this.trafficLogCheck.getState()) {
            if (JOptionPane.showConfirmDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.message.EnableAlertAndTrafficLog"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "TrackingPopup.title.EnableAlertAndTrafficLog"), 0) == 0) {
                this.trafficLogCheck.doClick();
                return true;
            }
            this.sendEmailCheck.setState(false);
            return false;
        }
        return true;
    }
}

