/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.popup;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulesTableModel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ScreenSaverObject;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;

public class ScreenSaverPopup
extends JPopupMenu {
    private static final long serialVersionUID = 5769283113148219805L;
    private JTable rulesTable;
    private Action screenSaverOnAction;
    private Action screenSaverOffAction;
    private Action screenSaverAnyAction;
    private JRadioButtonMenuItem on;
    private JRadioButtonMenuItem off;
    private JRadioButtonMenuItem any;
    private static final String onText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "ScreenSaverPopup.action.On");
    private static final String offText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "ScreenSaverPopup.action.Off");
    private static final String anyText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "ScreenSaverPopup.action.Any");

    public ScreenSaverPopup() {
        this.init();
    }

    private void init() {
        this.on = new JRadioButtonMenuItem(this.getScreenSaverOn());
        this.off = new JRadioButtonMenuItem(this.getScreenSaverOff());
        this.any = new JRadioButtonMenuItem(this.getScreenSaverAny());
        ButtonGroup group = new ButtonGroup();
        group.add(this.on);
        group.add(this.off);
        group.add(this.any);
        this.add(this.on);
        this.add(this.off);
        this.add(this.any);
    }

    public void setRulesTable(JTable rulesTable) {
        this.rulesTable = rulesTable;
    }

    private FirewallRulesTableModel getTableModel() {
        return (FirewallRulesTableModel)this.rulesTable.getModel();
    }

    private int getSelectedRowNumber() {
        return this.rulesTable.getSelectedRow();
    }

    private Action getScreenSaverOn() {
        if (this.screenSaverOnAction == null) {
            this.screenSaverOnAction = new AbstractAction(onText){
                private static final long serialVersionUID = -4014522904071240209L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedRow = ScreenSaverPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = ScreenSaverPopup.this.getTableModel().getRuleObject(selectedRow);
                    ScreenSaverObject screenSaverObject = ruleObject.getScreenSaver();
                    screenSaverObject.setValue(onText);
                    ruleObject.setScreenSaver(screenSaverObject);
                    ScreenSaverPopup.this.getTableModel().fireTableRowsUpdated(selectedRow, selectedRow);
                }
            };
        }
        return this.screenSaverOnAction;
    }

    private Action getScreenSaverOff() {
        if (this.screenSaverOffAction == null) {
            this.screenSaverOffAction = new AbstractAction(offText){
                private static final long serialVersionUID = -5105550511585493020L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedRow = ScreenSaverPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = ScreenSaverPopup.this.getTableModel().getRuleObject(selectedRow);
                    ScreenSaverObject screenSaverObject = ruleObject.getScreenSaver();
                    screenSaverObject.setValue(offText);
                    ruleObject.setScreenSaver(screenSaverObject);
                    ScreenSaverPopup.this.getTableModel().fireTableRowsUpdated(selectedRow, selectedRow);
                }
            };
        }
        return this.screenSaverOffAction;
    }

    private Action getScreenSaverAny() {
        if (this.screenSaverAnyAction == null) {
            this.screenSaverAnyAction = new AbstractAction(anyText){
                private static final long serialVersionUID = 1394214434768594343L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedRow = ScreenSaverPopup.this.getSelectedRowNumber();
                    FirewallRuleObject ruleObject = ScreenSaverPopup.this.getTableModel().getRuleObject(selectedRow);
                    ScreenSaverObject screenSaverObject = ruleObject.getScreenSaver();
                    screenSaverObject.setValue(anyText);
                    ruleObject.setScreenSaver(screenSaverObject);
                    ScreenSaverPopup.this.getTableModel().fireTableRowsUpdated(selectedRow, selectedRow);
                }
            };
        }
        return this.screenSaverAnyAction;
    }

    public void show(MouseEvent e, int rowNumber) {
        if (rowNumber == -1) {
            super.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(rowNumber);
        ScreenSaverObject screenSaverObject = ruleObject.getScreenSaver();
        String value = screenSaverObject.getValue();
        this.on.setSelected(value.equals(onText));
        this.off.setSelected(value.equals(offText));
        this.any.setSelected(value.equals(anyText));
        super.show(e.getComponent(), e.getX(), e.getY());
    }
}

