/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.popup;

import com.sygate.scm.common.configobject.schema.FwInterfaceContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkInterface;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulesTableModel;
import com.sygate.scm.console.ui.policy.firewall.NetworkInterfaceHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.NetworkAdapterPanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class InterfacePopup
extends JPopupMenu {
    private static final long serialVersionUID = -8555530731194663522L;
    public static final String ALL_ADAPTER = "All Adapters";
    public static final String DIAL_UP = "Dial-up";
    public static final String ETHERNET = "Ethernet";
    public static final String ANY_VPN = "Any VPN";
    public static final String WIRELESS = "Wireless";
    private Action moreAdaptersAction;
    private Hashtable<String, JCheckBoxMenuItem> interfaceMenuItems = new Hashtable();
    private HashMap<String, NetworkInterfaceGroupObject> allIinterfaceGroups = new HashMap();
    private FirewallRulePanel.JRuleTable rulesTable;
    JCheckBoxMenuItem allAdapter;
    JCheckBoxMenuItem wireless;
    JCheckBoxMenuItem dialup;
    JCheckBoxMenuItem ethernet;
    private ArrayList<String> menuAdapterList;
    private HashMap<String, String> keymap = new HashMap();

    public InterfacePopup() {
        this.menuAdapterList = new ArrayList();
        this.menuAdapterList.add(ALL_ADAPTER);
        this.menuAdapterList.add(DIAL_UP);
        this.menuAdapterList.add(ETHERNET);
        this.menuAdapterList.add(ANY_VPN);
        this.menuAdapterList.add(WIRELESS);
        this.init();
    }

    private void init() {
        this.createMenuItemsForInterfaces();
    }

    private void createMenuItemsForInterfaces() {
        ArrayList<NetworkInterfaceGroupObject> existingInterfaceGroups = NetworkInterfaceHandler.getInstance().getInterfaceGroups();
        for (int i = 0; i < existingInterfaceGroups.size(); ++i) {
            NetworkInterfaceGroupObject groupObject = existingInterfaceGroups.get(i);
            FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
            String interfaceName = group.getName();
            Long objAttr = group.getOptObjAttributes();
            if (objAttr != null && objAttr == 1L && this.menuAdapterList.contains(interfaceName)) {
                String itemName = group.getOptDisplayName() == null ? group.getName() : group.getOptDisplayName();
                this.keymap.put(itemName, interfaceName);
                JCheckBoxMenuItem newItem = new JCheckBoxMenuItem(itemName);
                this.add(newItem);
                this.interfaceMenuItems.put(group.getId(), newItem);
                if (ALL_ADAPTER.equalsIgnoreCase(interfaceName)) {
                    this.addSeparator();
                }
            }
            this.allIinterfaceGroups.put(interfaceName, groupObject);
        }
        this.addSeparator();
        this.add(this.getMoreAdapters());
    }

    public void show(MouseEvent e, int rowNumber) {
        if (rowNumber == -1) {
            super.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        List<NetworkInterfaceGroupObject> selectedInterfaceObjects = this.getNetworkInterfaceObjects();
        for (int i = 0; i < selectedInterfaceObjects.size(); ++i) {
            NetworkInterfaceGroupObject groupObject = selectedInterfaceObjects.get(i);
            FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
            String id = group.getId();
            if (!this.interfaceMenuItems.containsKey(id)) continue;
            JCheckBoxMenuItem item = this.interfaceMenuItems.get(id);
            item.setSelected(true);
        }
        Enumeration<JCheckBoxMenuItem> en = this.interfaceMenuItems.elements();
        while (en.hasMoreElements()) {
            JCheckBoxMenuItem item = en.nextElement();
            item.addActionListener(this.getActionListener());
        }
        super.show(e.getComponent(), e.getX(), e.getY());
    }

    private FirewallRulesTableModel getTableModel() {
        return (FirewallRulesTableModel)this.rulesTable.getModel();
    }

    private FirewallRulePanel.JRuleTable getRulesTable() {
        return this.rulesTable;
    }

    private int getSelectedRowNumber() {
        return this.rulesTable.getSelectedRow();
    }

    private int getSelectedColumnNumber() {
        return this.rulesTable.getSelectedColumn();
    }

    private Action getMoreAdapters() {
        if (this.moreAdaptersAction == null) {
            this.moreAdaptersAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "InterfacePopup.action.MoreAdapters")){
                private static final long serialVersionUID = -8617954638513079279L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FirewallRuleObject ruleObject = InterfacePopup.this.getTableModel().getRuleObject(InterfacePopup.this.getSelectedRowNumber());
                    NetworkAdapterPanel dialog = new NetworkAdapterPanel(ruleObject, InterfacePopup.this.getTableModel().getRuleObject(InterfacePopup.this.getSelectedRowNumber()).getInterfaceTrigger());
                    if (!dialog.isCancelled()) {
                        int selectedRow = InterfacePopup.this.getSelectedRowNumber();
                        ArrayList<NetworkInterfaceGroupObject> newInterfaceObjects = ruleObject.getInterfaces();
                        InterfacePopup.this.rulesTable.setValueAt(newInterfaceObjects, selectedRow, InterfacePopup.this.getSelectedColumnNumber());
                        InterfacePopup.this.getRulesTable().updateRowHeight(selectedRow, ruleObject);
                        InterfacePopup.this.getTableModel().getRuleObject(InterfacePopup.this.getSelectedRowNumber()).setInterfaceTrigger(dialog.getInterfaceTrigger());
                        InterfacePopup.this.updateRowHeight();
                    }
                }
            };
        }
        return this.moreAdaptersAction;
    }

    private ActionListener getActionListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfacePopup.this.updateSeletedInterfaces(e);
            }
        };
        return actionListener;
    }

    private void updateSeletedInterfaces(ActionEvent e) {
        NetworkInterfaceGroupObject groupObject;
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
        String selectedItem = this.keymap.get(item.getText());
        if (!item.isSelected() && this.getNetworkInterfaceObjects().size() == 1) {
            if (selectedItem.equalsIgnoreCase(ALL_ADAPTER)) {
                item.setSelected(true);
                return;
            }
            groupObject = this.allIinterfaceGroups.get(ALL_ADAPTER);
            JCheckBoxMenuItem newItem = this.interfaceMenuItems.get(groupObject.getFwInterfaceGroup().getId());
            newItem.doClick();
        }
        groupObject = this.allIinterfaceGroups.get(selectedItem);
        if (item.isSelected()) {
            if (!selectedItem.equalsIgnoreCase(ALL_ADAPTER)) {
                NetworkInterfaceGroupObject gObject = this.allIinterfaceGroups.get(ALL_ADAPTER);
                if (gObject != null) {
                    this.deleteReferenceFromTrigger(gObject);
                }
            } else {
                this.deleteAllFromTriggerExceptAllAdapter();
            }
            this.updateReferenceToTrigger(groupObject);
        } else {
            this.deleteReferenceFromTrigger(groupObject);
        }
        this.updateRowHeight();
    }

    private void updateRowHeight() {
        int selectedRow = this.getSelectedRowNumber();
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(selectedRow);
        ArrayList<NetworkInterfaceGroupObject> newInterfaceObjects = ruleObject.getInterfaces();
        this.rulesTable.setValueAt(newInterfaceObjects, selectedRow, this.getSelectedColumnNumber());
        this.getRulesTable().updateRowHeight(selectedRow, ruleObject);
    }

    private void updateReferenceToTrigger(NetworkInterfaceGroupObject groupObject) {
        FwNetworkInterfaceGroup group;
        String groupId;
        int selectedRow = this.getSelectedRowNumber();
        ArrayList<String> groupReferenceIDs = this.getNetworkInterfaceReferenceIDs();
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(selectedRow);
        FwNetworkInterfaceTrigger interfaceTrigger = ruleObject.getInterfaceTrigger();
        if (interfaceTrigger == null) {
            interfaceTrigger = new FwNetworkInterfaceTrigger();
            ruleObject.setInterfaceTrigger(interfaceTrigger);
            ruleObject.setInterfaces(new ArrayList<NetworkInterfaceGroupObject>());
        }
        if (!groupReferenceIDs.contains(groupId = (group = groupObject.getFwInterfaceGroup()).getId())) {
            ObjReference ref = new ObjReference();
            ref.setTargetId(group.getId());
            ref.setTargetType(group.getObjectTypeName());
            ref.setName(group.getName());
            interfaceTrigger.addObjReference(ref);
            this.getNetworkInterfaceObjects().add(groupObject);
            groupReferenceIDs.remove(groupId);
        }
    }

    private void deleteReferenceFromTrigger(NetworkInterfaceGroupObject groupObject) {
        System.out.println("Inside Delete");
        int selectedRow = this.getSelectedRowNumber();
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(selectedRow);
        FwNetworkInterfaceTrigger interfaceTrigger = ruleObject.getInterfaceTrigger();
        if (interfaceTrigger == null) {
            interfaceTrigger = new FwNetworkInterfaceTrigger();
            ruleObject.setInterfaceTrigger(interfaceTrigger);
        }
        Vector references = interfaceTrigger.getObjReference();
        FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
        String groupId = group.getId();
        for (int i = 0; i < references.size(); ++i) {
            ObjReference ref = (ObjReference)references.get(i);
            if (!ref.getTargetId().equals(groupId)) continue;
            System.out.println("delete Item" + groupId);
            interfaceTrigger.removeObjReference(ref);
            this.getNetworkInterfaceObjects().remove(i);
        }
    }

    private void deleteAllFromTriggerExceptAllAdapter() {
        NetworkInterfaceGroupObject groupObject;
        System.out.println("Inside Delete but not all adapters");
        int selectedRow = this.getSelectedRowNumber();
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(selectedRow);
        FwNetworkInterfaceTrigger interfaceTrigger = ruleObject.getInterfaceTrigger();
        if (interfaceTrigger == null) {
            interfaceTrigger = new FwNetworkInterfaceTrigger();
            ruleObject.setInterfaceTrigger(interfaceTrigger);
        }
        if ((groupObject = this.allIinterfaceGroups.get(ALL_ADAPTER)) == null) {
            return;
        }
        FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
        String groupId = group.getId();
        for (ObjReference ref : interfaceTrigger.getObjReference()) {
            if (ref.getTargetId().equals(groupId)) continue;
            System.out.println("delete Item" + groupId);
            interfaceTrigger.removeObjReference(ref);
        }
        Iterator<NetworkInterfaceGroupObject> it = this.getNetworkInterfaceObjects().iterator();
        while (it.hasNext()) {
            NetworkInterfaceGroupObject gr = it.next();
            if (gr.getFwInterfaceGroup().getId().equals(groupId)) continue;
            it.remove();
        }
        FwInterfaceContainer cont = interfaceTrigger.getOptFwInterfaceContainer();
        if (cont != null) {
            for (int i = 0; i < cont.getFwNetworkInterfaceCount(); ++i) {
                FwNetworkInterface inter = cont.getFwNetworkInterface(i);
                inter.setOptEnable(Boolean.valueOf(false));
            }
        }
    }

    private List<NetworkInterfaceGroupObject> getNetworkInterfaceObjects() {
        int rowNumber = this.getSelectedRowNumber();
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(rowNumber);
        return ruleObject.getInterfaces();
    }

    private ArrayList<String> getNetworkInterfaceReferenceIDs() {
        int rowNumber = this.getSelectedRowNumber();
        ArrayList<String> interfaceGroupIDs = new ArrayList<String>();
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(rowNumber);
        ArrayList<NetworkInterfaceGroupObject> networkInterfaceObjects = ruleObject.getInterfaces();
        int count = networkInterfaceObjects.size();
        for (int i = 0; i < count; ++i) {
            NetworkInterfaceGroupObject groupObject = (NetworkInterfaceGroupObject)networkInterfaceObjects.get(i);
            String groupId = groupObject.getFwInterfaceGroup().getId();
            interfaceGroupIDs.add(groupId);
        }
        return interfaceGroupIDs;
    }

    public void setRulesTable(FirewallRulePanel.JRuleTable rulesTable) {
        this.rulesTable = rulesTable;
    }
}

