/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.popup;

import com.sygate.scm.common.configobject.schema.PacketProcess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulesTableModel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ActionObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;

public class ActionPopup
extends JPopupMenu {
    private static final long serialVersionUID = 2820080659689820976L;
    private JRadioButtonMenuItem allow;
    private JRadioButtonMenuItem drop;
    private JRadioButtonMenuItem ask;
    private Action allowAction;
    private Action dropAction;
    private Action askAction;
    private static final String allowText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "ActionPopup.action.Allow");
    private static final String dropText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "ActionPopup.action.Drop");
    private static final String askText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "ActionPopup.action.Ask");
    private JTable rulesTable;

    public ActionPopup(boolean isMacRulePanel) {
        this.init(isMacRulePanel);
    }

    private void init(boolean isMacRulePanel) {
        this.allow = new JRadioButtonMenuItem(this.getAllow());
        this.drop = new JRadioButtonMenuItem(this.getDrop());
        this.ask = new JRadioButtonMenuItem(this.getAsk());
        ButtonGroup group = new ButtonGroup();
        group.add(this.allow);
        group.add(this.drop);
        this.add(this.allow);
        this.add(this.drop);
        if (!LicenseObject.getInstance().isSBProduct() && !isMacRulePanel) {
            group.add(this.ask);
            this.add(this.ask);
        }
    }

    public void setRulesTable(JTable rulesTable) {
        this.rulesTable = rulesTable;
    }

    private FirewallRulesTableModel getTableModel() {
        return (FirewallRulesTableModel)this.rulesTable.getModel();
    }

    private int getSelectedRowNumber() {
        return this.rulesTable.getSelectedRow();
    }

    private int getSelectedColumnNumber() {
        return this.rulesTable.getSelectedColumn();
    }

    private Action getAllow() {
        if (this.allowAction == null) {
            this.allowAction = new AbstractAction(allowText){
                private static final long serialVersionUID = -1820758177359357954L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionPopup.this.rulesTable.setValueAt("Allow", ActionPopup.this.getSelectedRowNumber(), ActionPopup.this.getSelectedColumnNumber());
                }
            };
        }
        return this.allowAction;
    }

    private Action getDrop() {
        if (this.dropAction == null) {
            this.dropAction = new AbstractAction(dropText){
                private static final long serialVersionUID = 9134507866301270952L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionPopup.this.rulesTable.setValueAt("Block", ActionPopup.this.getSelectedRowNumber(), ActionPopup.this.getSelectedColumnNumber());
                }
            };
        }
        return this.dropAction;
    }

    private Action getAsk() {
        if (this.askAction == null) {
            this.askAction = new AbstractAction(askText){
                private static final long serialVersionUID = -7794875833240727802L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionPopup.this.rulesTable.setValueAt("Ask", ActionPopup.this.getSelectedRowNumber(), ActionPopup.this.getSelectedColumnNumber());
                }
            };
        }
        return this.askAction;
    }

    public void show(MouseEvent e, int rowNumber) {
        if (rowNumber == -1) {
            super.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        FirewallRuleObject ruleObject = this.getTableModel().getRuleObject(rowNumber);
        ActionObject actionObject = ruleObject.getAction();
        PacketProcess packetProc = actionObject.getPacketProcess();
        Integer process = null;
        if (packetProc != null) {
            process = packetProc.getPacketProcess();
        }
        this.ask.setSelected(PacketProcess.ASK.equals(process));
        this.drop.setSelected(PacketProcess.DROP.equals(process));
        this.allow.setSelected(PacketProcess.PASS.equals(process));
        super.show(e.getComponent(), e.getX(), e.getY());
    }
}

