/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.SoTime;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class ScheduleObject
implements TableRow,
LabelObject {
    private static final DateFormatSymbols symbols = new DateFormatSymbols();
    private static final String[] MONTHS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.MonthsAll"), symbols.getMonths()[0], symbols.getMonths()[1], symbols.getMonths()[2], symbols.getMonths()[3], symbols.getMonths()[4], symbols.getMonths()[5], symbols.getMonths()[6], symbols.getMonths()[7], symbols.getMonths()[8], symbols.getMonths()[9], symbols.getMonths()[10], symbols.getMonths()[11]};
    private static final String[] WEEK_DAYS = new String[]{symbols.getWeekdays()[1], symbols.getWeekdays()[2], symbols.getWeekdays()[3], symbols.getWeekdays()[4], symbols.getWeekdays()[5], symbols.getWeekdays()[6], symbols.getWeekdays()[7]};
    private static final String everyDay = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.EveryDay");
    private SoTime time;
    private String name;
    private String endTime;

    public ScheduleObject() {
        this.time = new SoTime();
        this.time.setInclude(Boolean.TRUE);
    }

    public ScheduleObject(SoTime time) {
        this.time = time;
    }

    private Boolean getExclude() {
        boolean isIncluded = this.time.getInclude();
        return !isIncluded;
    }

    private String getDescription() {
        return this.toString();
    }

    private String formatTime(String strTime) {
        String timeStr = "";
        DateFormat timeFormat = DateFormat.getTimeInstance(2, Locale.getDefault());
        timeFormat.setTimeZone(Utility.getLocalTimeZone());
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        try {
            timeStr = timeFormat.format(sdf.parse(strTime));
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            return null;
        }
        return timeStr;
    }

    public SoTime getSoTime() {
        return this.time;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getInclude() {
        return this.time.getInclude();
    }

    public void setInclude(Boolean include) {
        this.time.setInclude(include);
    }

    public String getStartDate() {
        return this.time.getStartDate();
    }

    public void setStartDate(String startDate) {
        this.time.setStartDate(startDate);
    }

    public String getStartDayOfWeek() {
        return this.time.getOptStartDayOfWeek();
    }

    public void setStartDayOfWeek(String startDayOfWeek) {
        this.time.setOptStartDayOfWeek(startDayOfWeek);
    }

    public String getStartTime() {
        return this.time.getStartTime();
    }

    public void setStartTime(String startTime) {
        this.time.setStartTime(startTime);
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getEndTime() {
        if (this.endTime == null) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            try {
                Date startTime = format.parse(this.time.getStartTime());
                Calendar cal = Utility.getCalendarInstance();
                cal.setTime(startTime);
                cal.add(13, this.time.getTimeLast());
                int h = cal.get(11);
                int m = cal.get(12);
                int s = cal.get(13);
                String hour = h < 10 ? "0" + h : "" + h;
                String minute = m < 10 ? "0" + m : "" + m;
                String second = s < 10 ? "0" + s : "" + s;
                return hour + ":" + minute + ":" + second;
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
                return null;
            }
        }
        return this.endTime;
    }

    public Integer getTimeLast() {
        return this.time.getTimeLast();
    }

    public void setTimeLast(Integer timeLast) {
        this.time.setTimeLast(timeLast);
    }

    public String toString() {
        String str = "";
        String patternBoth = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.StartEndOnDayInMonth");
        String patternNoMonth = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.StartEndOnDay");
        String patternNoDay = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.StartEndInMonth");
        String patternNoDayNoMonth = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.StartEnd");
        str = !this.getMonth().equalsIgnoreCase(MONTHS[0]) && !this.getDay().equalsIgnoreCase(everyDay) ? MessageFormat.format(patternBoth, this.formatTime(this.getStartTime()), this.formatTime(this.getEndTime()), this.getDay(), this.getMonth()) : (this.getMonth().equalsIgnoreCase(MONTHS[0]) && !this.getDay().equalsIgnoreCase(everyDay) ? MessageFormat.format(patternNoMonth, this.formatTime(this.getStartTime()), this.formatTime(this.getEndTime()), this.getDay(), this.getMonth()) : (!this.getMonth().equalsIgnoreCase(MONTHS[0]) && this.getDay().equalsIgnoreCase(everyDay) ? MessageFormat.format(patternNoDay, this.formatTime(this.getStartTime()), this.formatTime(this.getEndTime()), this.getDay(), this.getMonth()) : MessageFormat.format(patternNoDayNoMonth, this.formatTime(this.getStartTime()), this.formatTime(this.getEndTime()), this.getDay(), this.getMonth())));
        return str;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getExclude();
            }
            case 1: {
                return this.getDescription();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public String getMonth() {
        String startDate = this.getStartDate();
        if (startDate != null) {
            String month = startDate.substring(0, 2);
            if (month.equals("*") || month.equals("*/")) {
                return MONTHS[0];
            }
            int monthIndex = Integer.parseInt(month);
            return MONTHS[monthIndex];
        }
        return MONTHS[0];
    }

    public String getDay() {
        StringTokenizer st;
        String dayofWeek = this.getStartDayOfWeek();
        HashSet<String> daySet = new HashSet<String>();
        if (dayofWeek != null) {
            st = new StringTokenizer(dayofWeek, ",");
            while (st.hasMoreTokens()) {
                daySet.add(st.nextToken());
            }
        }
        if (dayofWeek == null || daySet.size() == 7) {
            return everyDay;
        }
        if (daySet.size() == 5 && !daySet.contains("0") && !daySet.contains("6")) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.Weekdays");
        }
        if (daySet.size() == 2 && daySet.contains("0") && daySet.contains("6")) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ScheduleObject.Weekends");
        }
        st = new StringTokenizer(dayofWeek, ",");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("0")) {
                sb.append(WEEK_DAYS[0]);
                continue;
            }
            if (token.equals("1")) {
                if (sb.toString().length() > 0) {
                    sb.append(",");
                }
                sb.append(WEEK_DAYS[1]);
                continue;
            }
            if (token.equals("2")) {
                if (sb.toString().length() > 0) {
                    sb.append(",");
                }
                sb.append(WEEK_DAYS[2]);
                continue;
            }
            if (token.equals("3")) {
                if (sb.toString().length() > 0) {
                    sb.append(",");
                }
                sb.append(WEEK_DAYS[3]);
                continue;
            }
            if (token.equals("4")) {
                if (sb.toString().length() > 0) {
                    sb.append(",");
                }
                sb.append(WEEK_DAYS[4]);
                continue;
            }
            if (token.equals("5")) {
                if (sb.toString().length() > 0) {
                    sb.append(",");
                }
                sb.append(WEEK_DAYS[5]);
                continue;
            }
            if (!token.equals("6")) continue;
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(WEEK_DAYS[6]);
        }
        return sb.toString();
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                boolean isExcluded = (Boolean)value;
                this.setInclude(!isExcluded);
                break;
            }
        }
    }

    public ScheduleObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = this.time.getBytes();
            AbstractSchema newtime = AbstractSchema.readXML((byte[])copyArray);
            ScheduleObject newObj = new ScheduleObject((SoTime)newtime);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    @Override
    public ImageIcon getIcon() {
        if (this.time.getInclude().booleanValue()) {
            return ConsoleMain.activeTimeIcon;
        }
        if (!this.time.getInclude().booleanValue()) {
            return ConsoleMain.inactiveTimeIcon;
        }
        return ConsoleMain.timeIcon;
    }

    @Override
    public String getText() {
        return this.toString();
    }
}

