/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.RawEthernet;
import com.sygate.scm.common.configobject.schema.RawIcmp;
import com.sygate.scm.common.configobject.schema.RawIcmpv6;
import com.sygate.scm.common.configobject.schema.RawIp;
import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.configobject.schema.RawUdp;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleException;

public class ProtocolObject
implements TableRow {
    public static final int TCP = 0;
    public static final int IP = 1;
    public static final int UDP = 2;
    public static final int ICMP = 3;
    public static final int ETHERNET = 4;
    public static final int CUSTOM = 5;
    public static final int ICMPV6 = 6;
    private Object protocol;

    public ProtocolObject(Object protocol) {
        this.protocol = protocol;
    }

    public ProtocolObject() {
        RawTcp rawTcp = new RawTcp();
        rawTcp.setOptIncomingCall(Boolean.TRUE);
        this.protocol = rawTcp;
    }

    public String getType() {
        if (this.protocol instanceof RawTcp) {
            return "TCP";
        }
        if (this.protocol instanceof RawIp) {
            return "IP";
        }
        if (this.protocol instanceof RawUdp) {
            return "UDP";
        }
        if (this.protocol instanceof RawIcmp) {
            return "ICMP";
        }
        if (this.protocol instanceof RawIcmpv6) {
            return "ICMPv6";
        }
        if (this.protocol instanceof RawEthernet) {
            return "Ethernet";
        }
        return "Custom";
    }

    public String getContent() {
        if (this.protocol instanceof RawTcp) {
            Boolean coming;
            RawTcp tcp = (RawTcp)this.protocol;
            String localPort = tcp.getOptLocalPort();
            String remotePort = tcp.getOptRemotePort();
            String sourcePort = tcp.getOptSourcePort();
            String destPort = tcp.getOptDestinationPort();
            Object content = "";
            if (!this.isEmpty(localPort)) {
                content = (String)content + "[Local=" + localPort;
                if (!this.isEmpty(remotePort)) {
                    content = (String)content + "; ";
                }
            }
            if (!this.isEmpty(remotePort)) {
                if (((String)content).length() == 0) {
                    content = "[";
                }
                content = (String)content + "Remote=" + remotePort;
            }
            if (!this.isEmpty(sourcePort)) {
                content = (String)content + "[Source=" + sourcePort;
                if (!this.isEmpty(destPort)) {
                    content = (String)content + "; ";
                }
            }
            if (!this.isEmpty(destPort)) {
                if (((String)content).length() == 0) {
                    content = "[";
                }
                content = (String)content + "Destination=" + destPort;
            }
            if ((coming = tcp.getOptIncomingCall()) != null) {
                content = ((String)content).length() == 0 ? "[" : (String)content + "; ";
                content = (String)content + (coming == true ? "Incoming]" : "Outgoing]");
            } else {
                content = ((String)content).length() == 0 ? "" : (String)content + "]";
            }
            return content;
        }
        if (this.protocol instanceof RawIp) {
            RawIp ip = (RawIp)this.protocol;
            Boolean incoming = ip.getOptIncoming();
            String portNumber = ip.getOptProtocolNumber();
            Boolean fragment = ip.getOptFollowingFragment();
            Object content = "";
            if (!this.isEmpty(portNumber)) {
                content = (String)content + "[" + portNumber;
            }
            if (incoming != null) {
                content = ((String)content).length() == 0 ? "[" : (String)content + "; ";
                content = (String)content + (incoming == true ? "Incoming" : "Outgoing");
            }
            if (fragment != null && fragment.booleanValue()) {
                content = ((String)content).length() == 0 ? "[" : (String)content + ";";
                content = (String)content + "fragmented packets";
            }
            content = ((String)content).length() == 0 ? "" : (String)content + "]";
            return content;
        }
        if (this.protocol instanceof RawUdp) {
            RawUdp udp = (RawUdp)this.protocol;
            String localPort = udp.getOptLocalPort();
            String remotePort = udp.getOptRemotePort();
            String sourcePort = udp.getOptSourcePort();
            String destPort = udp.getOptDestinationPort();
            Object content = "";
            if (!this.isEmpty(localPort)) {
                content = (String)content + "[Local=" + localPort;
                if (!this.isEmpty(remotePort)) {
                    content = (String)content + "; ";
                }
            }
            if (!this.isEmpty(remotePort)) {
                if (((String)content).length() == 0) {
                    content = "[";
                }
                content = (String)content + "Remote=" + remotePort;
            }
            if (!this.isEmpty(sourcePort)) {
                content = (String)content + "[Source=" + sourcePort;
                if (!this.isEmpty(destPort)) {
                    content = (String)content + "; ";
                }
            }
            if (!this.isEmpty(destPort)) {
                if (((String)content).length() == 0) {
                    content = "[";
                }
                content = (String)content + "Destination=" + destPort;
            }
            Boolean coming = udp.getOptIncoming();
            Boolean comingCall = udp.getOptIncomingCall();
            if (comingCall != null) {
                content = ((String)content).length() == 0 ? "[" : (String)content + "; ";
                content = (String)content + (comingCall == true ? "Stateful Incoming]" : "Stateful Outgoing]");
            } else if (coming != null) {
                content = ((String)content).length() == 0 ? "[" : (String)content + "; ";
                content = (String)content + (coming == true ? "Incoming]" : "Outgoing]");
            } else {
                content = ((String)content).length() == 0 ? "" : (String)content + "]";
            }
            return content;
        }
        if (this.protocol instanceof RawIcmp) {
            RawIcmp icmp = (RawIcmp)this.protocol;
            String type = icmp.getOptIcmpType();
            String code = icmp.getOptIcmpCode();
            Boolean incoming = icmp.getOptIncoming();
            Object content = "";
            if (!this.isEmpty(type)) {
                content = (String)content + "[Type=" + type;
                if (!this.isEmpty(code)) {
                    content = (String)content + "; ";
                }
            }
            if (!this.isEmpty(code)) {
                if (((String)content).length() == 0) {
                    content = "[";
                }
                content = (String)content + "Code=" + code;
            }
            if (incoming != null) {
                content = ((String)content).length() == 0 ? "[" : (String)content + "; ";
                content = (String)content + (incoming == true ? "Incoming]" : "Outgoing]");
            } else {
                content = ((String)content).length() == 0 ? "" : (String)content + "]";
            }
            return content;
        }
        if (this.protocol instanceof RawIcmpv6) {
            RawIcmpv6 icmpv6 = (RawIcmpv6)this.protocol;
            String type = icmpv6.getOptIcmpv6Type();
            String code = icmpv6.getOptIcmpv6Code();
            Boolean incoming = icmpv6.getOptIncoming();
            Object content = "";
            if (!this.isEmpty(type)) {
                content = (String)content + "[Type=" + type;
                if (!this.isEmpty(code)) {
                    content = (String)content + "; ";
                }
            }
            if (!this.isEmpty(code)) {
                if (((String)content).length() == 0) {
                    content = "[";
                }
                content = (String)content + "Code=" + code;
            }
            if (incoming != null) {
                content = ((String)content).length() == 0 ? "[" : (String)content + "; ";
                content = (String)content + (incoming == true ? "Incoming]" : "Outgoing]");
            } else {
                content = ((String)content).length() == 0 ? "" : (String)content + "]";
            }
            return content;
        }
        if (this.protocol instanceof RawEthernet) {
            RawEthernet ethernet = (RawEthernet)this.protocol;
            Long proNumber = ethernet.getOptProtocolNumber();
            Long length = ethernet.getOptLength();
            Boolean incoming = ethernet.getOptIncoming();
            Object content = "";
            if (proNumber != null) {
                content = (String)content + "[Protocol=0x" + Long.toHexString(proNumber);
                if (length != null) {
                    content = (String)content + "; ";
                }
            }
            if (length != null) {
                if (((String)content).length() == 0) {
                    content = "[";
                }
                content = (String)content + "Length=" + length;
            }
            if (incoming != null) {
                content = ((String)content).length() == 0 ? "[" : (String)content + "; ";
                content = (String)content + (incoming == true ? "Incoming]" : "Outgoing]");
            } else {
                content = ((String)content).length() == 0 ? "" : (String)content + "]";
            }
            return content;
        }
        return null;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public Object getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Object protocol) {
        this.protocol = protocol;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getType();
            }
            case 1: {
                return this.getContent();
            }
        }
        return null;
    }

    public Class<String> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public ProtocolObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = ((ConfigObject)this.protocol).getBytes();
            AbstractSchema copyProtocol = AbstractSchema.readXML((byte[])copyArray);
            System.out.println("Copy Protocol:" + copyProtocol.getClass().getName());
            ProtocolObject newObj = new ProtocolObject(copyProtocol);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }
}

